/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.event.error;

import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.exception.ErrorInfo;
import me.ahoo.wow.event.DomainEvent;
import me.ahoo.wow.event.DomainEventExchange;
import me.ahoo.wow.event.error.ErrorDetails;
import me.ahoo.wow.event.error.EventFunctionError;
import me.ahoo.wow.event.error.EventFunctionErrorRepository;
import me.ahoo.wow.event.error.EventId;
import me.ahoo.wow.exception.WowExceptionKt;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.messaging.function.MessageFunction;
import me.ahoo.wow.messaging.handler.ErrorHandler;
import me.ahoo.wow.messaging.processor.ProcessorInfoKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \f2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/event/error/RecordEventFunctionErrorHandler;", "Lme/ahoo/wow/messaging/handler/ErrorHandler;", "Lme/ahoo/wow/event/DomainEventExchange;", "reporter", "Lme/ahoo/wow/event/error/EventFunctionErrorRepository;", "(Lme/ahoo/wow/event/error/EventFunctionErrorRepository;)V", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "throwable", "", "Companion", "wow-core"})
public final class RecordEventFunctionErrorHandler
implements ErrorHandler<DomainEventExchange<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventFunctionErrorRepository reporter;
    private static final Logger log = LoggerFactory.getLogger(RecordEventFunctionErrorHandler.class);

    public RecordEventFunctionErrorHandler(@NotNull EventFunctionErrorRepository reporter) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.reporter = reporter;
    }

    @Override
    @NotNull
    public Mono<Void> handle(@NotNull DomainEventExchange<?> exchange, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (log.isErrorEnabled()) {
            log.error(throwable.getMessage(), throwable);
        }
        MessageFunction<Object, DomainEventExchange<?>, Mono<?>> messageFunction = exchange.getEventFunction();
        if (messageFunction == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MessageFunction<Object, DomainEventExchange<?>, Mono<?>> eventFunction = messageFunction;
        ErrorInfo errorInfo = WowExceptionKt.asErrorInfo(throwable);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        EventFunctionError eventFunctionError = new EventFunctionError(string, new EventId(((DomainEvent)exchange.getMessage()).getId(), ((DomainEvent)exchange.getMessage()).getAggregateId()), eventFunction.getFunctionKind(), ProcessorInfoKt.materialize(eventFunction), new ErrorDetails(errorInfo.getErrorCode(), errorInfo.getErrorMsg(), ExceptionsKt.stackTraceToString((Throwable)throwable)), System.currentTimeMillis());
        return this.reporter.record(eventFunctionError);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/event/error/RecordEventFunctionErrorHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

