/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.event.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.annotation.AggregateAnnotationParser;
import me.ahoo.wow.api.annotation.Event;
import me.ahoo.wow.event.metadata.EventMetadata;
import me.ahoo.wow.infra.accessor.property.PropertyGetter;
import me.ahoo.wow.infra.reflection.ClassMetadata;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import me.ahoo.wow.metadata.CacheableMetadataParser;
import me.ahoo.wow.modeling.matedata.NamedAggregateGetter;
import me.ahoo.wow.modeling.matedata.NamedAggregateGetterKt;
import me.ahoo.wow.naming.annotation.PascalToSnakeConverterKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/event/annotation/EventMetadataParser;", "Lme/ahoo/wow/metadata/CacheableMetadataParser;", "Ljava/lang/Class;", "Lme/ahoo/wow/event/metadata/EventMetadata;", "()V", "parseAsMetadata", "type", "EventMetadataVisitor", "wow-core"})
public final class EventMetadataParser
extends CacheableMetadataParser<Class<?>, EventMetadata<?>> {
    @NotNull
    public static final EventMetadataParser INSTANCE = new EventMetadataParser();

    private EventMetadataParser() {
    }

    @Override
    @NotNull
    public EventMetadata<?> parseAsMetadata(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        EventMetadataVisitor visitor = new EventMetadataVisitor(type);
        ClassMetadata.visit(type, visitor);
        return visitor.asMetadata();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/event/annotation/EventMetadataParser$EventMetadataVisitor;", "E", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "eventType", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "aggregateIdGetter", "Lme/ahoo/wow/infra/accessor/property/PropertyGetter;", "", "aggregateNameGetter", "eventName", "revision", "asMetadata", "Lme/ahoo/wow/event/metadata/EventMetadata;", "visitField", "", "field", "Ljava/lang/reflect/Field;", "visitMethod", "method", "Ljava/lang/reflect/Method;", "wow-core"})
    public static final class EventMetadataVisitor<E>
    implements ClassVisitor {
        @NotNull
        private final Class<E> eventType;
        @NotNull
        private final String eventName;
        @Nullable
        private PropertyGetter<? super E, String> aggregateNameGetter;
        @NotNull
        private String revision;
        @Nullable
        private PropertyGetter<? super E, String> aggregateIdGetter;

        public EventMetadataVisitor(@NotNull Class<E> eventType) {
            block1: {
                Event event;
                Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
                this.eventType = eventType;
                this.eventName = PascalToSnakeConverterKt.asName(this.eventType);
                this.revision = "0.0.1";
                Event event2 = event = this.eventType.getAnnotation(Event.class);
                if (event2 == null) break block1;
                Event it = event2;
                boolean bl = false;
                if (((CharSequence)it.revision()).length() > 0) {
                    this.revision = it.revision();
                }
            }
        }

        @Override
        public void visitField(@NotNull Field field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (this.aggregateNameGetter == null) {
                this.aggregateNameGetter = AggregateAnnotationParser.INSTANCE.asAggregateNameGetterIfAnnotated(field);
            }
            if (this.aggregateIdGetter == null) {
                this.aggregateIdGetter = AggregateAnnotationParser.INSTANCE.asAggregateIdGetterIfAnnotated(field);
            }
        }

        @Override
        public void visitMethod(@NotNull Method method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (this.aggregateNameGetter == null) {
                this.aggregateNameGetter = AggregateAnnotationParser.INSTANCE.asAggregateNameGetterIfAnnotated(method);
            }
            if (this.aggregateIdGetter == null) {
                this.aggregateIdGetter = AggregateAnnotationParser.INSTANCE.asAggregateIdGetterIfAnnotated(method);
            }
        }

        @NotNull
        public final EventMetadata<E> asMetadata() {
            NamedAggregateGetter<? super E> namedAggregateGetter = NamedAggregateGetterKt.asNamedAggregateGetter(this.aggregateNameGetter, this.eventType);
            return new EventMetadata<E>(this.eventType, namedAggregateGetter, this.eventName, this.revision, this.aggregateIdGetter);
        }
    }
}

