/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.state;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.event.AggregateDeleted;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.TypedAggregate;
import me.ahoo.wow.event.DomainEvent;
import me.ahoo.wow.event.DomainEventExchange;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.SimpleDomainEventExchange;
import me.ahoo.wow.messaging.function.MessageFunction;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.SourcingVersionConflictException;
import me.ahoo.wow.modeling.state.StateAggregate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001ABU\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0013\u00106\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u00108\u001a\u00020\u000bH\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010:\u001a\u00020;H\u0016J\u0014\u0010<\u001a\u00020=2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030?H\u0002J\b\u0010@\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0010\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010#\"\u0004\b'\u0010%R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R4\u0010*\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u0004\u0012\u00020.0,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006B"}, d2={"Lme/ahoo/wow/modeling/state/SimpleStateAggregate;", "S", "", "Lme/ahoo/wow/modeling/state/StateAggregate;", "Lme/ahoo/wow/api/modeling/TypedAggregate;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "metadata", "Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;", "state", "version", "", "eventId", "", "firstEventTime", "", "eventTime", "deleted", "", "(Lme/ahoo/wow/api/modeling/AggregateId;Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;Ljava/lang/Object;ILjava/lang/String;JJZ)V", "getAggregateId", "()Lme/ahoo/wow/api/modeling/AggregateId;", "aggregateType", "Ljava/lang/Class;", "getAggregateType", "()Ljava/lang/Class;", "getDeleted", "()Z", "setDeleted", "(Z)V", "getEventId", "()Ljava/lang/String;", "setEventId", "(Ljava/lang/String;)V", "getEventTime", "()J", "setEventTime", "(J)V", "getFirstEventTime", "setFirstEventTime", "getMetadata", "()Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;", "sourcingRegistry", "", "Lme/ahoo/wow/messaging/function/MessageFunction;", "Lme/ahoo/wow/event/DomainEventExchange;", "Ljava/lang/Void;", "getState", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getVersion", "()I", "setVersion", "(I)V", "equals", "other", "hashCode", "onSourcing", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "sourcing", "", "domainEvent", "Lme/ahoo/wow/event/DomainEvent;", "toString", "Companion", "wow-core"})
public final class SimpleStateAggregate<S>
implements StateAggregate<S>,
TypedAggregate<S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateId aggregateId;
    @NotNull
    private final StateAggregateMetadata<S> metadata;
    @NotNull
    private final S state;
    private int version;
    @NotNull
    private String eventId;
    private long firstEventTime;
    private long eventTime;
    private boolean deleted;
    @NotNull
    private final Map<Class<?>, MessageFunction<S, DomainEventExchange<?>, Void>> sourcingRegistry;
    @NotNull
    private static final Logger log;

    public SimpleStateAggregate(@NotNull AggregateId aggregateId, @NotNull StateAggregateMetadata<S> metadata2, @NotNull S state, int version, @NotNull String eventId, long firstEventTime, long eventTime, boolean deleted) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this.aggregateId = aggregateId;
        this.metadata = metadata2;
        this.state = state;
        this.version = version;
        this.eventId = eventId;
        this.firstEventTime = firstEventTime;
        this.eventTime = eventTime;
        this.deleted = deleted;
        this.sourcingRegistry = this.metadata.asMessageFunctionRegistry(this.getState());
    }

    public /* synthetic */ SimpleStateAggregate(AggregateId aggregateId, StateAggregateMetadata stateAggregateMetadata, Object object, int n, String string, long l, long l2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string = "";
        }
        if ((n2 & 0x20) != 0) {
            l = 0L;
        }
        if ((n2 & 0x40) != 0) {
            l2 = 0L;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        this(aggregateId, stateAggregateMetadata, object, n, string, l, l2, bl);
    }

    @Override
    @NotNull
    public AggregateId getAggregateId() {
        return this.aggregateId;
    }

    @NotNull
    public final StateAggregateMetadata<S> getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public S getState() {
        return this.state;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    @NotNull
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.eventId = string;
    }

    @Override
    public long getFirstEventTime() {
        return this.firstEventTime;
    }

    public void setFirstEventTime(long l) {
        this.firstEventTime = l;
    }

    @Override
    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long l) {
        this.eventTime = l;
    }

    @Override
    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    @Override
    @NotNull
    public Class<S> getAggregateType() {
        return this.metadata.getAggregateType();
    }

    @Override
    @NotNull
    public StateAggregate<S> onSourcing(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        if (log.isDebugEnabled()) {
            log.debug("Sourcing {}.", (Object)eventStream);
        }
        if (!Intrinsics.areEqual((Object)this.getAggregateId(), (Object)eventStream.getAggregateId())) {
            boolean $i$a$-require-SimpleStateAggregate$onSourcing$22 = false;
            String $i$a$-require-SimpleStateAggregate$onSourcing$22 = "Failed to Sourcing eventStream[" + eventStream.getId() + "]: Current StateAggregate's AggregateId[" + this + "] is inconsistent with the DomainEventStream's AggregateId[" + eventStream.getAggregateId() + "].";
            throw new IllegalArgumentException($i$a$-require-SimpleStateAggregate$onSourcing$22.toString());
        }
        if (this.getExpectedNextVersion() != eventStream.getVersion()) {
            throw new SourcingVersionConflictException(eventStream, this.getExpectedNextVersion());
        }
        for (DomainEvent domainEvent : eventStream) {
            this.sourcing(domainEvent);
        }
        this.setVersion(eventStream.getVersion());
        this.setEventId(eventStream.getId());
        this.setEventTime(eventStream.getCreateTime());
        if (this.isInitialVersion()) {
            this.setFirstEventTime(eventStream.getCreateTime());
        }
        return this;
    }

    private final void sourcing(DomainEvent<?> domainEvent) {
        MessageFunction<S, DomainEventExchange<?>, Void> sourcingFunction;
        if (domainEvent.getBody() instanceof AggregateDeleted) {
            this.setDeleted(true);
        }
        if ((sourcingFunction = this.sourcingRegistry.get(domainEvent.getBody().getClass())) != null) {
            sourcingFunction.handle(new SimpleDomainEventExchange(domainEvent, null, 2, null));
        } else if (log.isDebugEnabled()) {
            log.debug("Sourcing {} Ignore this domain event because onSourcing does not exist.", domainEvent);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleStateAggregate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAggregateId(), (Object)((SimpleStateAggregate)other).getAggregateId())) {
            return false;
        }
        return this.getVersion() == ((SimpleStateAggregate)other).getVersion();
    }

    public int hashCode() {
        int result = this.getAggregateId().hashCode();
        result = 31 * result + this.getVersion();
        return result;
    }

    @NotNull
    public String toString() {
        return "SimpleStateAggregate(aggregateId=" + this.getAggregateId() + ", version=" + this.getVersion() + ")";
    }

    static {
        Logger logger = LoggerFactory.getLogger(SimpleStateAggregate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/modeling/state/SimpleStateAggregate$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

