/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.serialization.state;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ReadOnlyStateAggregate;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002H&\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/serialization/state/AbstractStateAggregateDeserializer;", "T", "Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "stateAggregateType", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "createStateAggregate", "stateRecord", "Lcom/fasterxml/jackson/databind/JsonNode;", "stateAggregate", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;)Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "wow-core"})
public abstract class AbstractStateAggregateDeserializer<T extends ReadOnlyStateAggregate<?>>
extends StdDeserializer<T> {
    public AbstractStateAggregateDeserializer(@NotNull Class<T> stateAggregateType) {
        Intrinsics.checkNotNullParameter(stateAggregateType, (String)"stateAggregateType");
        super(stateAggregateType);
    }

    @NotNull
    public T deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode stateRecord = (JsonNode)p.getCodec().readTree(p);
        String string = stateRecord.get("contextName").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        String string2 = stateRecord.get("aggregateName").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
        MaterializedNamedAggregate namedAggregate = new MaterializedNamedAggregate(string, string2);
        StateAggregateMetadata metadata2 = AggregateMetadataParserKt.asAggregateMetadata(MetadataSearcherKt.asRequiredAggregateType(namedAggregate)).getState();
        int version = stateRecord.get("version").asInt();
        JsonNode jsonNode = stateRecord.get("eventId");
        String string3 = jsonNode != null ? jsonNode.asText() : null;
        if (string3 == null) {
            string3 = "";
        }
        String eventId = string3;
        JsonNode jsonNode2 = stateRecord.get("firstOperator");
        String string4 = jsonNode2 != null ? jsonNode2.asText() : null;
        if (string4 == null) {
            string4 = "";
        }
        String firstOperator = string4;
        JsonNode jsonNode3 = stateRecord.get("operator");
        String string5 = jsonNode3 != null ? jsonNode3.asText() : null;
        if (string5 == null) {
            string5 = "";
        }
        String operator = string5;
        JsonNode jsonNode4 = stateRecord.get("firstEventTime");
        long firstEventTime = jsonNode4 != null ? jsonNode4.asLong() : 0L;
        JsonNode jsonNode5 = stateRecord.get("eventTime");
        long eventTime = jsonNode5 != null ? jsonNode5.asLong() : 0L;
        boolean deleted = stateRecord.get("deleted").asBoolean();
        JsonNode jsonNode6 = stateRecord.get("state");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode6, (String)"get(...)");
        Object stateRoot = JsonSerializerKt.asObject(jsonNode6, metadata2.getAggregateType());
        NamedAggregate namedAggregate2 = namedAggregate;
        String string6 = stateRecord.get("aggregateId").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"asText(...)");
        String string7 = stateRecord.get("tenantId").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"asText(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId(namedAggregate2, string6, string7);
        StateAggregate stateAggregate = StateAggregate.Companion.asStateAggregate(metadata2, aggregateId, stateRoot, version, eventId, firstOperator, operator, firstEventTime, eventTime, deleted);
        Intrinsics.checkNotNull((Object)stateRecord);
        return this.createStateAggregate(stateRecord, stateAggregate);
    }

    @NotNull
    public abstract T createStateAggregate(@NotNull JsonNode var1, @NotNull ReadOnlyStateAggregate<Object> var2);
}

