/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor;", "Lme/ahoo/wow/command/wait/WaitStrategy;", "stage", "Lme/ahoo/wow/command/wait/CommandStage;", "contextName", "", "processorName", "(Lme/ahoo/wow/command/wait/CommandStage;Ljava/lang/String;Ljava/lang/String;)V", "getContextName", "()Ljava/lang/String;", "getProcessorName", "sink", "Lreactor/core/publisher/Sinks$One;", "Lme/ahoo/wow/command/wait/WaitSignal;", "getStage", "()Lme/ahoo/wow/command/wait/CommandStage;", "error", "", "throwable", "", "next", "signal", "toString", "waiting", "Lreactor/core/publisher/Mono;", "Companion", "wow-core"})
public final class WaitingFor
implements WaitStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommandStage stage;
    @NotNull
    private final String contextName;
    @NotNull
    private final String processorName;
    @NotNull
    private final Sinks.One<WaitSignal> sink;
    private static final Logger log = LoggerFactory.getLogger(WaitingFor.class);

    public WaitingFor(@NotNull CommandStage stage, @NotNull String contextName, @NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        this.stage = stage;
        this.contextName = contextName;
        this.processorName = processorName;
        Sinks.One one = Sinks.one();
        Intrinsics.checkNotNullExpressionValue((Object)one, (String)"one(...)");
        this.sink = one;
    }

    public /* synthetic */ WaitingFor(CommandStage commandStage, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(commandStage, string, string2);
    }

    @NotNull
    public final CommandStage getStage() {
        return this.stage;
    }

    @NotNull
    public String getContextName() {
        return this.contextName;
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public Mono<WaitSignal> waiting() {
        Mono mono = this.sink.asMono();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"asMono(...)");
        return mono;
    }

    @Override
    public void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.sink.tryEmitError(throwable);
    }

    @Override
    public void next(@NotNull WaitSignal signal) {
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        if (log.isDebugEnabled()) {
            log.debug("Next " + signal + ".");
        }
        if (!signal.getSucceeded() && this.stage.isAfter(signal.getStage())) {
            this.sink.tryEmitValue((Object)signal);
            return;
        }
        if (this.stage != signal.getStage()) {
            return;
        }
        if (this.stage == CommandStage.SENT || this.stage == CommandStage.PROCESSED || this.stage == CommandStage.SNAPSHOT) {
            this.sink.tryEmitValue((Object)signal);
            return;
        }
        if (!this.isSameBoundedContext(signal)) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)this.getProcessorName())) {
            if (signal.isLastProjection()) {
                this.sink.tryEmitValue((Object)signal);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)this.getProcessorName(), (Object)signal.getProcessorName())) {
            this.sink.tryEmitValue((Object)signal);
            return;
        }
    }

    @NotNull
    public String toString() {
        return "WaitingFor(stage=" + this.stage + ", contextName='" + this.getContextName() + "', processorName='" + this.getProcessorName() + "')";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "eventHandled", "Lme/ahoo/wow/command/wait/WaitingFor;", "contextName", "", "processorName", "processed", "projected", "sagaHandled", "snapshot", "stage", "Lme/ahoo/wow/command/wait/CommandStage;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WaitingFor processed(@NotNull String contextName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            return me.ahoo.wow.command.wait.WaitingFor$Companion.stage$default(this, CommandStage.PROCESSED, contextName, null, 4, null);
        }

        @NotNull
        public final WaitingFor snapshot(@NotNull String contextName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            return me.ahoo.wow.command.wait.WaitingFor$Companion.stage$default(this, CommandStage.SNAPSHOT, contextName, null, 4, null);
        }

        @NotNull
        public final WaitingFor projected(@NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return this.stage(CommandStage.PROJECTED, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor projected$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.projected(string, string2);
        }

        @NotNull
        public final WaitingFor eventHandled(@NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return this.stage(CommandStage.EVENT_HANDLED, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor eventHandled$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.eventHandled(string, string2);
        }

        @NotNull
        public final WaitingFor sagaHandled(@NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return this.stage(CommandStage.SAGA_HANDLED, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor sagaHandled$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.sagaHandled(string, string2);
        }

        @NotNull
        public final WaitingFor stage(@NotNull CommandStage stage, @NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return new WaitingFor(stage, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor stage$default(Companion companion, CommandStage commandStage, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            return companion.stage(commandStage, string, string2);
        }

        @NotNull
        public final WaitingFor stage(@NotNull String stage, @NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            String string = stage;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            return this.stage(CommandStage.valueOf(string2), contextName, processorName);
        }

        public static /* synthetic */ WaitingFor stage$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = "";
            }
            return companion.stage(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

