/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.event.compensation

import me.ahoo.wow.api.modeling.AggregateId
import me.ahoo.wow.event.DomainEventBus
import me.ahoo.wow.eventsourcing.EventStore
import me.ahoo.wow.messaging.compensation.CompensationConfig
import me.ahoo.wow.messaging.compensation.CompensationMatcher.withCompensation
import me.ahoo.wow.messaging.compensation.EventCompensator
import reactor.core.publisher.Mono

class DomainEventCompensator(
    private val eventStore: EventStore,
    private val eventBus: DomainEventBus
) :
    EventCompensator {
    override fun compensate(
        aggregateId: AggregateId,
        config: CompensationConfig,
        headVersion: Int,
        tailVersion: Int
    ): Mono<Long> {
        return eventStore.load(
            aggregateId = aggregateId,
            headVersion = headVersion,
            tailVersion = tailVersion,
        ).concatMap {
            val eventStream = it.withCompensation(config)
            eventBus.send(eventStream).thenReturn(it)
        }.count()
    }
}
