/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.SignalType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0096\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\bH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\bH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "waitStrategies", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lme/ahoo/wow/command/wait/WaitStrategy;", "contains", "", "commandId", "get", "register", "waitStrategy", "unregister", "wow-core"})
public final class SimpleWaitStrategyRegistrar
implements WaitStrategyRegistrar {
    @NotNull
    public static final SimpleWaitStrategyRegistrar INSTANCE = new SimpleWaitStrategyRegistrar();
    private static final Logger log = LoggerFactory.getLogger(SimpleWaitStrategyRegistrar.class);
    @NotNull
    private static final ConcurrentHashMap<String, WaitStrategy> waitStrategies = new ConcurrentHashMap();

    private SimpleWaitStrategyRegistrar() {
    }

    @Override
    @Nullable
    public WaitStrategy register(@NotNull String commandId, @NotNull WaitStrategy waitStrategy) {
        WaitStrategy current;
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        if (log.isDebugEnabled()) {
            log.debug("Register - command[{}] WaitStrategy.", (Object)commandId);
        }
        if ((current = waitStrategies.putIfAbsent(commandId, waitStrategy)) == null) {
            waitStrategy.waiting().doFinally(arg_0 -> SimpleWaitStrategyRegistrar.register$lambda$0(commandId, arg_0)).subscribe();
        }
        return current;
    }

    @Override
    @Nullable
    public WaitStrategy unregister(@NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        WaitStrategy value = waitStrategies.remove(commandId);
        if (log.isDebugEnabled()) {
            log.debug("Unregister - remove command[{}] WaitStrategy - [{}].", (Object)commandId, (Object)(value != null ? 1 : 0));
        }
        return value;
    }

    @Override
    @Nullable
    public WaitStrategy get(@NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        return waitStrategies.get(commandId);
    }

    @Override
    public boolean contains(@NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        return waitStrategies.containsKey(commandId);
    }

    private static final void register$lambda$0(String $commandId, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$commandId, (String)"$commandId");
        if (log.isDebugEnabled()) {
            log.debug("Remove command[{}] on [{}] WaitStrategy.", (Object)$commandId, (Object)it);
        }
        waitStrategies.remove($commandId);
    }
}

