/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.command;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.command.RecoverAggregate;
import me.ahoo.wow.api.messaging.function.FunctionInfo;
import me.ahoo.wow.api.messaging.function.FunctionInfoData;
import me.ahoo.wow.api.messaging.function.FunctionKind;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.modeling.NamedTypedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.exception.NotFoundResourceException;
import me.ahoo.wow.messaging.function.MessageFunction;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.modeling.command.CommandAggregate;
import me.ahoo.wow.modeling.command.CommandExpectVersionConflictException;
import me.ahoo.wow.modeling.command.CommandState;
import me.ahoo.wow.modeling.command.ExchangeCommandAggregateKt;
import me.ahoo.wow.modeling.command.IllegalAccessDeletedAggregateException;
import me.ahoo.wow.modeling.matedata.CommandAggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u00016B3\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J0\u0010*\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\b\u0012\u0004\u0012\u00020 0\u001f2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u001c2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\b\u0010,\u001a\u00020\u0015H\u0016J\u0011\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0096\u0001J\u0011\u00101\u001a\u00020.2\u0006\u0010/\u001a\u000202H\u0096\u0001R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\b\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u001a\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012 \u0012\u001e\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010!\u001a,\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\t\u00103\u001a\u00020\u0015X\u0096\u0005R\u000f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cX\u0096\u0005R\t\u00105\u001a\u00020\u0015X\u0096\u0005\u00a8\u00067"}, d2={"Lme/ahoo/wow/modeling/command/SimpleCommandAggregate;", "C", "", "S", "Lme/ahoo/wow/modeling/command/CommandAggregate;", "Lme/ahoo/wow/api/modeling/NamedTypedAggregate;", "state", "Lme/ahoo/wow/modeling/state/StateAggregate;", "commandRoot", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "metadata", "Lme/ahoo/wow/modeling/matedata/CommandAggregateMetadata;", "<init>", "(Lme/ahoo/wow/modeling/state/StateAggregate;Ljava/lang/Object;Lme/ahoo/wow/eventsourcing/EventStore;Lme/ahoo/wow/modeling/matedata/CommandAggregateMetadata;)V", "getState", "()Lme/ahoo/wow/modeling/state/StateAggregate;", "getCommandRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "processorFunction", "Lme/ahoo/wow/api/messaging/function/FunctionInfoData;", "commandFunctionRegistry", "", "Ljava/lang/Class;", "Lme/ahoo/wow/messaging/function/MessageFunction;", "Lme/ahoo/wow/command/ServerCommandExchange;", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/event/DomainEventStream;", "errorFunctionRegistry", "commandState", "Lme/ahoo/wow/modeling/command/CommandState;", "getCommandState", "()Lme/ahoo/wow/modeling/command/CommandState;", "setCommandState", "(Lme/ahoo/wow/modeling/command/CommandState;)V", "process", "exchange", "errorResume", "commandType", "toString", "isSameAggregateName", "", "other", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "isSameBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateName", "aggregateType", "contextName", "Companion", "wow-core"})
public final class SimpleCommandAggregate<C, S>
implements CommandAggregate<C, S>,
NamedTypedAggregate<C> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StateAggregate<S> state;
    @NotNull
    private final C commandRoot;
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final CommandAggregateMetadata<C> metadata;
    @NotNull
    private final String processorName;
    @NotNull
    private final FunctionInfoData processorFunction;
    @NotNull
    private final Map<Class<?>, MessageFunction<C, ServerCommandExchange<?>, Mono<DomainEventStream>>> commandFunctionRegistry;
    @NotNull
    private final Map<Class<?>, MessageFunction<C, ServerCommandExchange<?>, Mono<?>>> errorFunctionRegistry;
    @NotNull
    private volatile CommandState commandState;
    @NotNull
    private static final Logger log;

    public SimpleCommandAggregate(@NotNull StateAggregate<S> state, @NotNull C commandRoot, @NotNull EventStore eventStore, @NotNull CommandAggregateMetadata<C> metadata) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter(commandRoot, (String)"commandRoot");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        this.state = state;
        this.commandRoot = commandRoot;
        this.eventStore = eventStore;
        this.metadata = metadata;
        this.processorName = this.metadata.getProcessorName();
        this.processorFunction = new FunctionInfoData(FunctionKind.COMMAND, this.metadata.getProcessorName(), this.metadata.getContextName(), "process");
        this.commandFunctionRegistry = this.metadata.toCommandFunctionRegistry(this);
        this.errorFunctionRegistry = this.metadata.toErrorFunctionRegistry(this);
        this.commandState = CommandState.STORED;
    }

    @Override
    @NotNull
    public StateAggregate<S> getState() {
        return this.state;
    }

    @Override
    @NotNull
    public C getCommandRoot() {
        return this.commandRoot;
    }

    public boolean isSameAggregateName(@NotNull NamedAggregate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ((NamedAggregate)this.metadata).isSameAggregateName(other);
    }

    public boolean isSameBoundedContext(@NotNull NamedBoundedContext other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ((NamedBoundedContext)this.metadata).isSameBoundedContext(other);
    }

    @NotNull
    public Class<C> getAggregateType() {
        return this.metadata.getAggregateType();
    }

    @NotNull
    public String getAggregateName() {
        return this.metadata.getAggregateName();
    }

    @NotNull
    public String getContextName() {
        return this.metadata.getContextName();
    }

    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public CommandState getCommandState() {
        return this.commandState;
    }

    public void setCommandState(@NotNull CommandState commandState) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandState), (String)"<set-?>");
        this.commandState = commandState;
    }

    @Override
    @NotNull
    public Mono<DomainEventStream> process(@NotNull ServerCommandExchange<?> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        exchange.setFunction((FunctionInfo)this.processorFunction);
        CommandMessage message = (CommandMessage)exchange.getMessage();
        Class<?> commandType = message.getBody().getClass();
        Mono mono = Mono.defer(() -> SimpleCommandAggregate.process$lambda$11(exchange, this, message, commandType));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return this.errorResume((Mono<DomainEventStream>)mono, commandType, exchange);
    }

    private final Mono<DomainEventStream> errorResume(Mono<DomainEventStream> $this$errorResume, Class<?> commandType, ServerCommandExchange<?> exchange) {
        Mono mono = $this$errorResume.onErrorResume(arg_0 -> SimpleCommandAggregate.errorResume$lambda$14(arg_0 -> SimpleCommandAggregate.errorResume$lambda$13(exchange, this, commandType, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorResume(...)");
        return mono;
    }

    @NotNull
    public String toString() {
        return "SimpleCommandAggregate(state=" + this.getState() + ", metadata=" + this.metadata + ", commandState=" + this.getCommandState() + ")";
    }

    private static final Unit process$lambda$11$lambda$3(ServerCommandExchange $exchange, SimpleCommandAggregate this$0, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$exchange, (String)"$exchange");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        $exchange.setEventStream(it);
        this$0.setCommandState(this$0.getCommandState().onSourcing(this$0.getState(), it));
        return Unit.INSTANCE;
    }

    private static final void process$lambda$11$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$11$lambda$9$lambda$5(SimpleCommandAggregate this$0, CommandState it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setCommandState(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$11$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$11$lambda$9$lambda$7(SimpleCommandAggregate this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setCommandState(CommandState.EXPIRED);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$11$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono process$lambda$11$lambda$9(SimpleCommandAggregate this$0, DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CommandState commandState = this$0.getCommandState();
        EventStore eventStore = this$0.eventStore;
        Intrinsics.checkNotNull((Object)eventStream);
        return commandState.onStore(eventStore, eventStream).doOnNext(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$9$lambda$6(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$9$lambda$5(this$0, arg_0), arg_0)).doOnError(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$9$lambda$8(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$9$lambda$7(this$0, arg_0), arg_0)).thenReturn((Object)eventStream);
    }

    private static final Mono process$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono process$lambda$11(ServerCommandExchange $exchange, SimpleCommandAggregate this$0, CommandMessage $message, Class $commandType) {
        MessageFunction commandFunction;
        Intrinsics.checkNotNullParameter((Object)$exchange, (String)"$exchange");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$commandType, (String)"$commandType");
        ExchangeCommandAggregateKt.setCommandAggregate($exchange, this$0);
        if (log.isDebugEnabled()) {
            log.debug("Process {}.", (Object)$message);
        }
        if ($message.getAggregateVersion() != null) {
            Integer n = $message.getAggregateVersion();
            int n2 = this$0.getVersion();
            if (n == null || n != n2) {
                Integer n3 = $message.getAggregateVersion();
                Intrinsics.checkNotNull((Object)n3);
                return MonoExtensionsKt.toMono((Throwable)new CommandExpectVersionConflictException($message, n3, this$0.getVersion(), null, 8, null));
            }
        }
        if (!(this$0.getInitialized() || $message.isCreate() || $message.getAllowCreate())) {
            return MonoExtensionsKt.toMono((Throwable)new NotFoundResourceException(this$0.getAggregateId() + " is not initialized."));
        }
        if (!(this$0.getCommandState() == CommandState.STORED)) {
            boolean $i$a$-check-SimpleCommandAggregate$process$1$32 = false;
            String $i$a$-check-SimpleCommandAggregate$process$1$32 = "Failed to process command[" + $message.getId() + "]: The current StateAggregate[" + this$0.getAggregateId().getId() + "] is not stored.";
            throw new IllegalStateException($i$a$-check-SimpleCommandAggregate$process$1$32.toString());
        }
        if ($message.getBody() instanceof RecoverAggregate) {
            if (!this$0.getState().getDeleted()) {
                boolean $i$a$-check-SimpleCommandAggregate$process$1$42 = false;
                String $i$a$-check-SimpleCommandAggregate$process$1$42 = "Failed to process command[" + $message.getId() + "]: The current StateAggregate[" + this$0.getAggregateId().getId() + "] is not deleted.";
                throw new IllegalStateException($i$a$-check-SimpleCommandAggregate$process$1$42.toString());
            }
        } else if (this$0.getState().getDeleted()) {
            return MonoExtensionsKt.toMono((Throwable)new IllegalAccessDeletedAggregateException(this$0.getState().getAggregateId(), null, 2, null));
        }
        if ((commandFunction = this$0.commandFunctionRegistry.get($commandType)) == null) {
            boolean bl = false;
            String string = "Failed to process command[" + $message.getId() + "]: Undefined command[" + $message.getBody().getClass() + "].";
            throw new IllegalArgumentException(string.toString());
        }
        $exchange.setFunction(commandFunction);
        return commandFunction.invoke((ServerCommandExchange<?>)((MessageExchange)$exchange)).doOnNext(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$4(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$3($exchange, this$0, arg_0), arg_0)).flatMap(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$10(arg_0 -> SimpleCommandAggregate.process$lambda$11$lambda$9(this$0, arg_0), arg_0));
    }

    private static final Mono errorResume$lambda$13$lambda$12(ServerCommandExchange $exchange, Throwable $it) {
        Intrinsics.checkNotNullParameter((Object)$exchange, (String)"$exchange");
        Throwable throwable = $exchange.getError();
        if (throwable == null || (throwable = MonoExtensionsKt.toMono((Throwable)throwable)) == null) {
            Intrinsics.checkNotNull((Object)$it);
            throwable = MonoExtensionsKt.toMono((Throwable)$it);
        }
        return throwable;
    }

    private static final Mono errorResume$lambda$13(ServerCommandExchange $exchange, SimpleCommandAggregate this$0, Class $commandType, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$exchange, (String)"$exchange");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$commandType, (String)"$commandType");
        Intrinsics.checkNotNull((Object)it);
        $exchange.setError(it);
        MessageFunction messageFunction = this$0.errorFunctionRegistry.get($commandType);
        if (messageFunction == null) {
            return MonoExtensionsKt.toMono((Throwable)it);
        }
        MessageFunction errorFunction = messageFunction;
        return errorFunction.invoke((ServerCommandExchange<?>)((MessageExchange)$exchange)).then(Mono.defer(() -> SimpleCommandAggregate.errorResume$lambda$13$lambda$12($exchange, it)));
    }

    private static final Mono errorResume$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(SimpleCommandAggregate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/modeling/command/SimpleCommandAggregate$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

