/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.serialization.event;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.state.StateEvent;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.serialization.JsonSerializerKt;
import me.ahoo.wow.serialization.event.EventStreamRecordKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/serialization/event/StateEventJsonDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lme/ahoo/wow/eventsourcing/state/StateEvent;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "wow-core"})
public final class StateEventJsonDeserializer
extends StdDeserializer<StateEvent<?>> {
    @NotNull
    public static final StateEventJsonDeserializer INSTANCE = new StateEventJsonDeserializer();

    private StateEventJsonDeserializer() {
        super(StateEvent.class);
    }

    @NotNull
    public StateEvent<?> deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        ObjectNode stateEventRecord = (ObjectNode)p.getCodec().readTree(p);
        Intrinsics.checkNotNull((Object)stateEventRecord);
        DomainEventStream eventStream = EventStreamRecordKt.toEventStreamRecord(stateEventRecord).toDomainEventStream();
        StateAggregateMetadata metadata = AggregateMetadataParserKt.aggregateMetadata(MetadataSearcherKt.requiredAggregateType(eventStream)).getState();
        JsonNode jsonNode = stateEventRecord.get("firstOperator");
        String string = jsonNode != null ? jsonNode.asText() : null;
        if (string == null) {
            string = "";
        }
        String firstOperator = string;
        JsonNode jsonNode2 = stateEventRecord.get("firstEventTime");
        long firstEventTime = jsonNode2 != null ? jsonNode2.asLong() : 0L;
        boolean deleted = stateEventRecord.get("deleted").asBoolean();
        JsonNode jsonNode3 = stateEventRecord.get("state");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"get(...)");
        Object stateRoot = JsonSerializerKt.toObject(jsonNode3, metadata.getAggregateType());
        return StateEvent.Companion.toStateEvent(eventStream, stateRoot, firstOperator, firstEventTime, deleted);
    }
}

