/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.event.upgrader;

import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.annotation.SortedByOrderKt;
import me.ahoo.wow.event.upgrader.EventNamedAggregate;
import me.ahoo.wow.event.upgrader.EventUpgrader;
import me.ahoo.wow.event.upgrader.MutableDomainEventRecord;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.serialization.event.DomainEventRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/event/upgrader/EventUpgraderFactory;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "eventUpgraderFactories", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/ahoo/wow/event/upgrader/EventNamedAggregate;", "", "Lme/ahoo/wow/event/upgrader/EventUpgrader;", "register", "", "eventUpgrader", "get", "eventNamedAggregate", "upgrade", "Lme/ahoo/wow/serialization/event/DomainEventRecord;", "domainEventRecord", "wow-core"})
@SourceDebugExtension(value={"SMAP\nEventUpgraderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventUpgraderFactory.kt\nme/ahoo/wow/event/upgrader/EventUpgraderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1863#2,2:75\n1863#2,2:77\n*S KotlinDebug\n*F\n+ 1 EventUpgraderFactory.kt\nme/ahoo/wow/event/upgrader/EventUpgraderFactory\n*L\n65#1:75,2\n32#1:77,2\n*E\n"})
public final class EventUpgraderFactory {
    @NotNull
    public static final EventUpgraderFactory INSTANCE = new EventUpgraderFactory();
    private static final Logger log = LoggerFactory.getLogger(EventUpgraderFactory.class);
    @NotNull
    private static final ConcurrentHashMap<EventNamedAggregate, List<EventUpgrader>> eventUpgraderFactories = new ConcurrentHashMap();

    private EventUpgraderFactory() {
    }

    public final void register(@NotNull EventUpgrader eventUpgrader) {
        Intrinsics.checkNotNullParameter((Object)eventUpgrader, (String)"eventUpgrader");
        if (log.isInfoEnabled()) {
            log.info("Register " + eventUpgrader + ".");
        }
        eventUpgraderFactories.compute(eventUpgrader.getEventNamedAggregate(), (arg_0, arg_1) -> EventUpgraderFactory.register$lambda$2((arg_0, arg_1) -> EventUpgraderFactory.register$lambda$1(eventUpgrader, arg_0, arg_1), arg_0, arg_1));
    }

    @NotNull
    public final List<EventUpgrader> get(@NotNull EventNamedAggregate eventNamedAggregate) {
        Intrinsics.checkNotNullParameter((Object)eventNamedAggregate, (String)"eventNamedAggregate");
        List list = eventUpgraderFactories.get(eventNamedAggregate);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final DomainEventRecord upgrade(@NotNull DomainEventRecord domainEventRecord) {
        Intrinsics.checkNotNullParameter((Object)domainEventRecord, (String)"domainEventRecord");
        MaterializedNamedAggregate namedAggregate = MaterializedNamedAggregateKt.materialize(domainEventRecord.toAggregateId().getNamedAggregate());
        EventNamedAggregate eventNamedAggregate = EventNamedAggregate.Companion.toEventNamedAggregate(namedAggregate, domainEventRecord.getName());
        List<EventUpgrader> eventUpgraders = this.get(eventNamedAggregate);
        if (eventUpgraders.isEmpty()) {
            return domainEventRecord;
        }
        MutableDomainEventRecord mutableDomainEventRecord = null;
        mutableDomainEventRecord = MutableDomainEventRecord.Companion.toMutableDomainEventRecord(domainEventRecord);
        Iterable $this$forEach$iv = eventUpgraders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventUpgrader it = (EventUpgrader)element$iv;
            boolean bl = false;
            if (log.isDebugEnabled()) {
                log.debug("Upgrade [" + domainEventRecord.getId() + "]@[" + eventNamedAggregate + "] by " + it + ".");
            }
            mutableDomainEventRecord = MutableDomainEventRecord.Companion.toMutableDomainEventRecord(it.upgrade(mutableDomainEventRecord));
        }
        return domainEventRecord;
    }

    private static final List register$lambda$1(EventUpgrader $eventUpgrader, EventNamedAggregate eventNamedAggregate, List value) {
        List list;
        Intrinsics.checkNotNullParameter((Object)eventNamedAggregate, (String)"<unused var>");
        if (value == null) {
            Object[] objectArray = new EventUpgrader[]{$eventUpgrader};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            list = SortedByOrderKt.sortedByOrder(CollectionsKt.plus((Collection)value, (Object)$eventUpgrader));
        }
        return list;
    }

    private static final List register$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    static {
        ServiceLoader<EventUpgrader> serviceLoader = ServiceLoader.load(EventUpgrader.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventUpgrader it = (EventUpgrader)element$iv;
            boolean bl = false;
            if (log.isInfoEnabled()) {
                log.info("Load " + it + " to register.");
            }
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.register(it);
        }
    }
}

