/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.exception;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.exception.RecoverableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bJ\u001e\u0010\r\u001a\u00020\u000e2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\u000e2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/exception/RecoverableExceptionRegistrar;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "registrar", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "", "Lme/ahoo/wow/api/exception/RecoverableType;", "getRecoverableType", "throwableClass", "register", "", "recoverableType", "unregister", "wow-core"})
public final class RecoverableExceptionRegistrar {
    @NotNull
    public static final RecoverableExceptionRegistrar INSTANCE = new RecoverableExceptionRegistrar();
    private static final Logger log = LoggerFactory.getLogger(RecoverableExceptionRegistrar.class);
    @NotNull
    private static final ConcurrentHashMap<Class<? extends Throwable>, RecoverableType> registrar = new ConcurrentHashMap();

    private RecoverableExceptionRegistrar() {
    }

    public final void register(@NotNull Class<? extends Throwable> throwableClass, @NotNull RecoverableType recoverableType) {
        Intrinsics.checkNotNullParameter(throwableClass, (String)"throwableClass");
        Intrinsics.checkNotNullParameter((Object)recoverableType, (String)"recoverableType");
        RecoverableType previous = registrar.put(throwableClass, recoverableType);
        if (log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{throwableClass, recoverableType, previous};
            log.info("Register - throwableClass:[{}] - previous:[{}],current:[{}].", objectArray);
        }
    }

    public final void unregister(@NotNull Class<? extends Throwable> throwableClass) {
        Intrinsics.checkNotNullParameter(throwableClass, (String)"throwableClass");
        RecoverableType removed = registrar.remove(throwableClass);
        if (log.isInfoEnabled()) {
            log.info("Unregister - throwableClass:[{}] - removed:[{}].", throwableClass, (Object)removed);
        }
    }

    @Nullable
    public final RecoverableType getRecoverableType(@NotNull Class<? extends Throwable> throwableClass) {
        Intrinsics.checkNotNullParameter(throwableClass, (String)"throwableClass");
        return registrar.get(throwableClass);
    }
}

