/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.annotation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.KTypesJvm;
import me.ahoo.wow.annotation.AnnotationPropertyAccessorParser;
import me.ahoo.wow.api.annotation.AllowCreate;
import me.ahoo.wow.api.annotation.CreateAggregate;
import me.ahoo.wow.command.annotation.CommandMetadataParserKt;
import me.ahoo.wow.command.metadata.CommandMetadata;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.infra.accessor.property.PropertyGetter;
import me.ahoo.wow.infra.accessor.property.StaticPropertyGetter;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import me.ahoo.wow.modeling.matedata.MetadataNamedAggregateGetter;
import me.ahoo.wow.modeling.matedata.NamedAggregateGetter;
import me.ahoo.wow.modeling.matedata.NamedAggregateGetterKt;
import me.ahoo.wow.naming.annotation.PascalToSnakeConverterKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016J\u001a\u0010\u0017\u001a\u00020\u00142\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/ahoo/wow/command/annotation/CommandMetadataVisitor;", "C", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "commandType", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "aggregateIdGetter", "Lme/ahoo/wow/infra/accessor/property/PropertyGetter;", "", "aggregateNameGetter", "aggregateVersionGetter", "", "allowCreate", "", "commandName", "isCreateAggregate", "namedIdProperty", "Lkotlin/reflect/KProperty1;", "tenantIdGetter", "end", "", "toMetadata", "Lme/ahoo/wow/command/metadata/CommandMetadata;", "visitProperty", "property", "visitType", "type", "Lkotlin/reflect/KType;", "wow-core"})
public final class CommandMetadataVisitor<C>
implements ClassVisitor<C> {
    @NotNull
    private final Class<C> commandType;
    @NotNull
    private final String commandName;
    private final boolean isCreateAggregate;
    private boolean allowCreate;
    @Nullable
    private PropertyGetter<? super C, String> aggregateNameGetter;
    @Nullable
    private PropertyGetter<? super C, String> aggregateIdGetter;
    @Nullable
    private KProperty1<C, String> namedIdProperty;
    @Nullable
    private PropertyGetter<? super C, String> tenantIdGetter;
    @Nullable
    private PropertyGetter<? super C, Integer> aggregateVersionGetter;

    public CommandMetadataVisitor(@NotNull Class<C> commandType) {
        Intrinsics.checkNotNullParameter(commandType, (String)"commandType");
        this.commandType = commandType;
        this.commandName = PascalToSnakeConverterKt.toName(this.commandType);
        this.isCreateAggregate = this.commandType.isAnnotationPresent(CreateAggregate.class);
        this.allowCreate = this.commandType.isAnnotationPresent(AllowCreate.class);
    }

    @Override
    public void visitType(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.aggregateIdGetter == null) {
            this.aggregateIdGetter = AnnotationPropertyAccessorParser.INSTANCE.toStaticAggregateIdGetterIfAnnotated(KTypesJvm.getJvmErasure((KType)type));
        }
        if (this.tenantIdGetter == null) {
            this.tenantIdGetter = AnnotationPropertyAccessorParser.INSTANCE.toStaticTenantIdGetterIfAnnotated(KTypesJvm.getJvmErasure((KType)type));
        }
    }

    @Override
    public void visitProperty(@NotNull KProperty1<C, ?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.aggregateNameGetter == null) {
            this.aggregateNameGetter = AnnotationPropertyAccessorParser.INSTANCE.toAggregateNameGetterIfAnnotated(property);
        }
        if (this.aggregateIdGetter == null) {
            this.aggregateIdGetter = AnnotationPropertyAccessorParser.INSTANCE.toAggregateIdGetterIfAnnotated(property);
        }
        if (this.namedIdProperty == null && Intrinsics.areEqual((Object)"id", (Object)property.getName())) {
            this.namedIdProperty = property;
        }
        if (this.tenantIdGetter == null) {
            this.tenantIdGetter = AnnotationPropertyAccessorParser.INSTANCE.toTenantIdGetterIfAnnotated(property);
        }
        if (this.aggregateVersionGetter == null) {
            this.aggregateVersionGetter = AnnotationPropertyAccessorParser.INSTANCE.toAggregateVersionGetterIfAnnotated(property);
        }
    }

    @Override
    public void end() {
        if (this.aggregateIdGetter != null || this.namedIdProperty == null) {
            return;
        }
        KProperty1<C, String> kProperty1 = this.namedIdProperty;
        Intrinsics.checkNotNull(kProperty1);
        this.aggregateIdGetter = AnnotationPropertyAccessorParser.INSTANCE.toStringGetter(kProperty1);
    }

    @NotNull
    public final CommandMetadata<C> toMetadata() {
        String tenantId;
        if (this.aggregateIdGetter == null && !this.isCreateAggregate && CommandMetadataParserKt.access$getLOG$p().isWarnEnabled()) {
            CommandMetadataParserKt.access$getLOG$p().warn("Command[" + this.commandType + "] does not define an aggregate ID field and is not a create aggregate command.");
        }
        NamedAggregateGetter<? super C> namedAggregateGetter = NamedAggregateGetterKt.toNamedAggregateGetter(this.aggregateNameGetter, this.commandType);
        if (this.tenantIdGetter == null && namedAggregateGetter instanceof MetadataNamedAggregateGetter && (tenantId = MetadataSearcher.INSTANCE.requiredAggregate(((MetadataNamedAggregateGetter)namedAggregateGetter).getNamedAggregate()).getTenantId()) != null) {
            this.tenantIdGetter = new StaticPropertyGetter(tenantId);
        }
        Class<C> clazz = this.commandType;
        String string = this.commandName;
        boolean bl = this.isCreateAggregate;
        boolean bl2 = this.allowCreate;
        PropertyGetter<? super C, String> propertyGetter = this.aggregateIdGetter;
        PropertyGetter<? super C, Integer> propertyGetter2 = this.aggregateVersionGetter;
        PropertyGetter<? super C, String> propertyGetter3 = this.tenantIdGetter;
        return new CommandMetadata<C>(clazz, namedAggregateGetter, string, bl, bl2, propertyGetter, propertyGetter3, propertyGetter2);
    }
}

