/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.factory;

import jakarta.validation.Validator;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.command.CommandFactoryKt;
import me.ahoo.wow.command.factory.CommandMessageFactory;
import me.ahoo.wow.command.factory.CommandOptions;
import me.ahoo.wow.command.factory.CommandOptionsExtractor;
import me.ahoo.wow.command.factory.CommandOptionsExtractorRegistry;
import me.ahoo.wow.command.factory.CommandValidationException;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\b\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/command/factory/SimpleCommandMessageFactory;", "Lme/ahoo/wow/command/factory/CommandMessageFactory;", "validator", "Ljakarta/validation/Validator;", "commandOptionsExtractorRegistry", "Lme/ahoo/wow/command/factory/CommandOptionsExtractorRegistry;", "(Ljakarta/validation/Validator;Lme/ahoo/wow/command/factory/CommandOptionsExtractorRegistry;)V", "create", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/api/command/CommandMessage;", "C", "", "body", "options", "Lme/ahoo/wow/command/factory/CommandOptions;", "(Ljava/lang/Object;Lme/ahoo/wow/command/factory/CommandOptions;)Lreactor/core/publisher/Mono;", "wow-core"})
public final class SimpleCommandMessageFactory
implements CommandMessageFactory {
    @NotNull
    private final Validator validator;
    @NotNull
    private final CommandOptionsExtractorRegistry commandOptionsExtractorRegistry;

    public SimpleCommandMessageFactory(@NotNull Validator validator, @NotNull CommandOptionsExtractorRegistry commandOptionsExtractorRegistry) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)commandOptionsExtractorRegistry, (String)"commandOptionsExtractorRegistry");
        this.validator = validator;
        this.commandOptionsExtractorRegistry = commandOptionsExtractorRegistry;
    }

    @Override
    @NotNull
    public <C> Mono<CommandMessage<C>> create(@NotNull C body, @NotNull CommandOptions options) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Set constraintViolations = this.validator.validate(body, new Class[0]);
        Intrinsics.checkNotNull((Object)constraintViolations);
        if (!((Collection)constraintViolations).isEmpty()) {
            return MonoExtensionsKt.toMono((Throwable)new CommandValidationException(body, constraintViolations));
        }
        CommandOptionsExtractor<?> commandOptionsExtractor = this.commandOptionsExtractorRegistry.getExtractor(body.getClass());
        if (commandOptionsExtractor == null) {
            return MonoExtensionsKt.toMono(CommandFactoryKt.toCommandMessage(body, options));
        }
        CommandOptionsExtractor<?> extractor = commandOptionsExtractor;
        Mono mono = extractor.extract(body, options).map(arg_0 -> SimpleCommandMessageFactory.create$lambda$0((Function1)new Function1<CommandOptions, CommandMessage<C>>(body){
            final /* synthetic */ C $body;
            {
                this.$body = $body;
                super(1);
            }

            public final CommandMessage<C> invoke(CommandOptions it) {
                Intrinsics.checkNotNull((Object)it);
                return CommandFactoryKt.toCommandMessage(this.$body, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final CommandMessage create$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CommandMessage)$tmp0.invoke(p0);
    }
}

