/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor;", "Lme/ahoo/wow/command/wait/WaitStrategy;", "stage", "Lme/ahoo/wow/command/wait/CommandStage;", "contextName", "", "processorName", "<init>", "(Lme/ahoo/wow/command/wait/CommandStage;Ljava/lang/String;Ljava/lang/String;)V", "getStage", "()Lme/ahoo/wow/command/wait/CommandStage;", "getContextName", "()Ljava/lang/String;", "getProcessorName", "sink", "Lreactor/core/publisher/Sinks$One;", "Lme/ahoo/wow/command/wait/WaitSignal;", "result", "", "", "waiting", "Lreactor/core/publisher/Mono;", "error", "", "throwable", "", "nextSignal", "signal", "next", "toString", "Companion", "wow-core"})
public final class WaitingFor
implements WaitStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommandStage stage;
    @NotNull
    private final String contextName;
    @NotNull
    private final String processorName;
    @NotNull
    private final Sinks.One<WaitSignal> sink;
    @NotNull
    private final Map<String, Object> result;
    private static final Logger log = LoggerFactory.getLogger(WaitingFor.class);

    public WaitingFor(@NotNull CommandStage stage, @NotNull String contextName, @NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        this.stage = stage;
        this.contextName = contextName;
        this.processorName = processorName;
        Sinks.One one = Sinks.one();
        Intrinsics.checkNotNullExpressionValue((Object)one, (String)"one(...)");
        this.sink = one;
        this.result = new LinkedHashMap();
    }

    public /* synthetic */ WaitingFor(CommandStage commandStage, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(commandStage, string, string2);
    }

    @NotNull
    public final CommandStage getStage() {
        return this.stage;
    }

    @NotNull
    public String getContextName() {
        return this.contextName;
    }

    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public Mono<WaitSignal> waiting() {
        Mono mono = this.sink.asMono();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"asMono(...)");
        return mono;
    }

    @Override
    public void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.sink.tryEmitError(throwable);
    }

    private final void nextSignal(WaitSignal signal) {
        WaitSignal mergedSignal = signal.copyResult(this.result);
        this.sink.tryEmitValue((Object)mergedSignal);
    }

    @Override
    public void next(@NotNull WaitSignal signal) {
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        if (log.isDebugEnabled()) {
            log.debug("Next " + signal + ".");
        }
        this.result.putAll(signal.getResult());
        if (!signal.getSucceeded() && this.stage.isAfter(signal.getStage())) {
            this.nextSignal(signal);
            return;
        }
        if (this.stage != signal.getStage()) {
            return;
        }
        if (this.stage == CommandStage.SENT || this.stage == CommandStage.PROCESSED || this.stage == CommandStage.SNAPSHOT) {
            this.nextSignal(signal);
            return;
        }
        if (!this.isSameBoundedContext((NamedBoundedContext)signal)) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)this.getProcessorName())) {
            if (signal.isLastProjection()) {
                this.nextSignal(signal);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)this.getProcessorName(), (Object)signal.getProcessorName())) {
            this.nextSignal(signal);
            return;
        }
    }

    @NotNull
    public String toString() {
        return "WaitingFor(stage=" + this.stage + ", contextName='" + this.getContextName() + "', processorName='" + this.getProcessorName() + "')";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "processed", "Lme/ahoo/wow/command/wait/WaitingFor;", "contextName", "", "snapshot", "projected", "processorName", "eventHandled", "sagaHandled", "stage", "Lme/ahoo/wow/command/wait/CommandStage;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WaitingFor processed(@NotNull String contextName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            return me.ahoo.wow.command.wait.WaitingFor$Companion.stage$default(this, CommandStage.PROCESSED, contextName, null, 4, null);
        }

        @NotNull
        public final WaitingFor snapshot(@NotNull String contextName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            return me.ahoo.wow.command.wait.WaitingFor$Companion.stage$default(this, CommandStage.SNAPSHOT, contextName, null, 4, null);
        }

        @NotNull
        public final WaitingFor projected(@NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return this.stage(CommandStage.PROJECTED, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor projected$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.projected(string, string2);
        }

        @NotNull
        public final WaitingFor eventHandled(@NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return this.stage(CommandStage.EVENT_HANDLED, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor eventHandled$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.eventHandled(string, string2);
        }

        @NotNull
        public final WaitingFor sagaHandled(@NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return this.stage(CommandStage.SAGA_HANDLED, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor sagaHandled$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            return companion.sagaHandled(string, string2);
        }

        @NotNull
        public final WaitingFor stage(@NotNull CommandStage stage, @NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            return new WaitingFor(stage, contextName, processorName);
        }

        public static /* synthetic */ WaitingFor stage$default(Companion companion, CommandStage commandStage, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            return companion.stage(commandStage, string, string2);
        }

        @NotNull
        public final WaitingFor stage(@NotNull String stage, @NotNull String contextName, @NotNull String processorName) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
            Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
            String string = stage;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return this.stage(CommandStage.valueOf(string2), contextName, processorName);
        }

        public static /* synthetic */ WaitingFor stage$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = "";
            }
            return companion.stage(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

