/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.eventsourcing;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.DuplicateAggregateIdException;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH$J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH$J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H$\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/eventsourcing/AbstractEventStore;", "Lme/ahoo/wow/eventsourcing/EventStore;", "<init>", "()V", "append", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "appendStream", "load", "Lreactor/core/publisher/Flux;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "headVersion", "", "tailVersion", "headEventTime", "", "tailEventTime", "loadStream", "Companion", "wow-core"})
public abstract class AbstractEventStore
implements EventStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(AbstractEventStore::log$lambda$7);

    @Override
    @NotNull
    public Mono<Void> append(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        log.debug(() -> AbstractEventStore.append$lambda$0(eventStream));
        Mono mono = this.appendStream(eventStream).onErrorMap(EventVersionConflictException.class, arg_0 -> AbstractEventStore.append$lambda$2(AbstractEventStore::append$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorMap(...)");
        return mono;
    }

    @NotNull
    protected abstract Mono<Void> appendStream(@NotNull DomainEventStream var1);

    @Override
    @NotNull
    public Flux<DomainEventStream> load(@NotNull AggregateId aggregateId, int headVersion, int tailVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        log.debug(() -> AbstractEventStore.load$lambda$3(aggregateId, headVersion, tailVersion));
        if (!(headVersion > -1)) {
            boolean $i$a$-require-AbstractEventStore$load$42 = false;
            String $i$a$-require-AbstractEventStore$load$42 = aggregateId + " headVersion[" + headVersion + "] must be greater than -1!";
            throw new IllegalArgumentException($i$a$-require-AbstractEventStore$load$42.toString());
        }
        if (!(tailVersion >= headVersion)) {
            boolean bl = false;
            String string = aggregateId + " headEventTime[" + tailVersion + "] must be greater than or equal to headEventTime[" + headVersion + "]!";
            throw new IllegalArgumentException(string.toString());
        }
        return this.loadStream(aggregateId, headVersion, tailVersion);
    }

    @Override
    @NotNull
    public Flux<DomainEventStream> load(@NotNull AggregateId aggregateId, long headEventTime, long tailEventTime) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        if (!(tailEventTime >= headEventTime)) {
            boolean bl = false;
            String string = aggregateId + " headEventTime[" + headEventTime + "] must be greater than or equal to headEventTime[" + headEventTime + "]!";
            throw new IllegalArgumentException(string.toString());
        }
        return this.loadStream(aggregateId, headEventTime, tailEventTime);
    }

    @NotNull
    protected abstract Flux<DomainEventStream> loadStream(@NotNull AggregateId var1, int var2, int var3);

    @NotNull
    protected abstract Flux<DomainEventStream> loadStream(@NotNull AggregateId var1, long var2, long var4);

    private static final Object append$lambda$0(DomainEventStream $eventStream) {
        return "Append " + $eventStream.getAggregateId() + " - version[" + $eventStream.getVersion() + "]";
    }

    private static final Throwable append$lambda$1(EventVersionConflictException it) {
        return it.getEventStream().getVersion() == 1 ? (Throwable)new DuplicateAggregateIdException(it.getEventStream(), null, it, 2, null) : (Throwable)it;
    }

    private static final Throwable append$lambda$2(Function1 $tmp0, Object p0) {
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final Object load$lambda$3(AggregateId $aggregateId, int $headVersion, int $tailVersion) {
        return "Load " + $aggregateId + " - headVersion[" + $headVersion + "] - tailVersion[" + $tailVersion + "].";
    }

    private static final Unit log$lambda$7() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/eventsourcing/AbstractEventStore$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

