/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.serialization.state;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.modeling.OwnerId;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.ReadOnlyStateAggregate;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ#\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0002H&\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lme/ahoo/wow/serialization/state/AbstractStateAggregateDeserializer;", "T", "Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "stateAggregateType", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "createStateAggregate", "stateRecord", "Lcom/fasterxml/jackson/databind/JsonNode;", "stateAggregate", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;)Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "wow-core"})
public abstract class AbstractStateAggregateDeserializer<T extends ReadOnlyStateAggregate<?>>
extends StdDeserializer<T> {
    public AbstractStateAggregateDeserializer(@NotNull Class<T> stateAggregateType) {
        Intrinsics.checkNotNullParameter(stateAggregateType, (String)"stateAggregateType");
        super(stateAggregateType);
    }

    @NotNull
    public T deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode stateRecord = (JsonNode)p.getCodec().readTree(p);
        String string = stateRecord.get("contextName").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        String string2 = stateRecord.get("aggregateName").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
        MaterializedNamedAggregate namedAggregate = new MaterializedNamedAggregate(string, string2);
        StateAggregateMetadata metadata = AggregateMetadataParserKt.aggregateMetadata(MetadataSearcherKt.requiredAggregateType(namedAggregate)).getState();
        int version = stateRecord.get("version").asInt();
        JsonNode jsonNode = stateRecord.get("ownerId");
        String ownerId = OwnerId.Companion.orDefaultOwnerId(jsonNode != null ? jsonNode.asText() : null);
        JsonNode jsonNode2 = stateRecord.get("eventId");
        String string3 = jsonNode2 != null ? jsonNode2.asText() : null;
        if (string3 == null) {
            string3 = "";
        }
        String eventId = string3;
        JsonNode jsonNode3 = stateRecord.get("firstOperator");
        String string4 = jsonNode3 != null ? jsonNode3.asText() : null;
        if (string4 == null) {
            string4 = "";
        }
        String firstOperator = string4;
        JsonNode jsonNode4 = stateRecord.get("operator");
        String string5 = jsonNode4 != null ? jsonNode4.asText() : null;
        if (string5 == null) {
            string5 = "";
        }
        String operator = string5;
        JsonNode jsonNode5 = stateRecord.get("firstEventTime");
        long firstEventTime = jsonNode5 != null ? jsonNode5.asLong() : 0L;
        JsonNode jsonNode6 = stateRecord.get("eventTime");
        long eventTime = jsonNode6 != null ? jsonNode6.asLong() : 0L;
        boolean deleted = stateRecord.get("deleted").asBoolean();
        JsonNode jsonNode7 = stateRecord.get("state");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode7, (String)"get(...)");
        Object stateRoot = JsonSerializerKt.toObject(jsonNode7, metadata.getAggregateType());
        NamedAggregate namedAggregate2 = namedAggregate;
        String string6 = stateRecord.get("aggregateId").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"asText(...)");
        String string7 = stateRecord.get("tenantId").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"asText(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId(namedAggregate2, string6, string7);
        StateAggregate stateAggregate = ConstructorStateAggregateFactory.toStateAggregate(metadata, aggregateId, stateRoot, version, ownerId, eventId, firstOperator, operator, firstEventTime, eventTime, deleted);
        Intrinsics.checkNotNull((Object)stateRecord);
        return this.createStateAggregate(stateRecord, stateAggregate);
    }

    @NotNull
    public abstract T createStateAggregate(@NotNull JsonNode var1, @NotNull ReadOnlyStateAggregate<Object> var2);
}

