/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitingFor;
import me.ahoo.wow.command.wait.WaitingForKt;
import org.jetbrains.annotations.NotNull;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\b&\u0018\u0000  2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lme/ahoo/wow/command/wait/AbstractWaitingFor;", "Lme/ahoo/wow/command/wait/WaitingFor;", "<init>", "()V", "waitSignalSink", "Lreactor/core/publisher/Sinks$Many;", "Lme/ahoo/wow/command/wait/WaitSignal;", "cancelled", "", "getCancelled", "()Z", "terminated", "getTerminated", "onFinallyHook", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/function/Consumer;", "Lreactor/core/publisher/SignalType;", "safeDoFinally", "", "signalType", "waiting", "Lreactor/core/publisher/Flux;", "busyLooping", "Lreactor/core/publisher/Sinks$EmitFailureHandler;", "next", "signal", "error", "throwable", "", "complete", "onFinally", "doFinally", "Companion", "EmptyOnFinally", "wow-core"})
public abstract class AbstractWaitingFor
implements WaitingFor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sinks.Many<WaitSignal> waitSignalSink;
    @NotNull
    private AtomicReference<Consumer<SignalType>> onFinallyHook;
    @NotNull
    private static final Duration DEFAULT_BUSY_LOOPING_DURATION;

    public AbstractWaitingFor() {
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.waitSignalSink = many;
        this.onFinallyHook = new AtomicReference<EmptyOnFinally>(EmptyOnFinally.INSTANCE);
    }

    @Override
    public boolean getCancelled() {
        Object object = Scannable.from(this.waitSignalSink).scanOrDefault(Scannable.Attr.CANCELLED, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scanOrDefault(...)");
        return (Boolean)object;
    }

    @Override
    public boolean getTerminated() {
        Object object = Scannable.from(this.waitSignalSink).scanOrDefault(Scannable.Attr.TERMINATED, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scanOrDefault(...)");
        return (Boolean)object;
    }

    private final void safeDoFinally(SignalType signalType) {
        Consumer<SignalType> currentHook = this.onFinallyHook.get();
        try {
            currentHook.accept(signalType);
        }
        catch (Throwable error) {
            WaitingForKt.access$getLog$p().error(error, AbstractWaitingFor::safeDoFinally$lambda$0);
        }
    }

    @Override
    @NotNull
    public Flux<WaitSignal> waiting() {
        Flux flux = this.waitSignalSink.asFlux().doFinally(this::safeDoFinally);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doFinally(...)");
        return flux;
    }

    private final Sinks.EmitFailureHandler busyLooping() {
        Sinks.EmitFailureHandler emitFailureHandler = Sinks.EmitFailureHandler.busyLooping((Duration)DEFAULT_BUSY_LOOPING_DURATION);
        Intrinsics.checkNotNullExpressionValue((Object)emitFailureHandler, (String)"busyLooping(...)");
        return emitFailureHandler;
    }

    @Override
    public void next(@NotNull WaitSignal signal) {
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        this.waitSignalSink.emitNext((Object)signal, this.busyLooping());
    }

    @Override
    public void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.waitSignalSink.emitError(throwable, this.busyLooping());
    }

    @Override
    public void complete() {
        this.waitSignalSink.emitComplete(this.busyLooping());
    }

    @Override
    public void onFinally(@NotNull Consumer<SignalType> doFinally) {
        Intrinsics.checkNotNullParameter(doFinally, (String)"doFinally");
        if (!this.onFinallyHook.compareAndSet(EmptyOnFinally.INSTANCE, doFinally)) {
            boolean bl = false;
            String string = "Finally hook already set [" + this.onFinallyHook.get() + "]";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final Object safeDoFinally$lambda$0() {
        return "Finally hook execution failed";
    }

    static {
        Duration duration = Duration.ofMillis(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        DEFAULT_BUSY_LOOPING_DURATION = duration;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/command/wait/AbstractWaitingFor$Companion;", "", "<init>", "()V", "DEFAULT_BUSY_LOOPING_DURATION", "Ljava/time/Duration;", "getDEFAULT_BUSY_LOOPING_DURATION", "()Ljava/time/Duration;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDEFAULT_BUSY_LOOPING_DURATION() {
            return DEFAULT_BUSY_LOOPING_DURATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/command/wait/AbstractWaitingFor$EmptyOnFinally;", "Ljava/util/function/Consumer;", "Lreactor/core/publisher/SignalType;", "<init>", "()V", "accept", "", "t", "wow-core"})
    public static final class EmptyOnFinally
    implements Consumer<SignalType> {
        @NotNull
        public static final EmptyOnFinally INSTANCE = new EmptyOnFinally();

        private EmptyOnFinally() {
        }

        @Override
        public void accept(@NotNull SignalType t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        }
    }
}

