/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import jakarta.validation.Validator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.command.validation.CommandValidator;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.messaging.TopicKind;
import me.ahoo.wow.api.messaging.function.FunctionInfo;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.ClientCommandExchange;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandGatewayKt;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.CommandResultException;
import me.ahoo.wow.command.CommandResultKt;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.SimpleClientCommandExchange;
import me.ahoo.wow.command.validation.ValidatorsKt;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.CommandWaitNotifierKt;
import me.ahoo.wow.command.wait.SimpleWaitSignal;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitingFor;
import me.ahoo.wow.id.GlobalIdGeneratorKt;
import me.ahoo.wow.infra.idempotency.AggregateIdempotencyCheckerProvider;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J.\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J6\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00100\"0\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010#\u001a\u00020$*\u00020%2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u001c\u0010(\u001a\u00020\u000f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\t\u0010)\u001a\u00020\u000fH\u0096\u0001J!\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030+0\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0002008VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Lme/ahoo/wow/command/DefaultCommandGateway;", "Lme/ahoo/wow/command/CommandGateway;", "Lme/ahoo/wow/command/CommandBus;", "commandWaitEndpoint", "Lme/ahoo/wow/command/wait/CommandWaitEndpoint;", "commandBus", "validator", "Ljakarta/validation/Validator;", "idempotencyCheckerProvider", "Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "<init>", "(Lme/ahoo/wow/command/wait/CommandWaitEndpoint;Lme/ahoo/wow/command/CommandBus;Ljakarta/validation/Validator;Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;)V", "validate", "", "C", "", "commandBody", "(Ljava/lang/Object;)V", "idempotencyCheck", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "command", "Lme/ahoo/wow/api/command/CommandMessage;", "check", "send", "message", "sendAndWaitStream", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/CommandResult;", "waitStrategy", "Lme/ahoo/wow/command/wait/WaitStrategy;", "sendAndWait", "Lme/ahoo/wow/command/ClientCommandExchange;", "toCommandResultException", "Lme/ahoo/wow/command/CommandResultException;", "", "thenEmitSentSignal", "ensureUnregister", "safeEmitSentSignal", "close", "receive", "Lme/ahoo/wow/command/ServerCommandExchange;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "topicKind", "Lme/ahoo/wow/api/messaging/TopicKind;", "getTopicKind", "()Lme/ahoo/wow/api/messaging/TopicKind;", "Companion", "wow-core"})
@SourceDebugExtension(value={"SMAP\nDefaultCommandGateway.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCommandGateway.kt\nme/ahoo/wow/command/DefaultCommandGateway\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class DefaultCommandGateway
implements CommandGateway,
CommandBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommandWaitEndpoint commandWaitEndpoint;
    @NotNull
    private final CommandBus commandBus;
    @NotNull
    private final Validator validator;
    @NotNull
    private final AggregateIdempotencyCheckerProvider idempotencyCheckerProvider;
    @NotNull
    private final WaitStrategyRegistrar waitStrategyRegistrar;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(DefaultCommandGateway::log$lambda$17);

    public DefaultCommandGateway(@NotNull CommandWaitEndpoint commandWaitEndpoint, @NotNull CommandBus commandBus, @NotNull Validator validator, @NotNull AggregateIdempotencyCheckerProvider idempotencyCheckerProvider, @NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)commandWaitEndpoint, (String)"commandWaitEndpoint");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)idempotencyCheckerProvider, (String)"idempotencyCheckerProvider");
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        this.commandWaitEndpoint = commandWaitEndpoint;
        this.commandBus = commandBus;
        this.validator = validator;
        this.idempotencyCheckerProvider = idempotencyCheckerProvider;
        this.waitStrategyRegistrar = waitStrategyRegistrar;
    }

    private final <C> void validate(C commandBody) {
        if (commandBody instanceof CommandValidator) {
            ((CommandValidator)commandBody).validate();
        }
        ValidatorsKt.validateCommand(this.validator, commandBody);
    }

    private final Mono<Void> idempotencyCheck(CommandMessage<?> command) {
        Mono mono = this.idempotencyCheckerProvider.getChecker(MaterializedNamedAggregateKt.materialize(command.getAggregateId().getNamedAggregate())).check(command.getRequestId()).doOnNext(arg_0 -> DefaultCommandGateway.idempotencyCheck$lambda$1(arg_0 -> DefaultCommandGateway.idempotencyCheck$lambda$0(command, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private final <C> Mono<Void> check(CommandMessage<C> command) {
        Mono mono = this.idempotencyCheck(command).then(Mono.fromRunnable(() -> DefaultCommandGateway.check$lambda$2(this, command)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> send(@NotNull CommandMessage<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Mono mono = this.check(message).then(this.commandBus.send((Message)message));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Flux<CommandResult> sendAndWaitStream(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        Flux flux = this.send(command, waitStrategy).flatMapMany(arg_0 -> DefaultCommandGateway.sendAndWaitStream$lambda$3(new Function1(waitStrategy){
            final /* synthetic */ WaitStrategy $waitStrategy;
            {
                this.$waitStrategy = $waitStrategy;
            }

            public final Publisher<? extends CommandResult> invoke(ClientCommandExchange<C> it) {
                return (Publisher)this.$waitStrategy.waiting().map(arg_0 -> sendAndWaitStream.1.invoke$lambda$1(arg_0 -> sendAndWaitStream.1.invoke$lambda$0(it, arg_0), arg_0));
            }

            private static final CommandResult invoke$lambda$0(ClientCommandExchange $it, WaitSignal waitSignal) {
                Intrinsics.checkNotNull((Object)waitSignal);
                return CommandResultKt.toResult(waitSignal, (CommandMessage)$it.getMessage());
            }

            private static final CommandResult invoke$lambda$1(Function1 $tmp0, Object p0) {
                return (CommandResult)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapMany(...)");
        return flux;
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWait(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        Mono mono = this.send(command, waitStrategy).flatMap(arg_0 -> DefaultCommandGateway.sendAndWait$lambda$4(new Function1(waitStrategy){
            final /* synthetic */ WaitStrategy $waitStrategy;
            {
                this.$waitStrategy = $waitStrategy;
            }

            public final Mono<? extends CommandResult> invoke(ClientCommandExchange<C> it) {
                return this.$waitStrategy.waitingLast().map(arg_0 -> sendAndWait.1.invoke$lambda$2(arg_0 -> sendAndWait.1.invoke$lambda$1(it, arg_0), arg_0));
            }

            private static final CommandResult invoke$lambda$1(ClientCommandExchange $it, WaitSignal waitSignal) {
                CommandResult commandResult;
                Intrinsics.checkNotNull((Object)waitSignal);
                CommandResult $this$invoke_u24lambda_u241_u24lambda_u240 = commandResult = CommandResultKt.toResult(waitSignal, (CommandMessage)$it.getMessage());
                boolean bl = false;
                if (!$this$invoke_u24lambda_u241_u24lambda_u240.getSucceeded()) {
                    throw new CommandResultException($this$invoke_u24lambda_u241_u24lambda_u240, null, 2, null);
                }
                return commandResult;
            }

            private static final CommandResult invoke$lambda$2(Function1 $tmp0, Object p0) {
                return (CommandResult)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Mono<? extends ClientCommandExchange<C>> send(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        if (!(waitStrategy instanceof WaitingFor)) {
            boolean $i$a$-require-DefaultCommandGateway$send$32 = false;
            String $i$a$-require-DefaultCommandGateway$send$32 = "waitStrategy must be WaitingFor.";
            throw new IllegalArgumentException($i$a$-require-DefaultCommandGateway$send$32.toString());
        }
        if (command.isVoid() && !(((WaitingFor)waitStrategy).getStage() == CommandStage.SENT)) {
            boolean bl = false;
            String string = "The wait strategy for the void command must be SENT.";
            throw new IllegalArgumentException(string.toString());
        }
        Mono mono = this.check(command).then(Mono.defer(() -> DefaultCommandGateway.send$lambda$8(command, this, waitStrategy))).onErrorMap(arg_0 -> DefaultCommandGateway.send$lambda$10(arg_0 -> DefaultCommandGateway.send$lambda$9(this, command, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorMap(...)");
        return mono;
    }

    private final CommandResultException toCommandResultException(Throwable $this$toCommandResultException, CommandMessage<?> command) {
        return new CommandResultException(CommandResultKt.toResult$default($this$toCommandResultException, command, null, "CommandGateway", null, null, null, 0L, 122, null), $this$toCommandResultException);
    }

    private final Mono<Void> thenEmitSentSignal(Mono<Void> $this$thenEmitSentSignal, CommandMessage<?> command, WaitStrategy waitStrategy) {
        Mono mono = $this$thenEmitSentSignal.doOnSuccess(arg_0 -> DefaultCommandGateway.thenEmitSentSignal$lambda$12(arg_0 -> DefaultCommandGateway.thenEmitSentSignal$lambda$11(this, command, waitStrategy, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    private final Mono<Void> ensureUnregister(Mono<Void> $this$ensureUnregister, CommandMessage<?> command) {
        Mono mono = $this$ensureUnregister.doOnCancel(() -> DefaultCommandGateway.ensureUnregister$lambda$13(this, command)).doOnError(arg_0 -> DefaultCommandGateway.ensureUnregister$lambda$15(arg_0 -> DefaultCommandGateway.ensureUnregister$lambda$14(this, command, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    private final void safeEmitSentSignal(CommandMessage<?> command, WaitStrategy waitStrategy) {
        WaitSignal waitSignal = SimpleWaitSignal.Companion.toWaitSignal$default(SimpleWaitSignal.Companion, (FunctionInfo)CommandGatewayKt.getCOMMAND_GATEWAY_FUNCTION(), GlobalIdGeneratorKt.generateGlobalId(), command.getCommandId(), CommandStage.SENT, false, null, null, null, null, 0L, 504, null);
        try {
            waitStrategy.next(waitSignal);
        }
        catch (Sinks.EmissionException emissionError) {
            log.warn((Throwable)emissionError, () -> DefaultCommandGateway.safeEmitSentSignal$lambda$16(command));
        }
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWaitForSent(@NotNull CommandMessage<C> command) {
        return CommandGateway.super.sendAndWaitForSent(command);
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWaitForProcessed(@NotNull CommandMessage<C> command) {
        return CommandGateway.super.sendAndWaitForProcessed(command);
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWaitForSnapshot(@NotNull CommandMessage<C> command) {
        return CommandGateway.super.sendAndWaitForSnapshot(command);
    }

    @Override
    @NotNull
    public TopicKind getTopicKind() {
        return this.commandBus.getTopicKind();
    }

    @Override
    public void close() {
        this.commandBus.close();
    }

    @Override
    @NotNull
    public Flux<ServerCommandExchange<?>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.commandBus.receive(namedAggregates);
    }

    private static final Unit idempotencyCheck$lambda$0(CommandMessage $command, Boolean it) {
        if (!it.booleanValue()) {
            throw new DuplicateRequestIdException($command.getAggregateId(), $command.getRequestId(), null, null, 12, null);
        }
        return Unit.INSTANCE;
    }

    private static final void idempotencyCheck$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void check$lambda$2(DefaultCommandGateway this$0, CommandMessage $command) {
        this$0.validate($command.getBody());
    }

    private static final Publisher sendAndWaitStream$lambda$3(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono sendAndWait$lambda$4(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void send$lambda$8$lambda$7(DefaultCommandGateway this$0, CommandMessage $command, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.waitStrategyRegistrar.unregister($command.getCommandId());
    }

    private static final Mono send$lambda$8(CommandMessage $command, DefaultCommandGateway this$0, WaitStrategy $waitStrategy) {
        CommandWaitNotifierKt.injectWaitStrategy($command.getHeader(), this$0.commandWaitEndpoint.getEndpoint(), ((WaitingFor)$waitStrategy).getStage(), $waitStrategy.getContextName(), $waitStrategy.getProcessorName());
        this$0.waitStrategyRegistrar.register($command.getCommandId(), $waitStrategy);
        $waitStrategy.onFinally(arg_0 -> DefaultCommandGateway.send$lambda$8$lambda$7(this$0, $command, arg_0));
        ClientCommandExchange commandExchange = new SimpleClientCommandExchange($command, $waitStrategy, null, 4, null);
        return this$0.ensureUnregister(this$0.thenEmitSentSignal(this$0.commandBus.send((Message)$command), $command, $waitStrategy), $command).thenReturn((Object)commandExchange);
    }

    private static final Throwable send$lambda$9(DefaultCommandGateway this$0, CommandMessage $command, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.toCommandResultException(it, $command);
    }

    private static final Throwable send$lambda$10(Function1 $tmp0, Object p0) {
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final Unit thenEmitSentSignal$lambda$11(DefaultCommandGateway this$0, CommandMessage $command, WaitStrategy $waitStrategy, Void it) {
        this$0.safeEmitSentSignal($command, $waitStrategy);
        return Unit.INSTANCE;
    }

    private static final void thenEmitSentSignal$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void ensureUnregister$lambda$13(DefaultCommandGateway this$0, CommandMessage $command) {
        this$0.waitStrategyRegistrar.unregister($command.getCommandId());
    }

    private static final Unit ensureUnregister$lambda$14(DefaultCommandGateway this$0, CommandMessage $command, Throwable it) {
        this$0.waitStrategyRegistrar.unregister($command.getCommandId());
        return Unit.INSTANCE;
    }

    private static final void ensureUnregister$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object safeEmitSentSignal$lambda$16(CommandMessage $command) {
        return "The wait strategy [" + $command.getCommandId() + "] is cancelled or terminated, so the signal is not sent.";
    }

    private static final Unit log$lambda$17() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/command/DefaultCommandGateway$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

