/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.state;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.event.AggregateDeleted;
import me.ahoo.wow.api.event.AggregateRecovered;
import me.ahoo.wow.api.event.DomainEvent;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.TypedAggregate;
import me.ahoo.wow.command.CommandOperator;
import me.ahoo.wow.event.DomainEventExchange;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamKt;
import me.ahoo.wow.event.SimpleDomainEventExchange;
import me.ahoo.wow.messaging.function.MessageFunction;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.SourcingVersionConflictException;
import me.ahoo.wow.modeling.state.StateAggregate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 K*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001KBu\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010>\u001a\u00020?H\u0016J\u0014\u0010@\u001a\u00020A2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030CH\u0002J\u0013\u0010D\u001a\u00020\u00152\b\u0010E\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010F\u001a\u00020\rH\u0016J\b\u0010G\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\t\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u000e\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001a\u0010\u000f\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010 \"\u0004\b*\u0010\"R\u001a\u0010\u0010\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u0010\u0013\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010.\"\u0004\b2\u00100R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R4\u00107\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u000309\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030;\u0012\u0004\u0012\u00020<0:08X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00028\u000009X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006L"}, d2={"Lme/ahoo/wow/modeling/state/SimpleStateAggregate;", "S", "", "Lme/ahoo/wow/modeling/state/StateAggregate;", "Lme/ahoo/wow/api/modeling/TypedAggregate;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "metadata", "Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;", "state", "ownerId", "", "version", "", "eventId", "firstOperator", "operator", "firstEventTime", "", "eventTime", "deleted", "", "<init>", "(Lme/ahoo/wow/api/modeling/AggregateId;Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;Ljava/lang/Object;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;JJZ)V", "getAggregateId", "()Lme/ahoo/wow/api/modeling/AggregateId;", "getMetadata", "()Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;", "getState", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getOwnerId", "()Ljava/lang/String;", "setOwnerId", "(Ljava/lang/String;)V", "getVersion", "()I", "setVersion", "(I)V", "getEventId", "setEventId", "getFirstOperator", "setFirstOperator", "getOperator", "setOperator", "getFirstEventTime", "()J", "setFirstEventTime", "(J)V", "getEventTime", "setEventTime", "getDeleted", "()Z", "setDeleted", "(Z)V", "sourcingRegistry", "", "Ljava/lang/Class;", "Lme/ahoo/wow/messaging/function/MessageFunction;", "Lme/ahoo/wow/event/DomainEventExchange;", "Ljava/lang/Void;", "onSourcing", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "sourcing", "", "domainEvent", "Lme/ahoo/wow/api/event/DomainEvent;", "equals", "other", "hashCode", "toString", "aggregateType", "getAggregateType", "()Ljava/lang/Class;", "Companion", "wow-core"})
public final class SimpleStateAggregate<S>
implements StateAggregate<S>,
TypedAggregate<S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateId aggregateId;
    @NotNull
    private final StateAggregateMetadata<S> metadata;
    @NotNull
    private final S state;
    @NotNull
    private String ownerId;
    private int version;
    @NotNull
    private String eventId;
    @NotNull
    private String firstOperator;
    @NotNull
    private String operator;
    private long firstEventTime;
    private long eventTime;
    private boolean deleted;
    @NotNull
    private final Map<Class<?>, MessageFunction<S, DomainEventExchange<?>, Void>> sourcingRegistry;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(SimpleStateAggregate::log$lambda$3);

    public SimpleStateAggregate(@NotNull AggregateId aggregateId, @NotNull StateAggregateMetadata<S> metadata, @NotNull S state, @NotNull String ownerId, int version, @NotNull String eventId, @NotNull String firstOperator, @NotNull String operator, long firstEventTime, long eventTime, boolean deleted) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)firstOperator, (String)"firstOperator");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        this.aggregateId = aggregateId;
        this.metadata = metadata;
        this.state = state;
        this.ownerId = ownerId;
        this.version = version;
        this.eventId = eventId;
        this.firstOperator = firstOperator;
        this.operator = operator;
        this.firstEventTime = firstEventTime;
        this.eventTime = eventTime;
        this.deleted = deleted;
        this.sourcingRegistry = this.metadata.toMessageFunctionRegistry(this.getState());
    }

    public /* synthetic */ SimpleStateAggregate(AggregateId aggregateId, StateAggregateMetadata stateAggregateMetadata, Object object, String string, int n, String string2, String string3, String string4, long l, long l2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            string2 = "";
        }
        if ((n2 & 0x40) != 0) {
            string3 = "";
        }
        if ((n2 & 0x80) != 0) {
            string4 = "";
        }
        if ((n2 & 0x100) != 0) {
            l = 0L;
        }
        if ((n2 & 0x200) != 0) {
            l2 = 0L;
        }
        if ((n2 & 0x400) != 0) {
            bl = false;
        }
        this(aggregateId, stateAggregateMetadata, object, string, n, string2, string3, string4, l, l2, bl);
    }

    @Override
    @NotNull
    public AggregateId getAggregateId() {
        return this.aggregateId;
    }

    @NotNull
    public final StateAggregateMetadata<S> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public S getState() {
        return this.state;
    }

    @NotNull
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ownerId = string;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    @NotNull
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.eventId = string;
    }

    @NotNull
    public String getFirstOperator() {
        return this.firstOperator;
    }

    public void setFirstOperator(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.firstOperator = string;
    }

    @NotNull
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.operator = string;
    }

    public long getFirstEventTime() {
        return this.firstEventTime;
    }

    public void setFirstEventTime(long l) {
        this.firstEventTime = l;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long l) {
        this.eventTime = l;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    @Override
    @NotNull
    public StateAggregate<S> onSourcing(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        log.debug(() -> SimpleStateAggregate.onSourcing$lambda$0(eventStream));
        if (DomainEventStreamKt.ignoreSourcing(eventStream)) {
            return this;
        }
        if (!Intrinsics.areEqual((Object)this.getAggregateId(), (Object)eventStream.getAggregateId())) {
            boolean $i$a$-require-SimpleStateAggregate$onSourcing$32 = false;
            String $i$a$-require-SimpleStateAggregate$onSourcing$32 = "Failed to Sourcing eventStream[" + eventStream.getId() + "]: Current StateAggregate's AggregateId[" + this + "] is inconsistent with the DomainEventStream's AggregateId[" + eventStream.getAggregateId() + "].";
            throw new IllegalArgumentException($i$a$-require-SimpleStateAggregate$onSourcing$32.toString());
        }
        if (this.getExpectedNextVersion() != eventStream.getVersion()) {
            throw new SourcingVersionConflictException(eventStream, this.getExpectedNextVersion(), null, 4, null);
        }
        for (DomainEvent domainEvent : eventStream) {
            this.sourcing(domainEvent);
        }
        this.setVersion(eventStream.getVersion());
        if (!StringsKt.isBlank((CharSequence)eventStream.getOwnerId())) {
            this.setOwnerId(eventStream.getOwnerId());
        }
        this.setEventId(eventStream.getId());
        String string = CommandOperator.INSTANCE.getOperator(eventStream.getHeader());
        if (string == null) {
            string = "";
        }
        this.setOperator(string);
        this.setEventTime(eventStream.getCreateTime());
        if (this.isInitialVersion()) {
            this.setFirstOperator(this.getOperator());
            this.setFirstEventTime(this.getEventTime());
        }
        return this;
    }

    private final void sourcing(DomainEvent<?> domainEvent) {
        MessageFunction<S, DomainEventExchange<?>, Void> sourcingFunction;
        if (domainEvent.getBody() instanceof AggregateDeleted) {
            this.setDeleted(true);
        }
        if (domainEvent.getBody() instanceof AggregateRecovered) {
            this.setDeleted(false);
        }
        if ((sourcingFunction = this.sourcingRegistry.get(domainEvent.getBody().getClass())) != null) {
            sourcingFunction.invoke(new SimpleDomainEventExchange(domainEvent, null, 2, null));
        } else {
            log.debug(() -> SimpleStateAggregate.sourcing$lambda$2(domainEvent));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleStateAggregate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAggregateId(), (Object)((SimpleStateAggregate)other).getAggregateId())) {
            return false;
        }
        return this.getVersion() == ((SimpleStateAggregate)other).getVersion();
    }

    public int hashCode() {
        int result = this.getAggregateId().hashCode();
        result = 31 * result + this.getVersion();
        return result;
    }

    @NotNull
    public String toString() {
        return "SimpleStateAggregate(aggregateId=" + this.getAggregateId() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public int getExpectedNextVersion() {
        return StateAggregate.super.getExpectedNextVersion();
    }

    public boolean getInitialized() {
        return StateAggregate.super.getInitialized();
    }

    public boolean isInitialVersion() {
        return StateAggregate.super.isInitialVersion();
    }

    @NotNull
    public Class<S> getAggregateType() {
        return this.metadata.getAggregateType();
    }

    private static final Object onSourcing$lambda$0(DomainEventStream $eventStream) {
        return "onSourcing " + $eventStream + ".";
    }

    private static final Object sourcing$lambda$2(DomainEvent $domainEvent) {
        return "Sourcing " + $domainEvent + " Ignore this domain event because onSourcing does not exist.";
    }

    private static final Unit log$lambda$3() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/modeling/state/SimpleStateAggregate$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

