/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.command;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.exception.RecoverableType;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.modeling.NamedTypedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.exception.WowExceptionKt;
import me.ahoo.wow.modeling.command.AggregateProcessor;
import me.ahoo.wow.modeling.command.CommandAggregate;
import me.ahoo.wow.modeling.command.CommandAggregateFactory;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.CommandAggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0001-B;\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0096\u0001J\u0011\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0096\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0017R\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0017\u00a8\u0006."}, d2={"Lme/ahoo/wow/modeling/command/RetryableAggregateProcessor;", "C", "", "S", "Lme/ahoo/wow/modeling/command/AggregateProcessor;", "Lme/ahoo/wow/api/modeling/NamedTypedAggregate;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "aggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "commandAggregateFactory", "Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "<init>", "(Lme/ahoo/wow/api/modeling/AggregateId;Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lme/ahoo/wow/modeling/state/StateAggregateFactory;Lme/ahoo/wow/modeling/state/StateAggregateRepository;Lme/ahoo/wow/modeling/command/CommandAggregateFactory;)V", "getAggregateId", "()Lme/ahoo/wow/api/modeling/AggregateId;", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "retryStrategy", "Lreactor/util/retry/Retry;", "process", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/event/DomainEventStream;", "exchange", "Lme/ahoo/wow/command/ServerCommandExchange;", "isSameAggregateName", "", "other", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "isSameBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateName", "getAggregateName", "aggregateType", "Ljava/lang/Class;", "getAggregateType", "()Ljava/lang/Class;", "contextName", "getContextName", "Companion", "wow-core"})
public final class RetryableAggregateProcessor<C, S>
implements AggregateProcessor<C>,
NamedTypedAggregate<C> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final /* synthetic */ CommandAggregateMetadata<C> $$delegate_0;
    @NotNull
    private final AggregateId aggregateId;
    @NotNull
    private final AggregateMetadata<C, S> aggregateMetadata;
    @NotNull
    private final StateAggregateFactory aggregateFactory;
    @NotNull
    private final StateAggregateRepository stateAggregateRepository;
    @NotNull
    private final CommandAggregateFactory commandAggregateFactory;
    @NotNull
    private final String processorName;
    @NotNull
    private final Retry retryStrategy;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(RetryableAggregateProcessor::log$lambda$8);
    private static final long MAX_RETRIES = 3L;
    private static final Duration MIN_BACKOFF = Duration.ofMillis(500L);

    public RetryableAggregateProcessor(@NotNull AggregateId aggregateId, @NotNull AggregateMetadata<C, S> aggregateMetadata, @NotNull StateAggregateFactory aggregateFactory, @NotNull StateAggregateRepository stateAggregateRepository, @NotNull CommandAggregateFactory commandAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)aggregateFactory, (String)"aggregateFactory");
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"stateAggregateRepository");
        Intrinsics.checkNotNullParameter((Object)commandAggregateFactory, (String)"commandAggregateFactory");
        this.$$delegate_0 = aggregateMetadata.getCommand();
        this.aggregateId = aggregateId;
        this.aggregateMetadata = aggregateMetadata;
        this.aggregateFactory = aggregateFactory;
        this.stateAggregateRepository = stateAggregateRepository;
        this.commandAggregateFactory = commandAggregateFactory;
        String string = Reflection.getOrCreateKotlinClass(RetryableAggregateProcessor.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.processorName = string;
        RetryBackoffSpec retryBackoffSpec = Retry.backoff((long)3L, (Duration)MIN_BACKOFF).filter(arg_0 -> RetryableAggregateProcessor.retryStrategy$lambda$1(RetryableAggregateProcessor::retryStrategy$lambda$0, arg_0)).doBeforeRetry(arg_0 -> RetryableAggregateProcessor.retryStrategy$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)retryBackoffSpec, (String)"doBeforeRetry(...)");
        this.retryStrategy = (Retry)retryBackoffSpec;
    }

    @Override
    @NotNull
    public AggregateId getAggregateId() {
        return this.aggregateId;
    }

    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public Mono<DomainEventStream> process(@NotNull ServerCommandExchange<?> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Mono stateAggregateMono = ((CommandMessage)exchange.getMessage()).isCreate() ? this.aggregateFactory.createAsMono(this.aggregateMetadata.getState(), ((CommandMessage)exchange.getMessage()).getAggregateId()) : StateAggregateRepository.load$default(this.stateAggregateRepository, this.getAggregateId(), this.aggregateMetadata.getState(), 0, 4, null);
        Mono mono = stateAggregateMono.map(arg_0 -> RetryableAggregateProcessor.process$lambda$5(arg_0 -> RetryableAggregateProcessor.process$lambda$4(this, arg_0), arg_0)).flatMap(arg_0 -> RetryableAggregateProcessor.process$lambda$7(arg_0 -> RetryableAggregateProcessor.process$lambda$6(exchange, arg_0), arg_0)).retryWhen(this.retryStrategy);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"retryWhen(...)");
        return mono;
    }

    @NotNull
    public Class<C> getAggregateType() {
        return this.$$delegate_0.getAggregateType();
    }

    public boolean isSameAggregateName(@NotNull NamedAggregate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.$$delegate_0.isSameAggregateName(other);
    }

    @NotNull
    public String getAggregateName() {
        return this.$$delegate_0.getAggregateName();
    }

    public boolean isSameBoundedContext(@NotNull NamedBoundedContext other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.$$delegate_0.isSameBoundedContext(other);
    }

    @NotNull
    public String getContextName() {
        return this.$$delegate_0.getContextName();
    }

    private static final boolean retryStrategy$lambda$0(Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        return WowExceptionKt.getRecoverable(it) == RecoverableType.RECOVERABLE;
    }

    private static final boolean retryStrategy$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object retryStrategy$lambda$3$lambda$2(RetryableAggregateProcessor this$0, Retry.RetrySignal $it) {
        return "[BeforeRetry] " + this$0.getAggregateId() + " totalRetries[" + $it.totalRetries() + "].";
    }

    private static final void retryStrategy$lambda$3(RetryableAggregateProcessor this$0, Retry.RetrySignal it) {
        log.warn(it.failure(), () -> RetryableAggregateProcessor.retryStrategy$lambda$3$lambda$2(this$0, it));
    }

    private static final CommandAggregate process$lambda$4(RetryableAggregateProcessor this$0, StateAggregate it) {
        CommandAggregateFactory commandAggregateFactory = this$0.commandAggregateFactory;
        AggregateMetadata aggregateMetadata = this$0.aggregateMetadata;
        Intrinsics.checkNotNull((Object)it);
        return commandAggregateFactory.create(aggregateMetadata, it);
    }

    private static final CommandAggregate process$lambda$5(Function1 $tmp0, Object p0) {
        return (CommandAggregate)$tmp0.invoke(p0);
    }

    private static final Mono process$lambda$6(ServerCommandExchange $exchange, CommandAggregate it) {
        $exchange.clearError();
        return it.process($exchange);
    }

    private static final Mono process$lambda$7(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Unit log$lambda$8() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/modeling/command/RetryableAggregateProcessor$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "MAX_RETRIES", "", "MIN_BACKOFF", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

