/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command;

import jakarta.validation.Validator;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.command.validation.CommandValidator;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.messaging.TopicKind;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.ClientCommandExchange;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.CommandResultException;
import me.ahoo.wow.command.CommandResultKt;
import me.ahoo.wow.command.CommandValidationException;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.SimpleClientCommandExchange;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.CommandWaitNotifierKt;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitingFor;
import me.ahoo.wow.infra.idempotency.AggregateIdempotencyCheckerProvider;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J*\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0015\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018H\u0016J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0006\u0010!\u001a\u00020\"H\u0016J6\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00100#0\u0015\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\t\u0010$\u001a\u00020\u000fH\u0096\u0001J!\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lme/ahoo/wow/command/DefaultCommandGateway;", "Lme/ahoo/wow/command/CommandGateway;", "Lme/ahoo/wow/command/CommandBus;", "commandWaitEndpoint", "Lme/ahoo/wow/command/wait/CommandWaitEndpoint;", "commandBus", "validator", "Ljakarta/validation/Validator;", "idempotencyCheckerProvider", "Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "<init>", "(Lme/ahoo/wow/command/wait/CommandWaitEndpoint;Lme/ahoo/wow/command/CommandBus;Ljakarta/validation/Validator;Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;)V", "validate", "", "C", "", "commandBody", "(Ljava/lang/Object;)V", "idempotencyCheck", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "command", "Lme/ahoo/wow/api/command/CommandMessage;", "check", "send", "message", "errorMapToCommandResultException", "T", "sendAndWaitForSent", "Lme/ahoo/wow/command/CommandResult;", "sendAndWait", "waitStrategy", "Lme/ahoo/wow/command/wait/WaitStrategy;", "Lme/ahoo/wow/command/ClientCommandExchange;", "close", "receive", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/ServerCommandExchange;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "topicKind", "Lme/ahoo/wow/api/messaging/TopicKind;", "getTopicKind", "()Lme/ahoo/wow/api/messaging/TopicKind;", "wow-core"})
@SourceDebugExtension(value={"SMAP\nDefaultCommandGateway.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCommandGateway.kt\nme/ahoo/wow/command/DefaultCommandGateway\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class DefaultCommandGateway
implements CommandGateway,
CommandBus {
    @NotNull
    private final CommandWaitEndpoint commandWaitEndpoint;
    @NotNull
    private final CommandBus commandBus;
    @NotNull
    private final Validator validator;
    @NotNull
    private final AggregateIdempotencyCheckerProvider idempotencyCheckerProvider;
    @NotNull
    private final WaitStrategyRegistrar waitStrategyRegistrar;

    public DefaultCommandGateway(@NotNull CommandWaitEndpoint commandWaitEndpoint, @NotNull CommandBus commandBus, @NotNull Validator validator, @NotNull AggregateIdempotencyCheckerProvider idempotencyCheckerProvider, @NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)commandWaitEndpoint, (String)"commandWaitEndpoint");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)idempotencyCheckerProvider, (String)"idempotencyCheckerProvider");
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        this.commandWaitEndpoint = commandWaitEndpoint;
        this.commandBus = commandBus;
        this.validator = validator;
        this.idempotencyCheckerProvider = idempotencyCheckerProvider;
        this.waitStrategyRegistrar = waitStrategyRegistrar;
    }

    private final <C> void validate(C commandBody) {
        if (commandBody instanceof CommandValidator) {
            ((CommandValidator)commandBody).validate();
        }
        Set constraintViolations = this.validator.validate(commandBody, new Class[0]);
        Intrinsics.checkNotNull((Object)constraintViolations);
        if (!((Collection)constraintViolations).isEmpty()) {
            throw CommandValidationException.Companion.toCommandValidationException$default(CommandValidationException.Companion, constraintViolations, commandBody, null, 2, null);
        }
    }

    private final Mono<Void> idempotencyCheck(CommandMessage<?> command) {
        Mono mono = this.idempotencyCheckerProvider.getChecker(MaterializedNamedAggregateKt.materialize(command.getAggregateId().getNamedAggregate())).check(command.getRequestId()).doOnNext(arg_0 -> DefaultCommandGateway.idempotencyCheck$lambda$1(arg_0 -> DefaultCommandGateway.idempotencyCheck$lambda$0(command, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private final <C> Mono<Void> check(CommandMessage<C> command) {
        Mono mono = this.idempotencyCheck(command).then(Mono.fromRunnable(() -> DefaultCommandGateway.check$lambda$2(this, command)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> send(@NotNull CommandMessage<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Mono mono = this.check(message).then(this.commandBus.send((Message)message));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private final <T> Mono<T> errorMapToCommandResultException(Mono<T> $this$errorMapToCommandResultException, CommandMessage<?> command) {
        Mono mono = $this$errorMapToCommandResultException.onErrorMap(arg_0 -> DefaultCommandGateway.errorMapToCommandResultException$lambda$4(arg_0 -> DefaultCommandGateway.errorMapToCommandResultException$lambda$3(command, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorMap(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWaitForSent(@NotNull CommandMessage<C> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Mono mono = this.errorMapToCommandResultException(this.send(command), command).thenReturn((Object)new CommandResult(CommandStage.SENT, command.getAggregateId().getId(), command.getContextName(), "CommandGateway", command.getAggregateId().getTenantId(), command.getRequestId(), command.getCommandId(), null, null, null, null, 1920, null));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"thenReturn(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWait(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        Mono mono = this.errorMapToCommandResultException(this.send(command, waitStrategy), command).flatMap(arg_0 -> DefaultCommandGateway.sendAndWait$lambda$5(new Function1(waitStrategy, this, command){
            final /* synthetic */ WaitStrategy $waitStrategy;
            final /* synthetic */ DefaultCommandGateway this$0;
            final /* synthetic */ CommandMessage<C> $command;
            {
                this.$waitStrategy = $waitStrategy;
                this.this$0 = $receiver;
                this.$command = $command;
            }

            public final Mono<? extends CommandResult> invoke(ClientCommandExchange<C> it) {
                return this.$waitStrategy.waitingLast().map(arg_0 -> sendAndWait.1.invoke$lambda$2(arg_0 -> sendAndWait.1.invoke$lambda$1(it, arg_0), arg_0)).doFinally(arg_0 -> sendAndWait.1.invoke$lambda$3(this.this$0, this.$command, arg_0));
            }

            private static final CommandResult invoke$lambda$1(ClientCommandExchange $it, WaitSignal waitSignal) {
                CommandResult commandResult;
                Intrinsics.checkNotNull((Object)waitSignal);
                CommandResult $this$invoke_u24lambda_u241_u24lambda_u240 = commandResult = CommandResultKt.toResult(waitSignal, (CommandMessage)$it.getMessage());
                boolean bl = false;
                if (!$this$invoke_u24lambda_u241_u24lambda_u240.getSucceeded()) {
                    throw new CommandResultException($this$invoke_u24lambda_u241_u24lambda_u240, null, 2, null);
                }
                return commandResult;
            }

            private static final CommandResult invoke$lambda$2(Function1 $tmp0, Object p0) {
                return (CommandResult)$tmp0.invoke(p0);
            }

            private static final void invoke$lambda$3(DefaultCommandGateway this$0, CommandMessage $command, SignalType it) {
                DefaultCommandGateway.access$getWaitStrategyRegistrar$p(this$0).unregister($command.getCommandId());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Mono<? extends ClientCommandExchange<C>> send(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        if (!(waitStrategy instanceof WaitingFor)) {
            boolean $i$a$-require-DefaultCommandGateway$send$42 = false;
            String $i$a$-require-DefaultCommandGateway$send$42 = "waitStrategy must be WaitingFor.";
            throw new IllegalArgumentException($i$a$-require-DefaultCommandGateway$send$42.toString());
        }
        if (!(((WaitingFor)waitStrategy).getStage() != CommandStage.SENT)) {
            boolean $i$a$-require-DefaultCommandGateway$send$52 = false;
            String $i$a$-require-DefaultCommandGateway$send$52 = "waitStrategy.stage must not be CommandStage.SENT. Use sendAndWaitForSent instead.";
            throw new IllegalArgumentException($i$a$-require-DefaultCommandGateway$send$52.toString());
        }
        if (!(!command.isVoid())) {
            boolean bl = false;
            String string = "The wait strategy for the void command must be SENT.";
            throw new IllegalArgumentException(string.toString());
        }
        Mono mono = this.check(command).then(Mono.defer(() -> DefaultCommandGateway.send$lambda$11(command, this, waitStrategy)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @Override
    @NotNull
    public TopicKind getTopicKind() {
        return this.commandBus.getTopicKind();
    }

    @Override
    public void close() {
        this.commandBus.close();
    }

    @Override
    @NotNull
    public Flux<ServerCommandExchange<?>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.commandBus.receive(namedAggregates);
    }

    private static final Unit idempotencyCheck$lambda$0(CommandMessage $command, Boolean it) {
        if (!it.booleanValue()) {
            throw new DuplicateRequestIdException($command.getAggregateId(), $command.getRequestId(), null, null, 12, null);
        }
        return Unit.INSTANCE;
    }

    private static final void idempotencyCheck$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void check$lambda$2(DefaultCommandGateway this$0, CommandMessage $command) {
        this$0.validate($command.getBody());
    }

    private static final Throwable errorMapToCommandResultException$lambda$3(CommandMessage $command, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        return new CommandResultException(CommandResultKt.toResult$default(it, $command, null, "CommandGateway", null, null, 26, null), it);
    }

    private static final Throwable errorMapToCommandResultException$lambda$4(Function1 $tmp0, Object p0) {
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final Mono sendAndWait$lambda$5(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Unit send$lambda$11$lambda$9(DefaultCommandGateway this$0, CommandMessage $command, Throwable it) {
        this$0.waitStrategyRegistrar.unregister($command.getCommandId());
        return Unit.INSTANCE;
    }

    private static final void send$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono send$lambda$11(CommandMessage $command, DefaultCommandGateway this$0, WaitStrategy $waitStrategy) {
        CommandWaitNotifierKt.injectWaitStrategy($command.getHeader(), this$0.commandWaitEndpoint.getEndpoint(), ((WaitingFor)$waitStrategy).getStage(), $waitStrategy.getContextName(), $waitStrategy.getProcessorName());
        this$0.waitStrategyRegistrar.register($command.getCommandId(), $waitStrategy);
        ClientCommandExchange commandExchange = new SimpleClientCommandExchange($command, $waitStrategy, null, 4, null);
        return this$0.commandBus.send((Message)$command).doOnError(arg_0 -> DefaultCommandGateway.send$lambda$11$lambda$10(arg_0 -> DefaultCommandGateway.send$lambda$11$lambda$9(this$0, $command, arg_0), arg_0)).thenReturn((Object)commandExchange);
    }

    public static final /* synthetic */ WaitStrategyRegistrar access$getWaitStrategyRegistrar$p(DefaultCommandGateway $this) {
        return $this.waitStrategyRegistrar;
    }
}

