/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.event.upgrader;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.annotation.SortedByOrderKt;
import me.ahoo.wow.event.upgrader.EventNamedAggregate;
import me.ahoo.wow.event.upgrader.EventUpgrader;
import me.ahoo.wow.event.upgrader.MutableDomainEventRecord;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.serialization.event.DomainEventRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/event/upgrader/EventUpgraderFactory;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "eventUpgraderFactories", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/ahoo/wow/event/upgrader/EventNamedAggregate;", "", "Lme/ahoo/wow/event/upgrader/EventUpgrader;", "register", "", "eventUpgrader", "get", "eventNamedAggregate", "upgrade", "Lme/ahoo/wow/serialization/event/DomainEventRecord;", "domainEventRecord", "wow-core"})
@SourceDebugExtension(value={"SMAP\nEventUpgraderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventUpgraderFactory.kt\nme/ahoo/wow/event/upgrader/EventUpgraderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1863#2,2:73\n1863#2,2:75\n*S KotlinDebug\n*F\n+ 1 EventUpgraderFactory.kt\nme/ahoo/wow/event/upgrader/EventUpgraderFactory\n*L\n63#1:73,2\n32#1:75,2\n*E\n"})
public final class EventUpgraderFactory {
    @NotNull
    public static final EventUpgraderFactory INSTANCE = new EventUpgraderFactory();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(EventUpgraderFactory::log$lambda$0);
    @NotNull
    private static final ConcurrentHashMap<EventNamedAggregate, List<EventUpgrader>> eventUpgraderFactories = new ConcurrentHashMap();

    private EventUpgraderFactory() {
    }

    public final void register(@NotNull EventUpgrader eventUpgrader) {
        Intrinsics.checkNotNullParameter((Object)eventUpgrader, (String)"eventUpgrader");
        log.info(() -> EventUpgraderFactory.register$lambda$3(eventUpgrader));
        eventUpgraderFactories.compute(eventUpgrader.getEventNamedAggregate(), (arg_0, arg_1) -> EventUpgraderFactory.register$lambda$5((arg_0, arg_1) -> EventUpgraderFactory.register$lambda$4(eventUpgrader, arg_0, arg_1), arg_0, arg_1));
    }

    @NotNull
    public final List<EventUpgrader> get(@NotNull EventNamedAggregate eventNamedAggregate) {
        Intrinsics.checkNotNullParameter((Object)eventNamedAggregate, (String)"eventNamedAggregate");
        List list = eventUpgraderFactories.get(eventNamedAggregate);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final DomainEventRecord upgrade(@NotNull DomainEventRecord domainEventRecord) {
        Intrinsics.checkNotNullParameter((Object)domainEventRecord, (String)"domainEventRecord");
        MaterializedNamedAggregate namedAggregate = MaterializedNamedAggregateKt.materialize(domainEventRecord.toAggregateId().getNamedAggregate());
        EventNamedAggregate eventNamedAggregate = EventNamedAggregate.Companion.toEventNamedAggregate(namedAggregate, domainEventRecord.getName());
        List<EventUpgrader> eventUpgraders = this.get(eventNamedAggregate);
        if (eventUpgraders.isEmpty()) {
            return domainEventRecord;
        }
        MutableDomainEventRecord mutableDomainEventRecord = null;
        mutableDomainEventRecord = MutableDomainEventRecord.Companion.toMutableDomainEventRecord(domainEventRecord);
        Iterable $this$forEach$iv = eventUpgraders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventUpgrader it = (EventUpgrader)element$iv;
            boolean bl = false;
            log.debug(() -> EventUpgraderFactory.upgrade$lambda$7$lambda$6(domainEventRecord, eventNamedAggregate, it));
            mutableDomainEventRecord = MutableDomainEventRecord.Companion.toMutableDomainEventRecord(it.upgrade(mutableDomainEventRecord));
        }
        return domainEventRecord;
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object lambda$2$lambda$1(EventUpgrader $it) {
        return "Load " + $it + " to register.";
    }

    private static final Object register$lambda$3(EventUpgrader $eventUpgrader) {
        return "Register " + $eventUpgrader + ".";
    }

    private static final List register$lambda$4(EventUpgrader $eventUpgrader, EventNamedAggregate eventNamedAggregate, List value) {
        List list;
        Intrinsics.checkNotNullParameter((Object)eventNamedAggregate, (String)"<unused var>");
        if (value == null) {
            Object[] objectArray = new EventUpgrader[]{$eventUpgrader};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            list = SortedByOrderKt.sortedByOrder(CollectionsKt.plus((Collection)value, (Object)$eventUpgrader));
        }
        return list;
    }

    private static final List register$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final Object upgrade$lambda$7$lambda$6(DomainEventRecord $domainEventRecord, EventNamedAggregate $eventNamedAggregate, EventUpgrader $it) {
        return "Upgrade [" + $domainEventRecord.getId() + "]@[" + $eventNamedAggregate + "] by " + $it + ".";
    }

    static {
        ServiceLoader<EventUpgrader> serviceLoader = ServiceLoader.load(EventUpgrader.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventUpgrader it = (EventUpgrader)element$iv;
            boolean bl = false;
            log.info(() -> EventUpgraderFactory.lambda$2$lambda$1(it));
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.register(it);
        }
    }
}

