/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.messaging.processor;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import me.ahoo.wow.messaging.function.FunctionAccessorMetadata;
import me.ahoo.wow.messaging.function.FunctionMetadataParser;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.messaging.processor.ProcessorMetadata;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0010\b\u0001\u0010\u0003*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00060\u0005B-\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/messaging/processor/ProcessorMetadataVisitor;", "P", "", "E", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "Lme/ahoo/wow/messaging/processor/ProcessorMetadata;", "processorType", "Ljava/lang/Class;", "functionCondition", "Lkotlin/Function1;", "Lkotlin/reflect/KFunction;", "", "<init>", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "functionRegistry", "", "Lme/ahoo/wow/messaging/function/FunctionAccessorMetadata;", "Lreactor/core/publisher/Mono;", "visitFunction", "", "function", "toMetadata", "wow-core"})
public final class ProcessorMetadataVisitor<P, E extends MessageExchange<?, ?>>
implements ClassVisitor<P, ProcessorMetadata<P, ? super E>> {
    @NotNull
    private final Class<P> processorType;
    @NotNull
    private final Function1<KFunction<?>, Boolean> functionCondition;
    @NotNull
    private final Set<FunctionAccessorMetadata<P, Mono<?>>> functionRegistry;

    public ProcessorMetadataVisitor(@NotNull Class<P> processorType, @NotNull Function1<? super KFunction<?>, Boolean> functionCondition) {
        Intrinsics.checkNotNullParameter(processorType, (String)"processorType");
        Intrinsics.checkNotNullParameter(functionCondition, (String)"functionCondition");
        this.processorType = processorType;
        this.functionCondition = functionCondition;
        this.functionRegistry = new LinkedHashSet();
    }

    @Override
    public void visitFunction(@NotNull KFunction<?> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        if (!((Boolean)this.functionCondition.invoke(function)).booleanValue()) {
            return;
        }
        FunctionAccessorMetadata handler = FunctionMetadataParser.INSTANCE.toMonoFunctionMetadata(function);
        this.functionRegistry.add(handler);
    }

    @Override
    @NotNull
    public ProcessorMetadata<P, E> toMetadata() {
        NamedBoundedContext namedBoundedContext = MetadataSearcherKt.requiredNamedBoundedContext(this.processorType);
        String string = this.processorType.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return new ProcessorMetadata(namedBoundedContext, string, this.processorType, this.functionRegistry);
    }
}

