/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.infra.idempotency;

import com.google.common.hash.BloomFilter;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \f*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/infra/idempotency/BloomFilterIdempotencyChecker;", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "ttl", "Ljava/time/Duration;", "bloomFilterSupplier", "Lkotlin/Function0;", "Lcom/google/common/hash/BloomFilter;", "", "<init>", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)V", "bloomFilterCache", "Lreactor/core/publisher/Mono;", "kotlin.jvm.PlatformType", "check", "", "element", "Companion", "wow-core"})
public final class BloomFilterIdempotencyChecker
implements IdempotencyChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration ttl;
    @NotNull
    private final Function0<BloomFilter<String>> bloomFilterSupplier;
    @NotNull
    private final Mono<BloomFilter<String>> bloomFilterCache;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(BloomFilterIdempotencyChecker::log$lambda$0);

    public BloomFilterIdempotencyChecker(@NotNull Duration ttl, @NotNull Function0<BloomFilter<String>> bloomFilterSupplier) {
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        Intrinsics.checkNotNullParameter(bloomFilterSupplier, (String)"bloomFilterSupplier");
        this.ttl = ttl;
        this.bloomFilterSupplier = bloomFilterSupplier;
        Mono mono = Mono.fromCallable(() -> BloomFilterIdempotencyChecker.bloomFilterCache$lambda$0(this)).cache(this.ttl);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"cache(...)");
        this.bloomFilterCache = mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> check(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Mono mono = this.bloomFilterCache.map(arg_0 -> BloomFilterIdempotencyChecker.check$lambda$1(arg_0 -> BloomFilterIdempotencyChecker.check$lambda$0(element, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final BloomFilter bloomFilterCache$lambda$0(BloomFilterIdempotencyChecker this$0) {
        log.info(BloomFilterIdempotencyChecker::bloomFilterCache$lambda$0$0);
        return (BloomFilter)this$0.bloomFilterSupplier.invoke();
    }

    private static final Object bloomFilterCache$lambda$0$0() {
        return "Create new BloomFilter.";
    }

    private static final Boolean check$lambda$0(String $element, BloomFilter it) {
        boolean contain = it.mightContain((Object)$element);
        if (!contain) {
            it.put((Object)$element);
        }
        return !contain;
    }

    private static final Boolean check$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/infra/idempotency/BloomFilterIdempotencyChecker$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

