/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command;

import jakarta.validation.Validator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.command.validation.CommandValidator;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.messaging.TopicKind;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.ClientCommandExchange;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandGatewayKt;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.CommandResultException;
import me.ahoo.wow.command.CommandResultKt;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.SimpleClientCommandExchange;
import me.ahoo.wow.command.validation.ValidatorsKt;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.CommandWaitNotifier;
import me.ahoo.wow.command.wait.CommandWaitNotifierKt;
import me.ahoo.wow.command.wait.ExtractedWaitStrategy;
import me.ahoo.wow.command.wait.ExtractedWaitStrategyKt;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.infra.idempotency.AggregateIdempotencyCheckerProvider;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.reactor.MonosKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001aH\u0002J\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J.\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J.\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u0017\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J6\u0010\u001c\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00120$0\u0017\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\t\u0010%\u001a\u00020\u0011H\u0096\u0001J!\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lme/ahoo/wow/command/DefaultCommandGateway;", "Lme/ahoo/wow/command/CommandGateway;", "Lme/ahoo/wow/command/CommandBus;", "commandWaitEndpoint", "Lme/ahoo/wow/command/wait/CommandWaitEndpoint;", "commandBus", "validator", "Ljakarta/validation/Validator;", "idempotencyCheckerProvider", "Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "commandWaitNotifier", "Lme/ahoo/wow/command/wait/CommandWaitNotifier;", "<init>", "(Lme/ahoo/wow/command/wait/CommandWaitEndpoint;Lme/ahoo/wow/command/CommandBus;Ljakarta/validation/Validator;Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;Lme/ahoo/wow/command/wait/CommandWaitNotifier;)V", "validate", "", "C", "", "commandBody", "(Ljava/lang/Object;)V", "idempotencyCheck", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "command", "Lme/ahoo/wow/api/command/CommandMessage;", "check", "send", "message", "sendAndWaitStream", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/CommandResult;", "waitStrategy", "Lme/ahoo/wow/command/wait/WaitStrategy;", "sendAndWait", "Lme/ahoo/wow/command/ClientCommandExchange;", "close", "receive", "Lme/ahoo/wow/command/ServerCommandExchange;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "topicKind", "Lme/ahoo/wow/api/messaging/TopicKind;", "getTopicKind", "()Lme/ahoo/wow/api/messaging/TopicKind;", "wow-core"})
public final class DefaultCommandGateway
implements CommandGateway,
CommandBus {
    @NotNull
    private final CommandWaitEndpoint commandWaitEndpoint;
    @NotNull
    private final CommandBus commandBus;
    @NotNull
    private final Validator validator;
    @NotNull
    private final AggregateIdempotencyCheckerProvider idempotencyCheckerProvider;
    @NotNull
    private final WaitStrategyRegistrar waitStrategyRegistrar;
    @NotNull
    private final CommandWaitNotifier commandWaitNotifier;

    public DefaultCommandGateway(@NotNull CommandWaitEndpoint commandWaitEndpoint, @NotNull CommandBus commandBus, @NotNull Validator validator, @NotNull AggregateIdempotencyCheckerProvider idempotencyCheckerProvider, @NotNull WaitStrategyRegistrar waitStrategyRegistrar, @NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitEndpoint, (String)"commandWaitEndpoint");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)idempotencyCheckerProvider, (String)"idempotencyCheckerProvider");
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        this.commandWaitEndpoint = commandWaitEndpoint;
        this.commandBus = commandBus;
        this.validator = validator;
        this.idempotencyCheckerProvider = idempotencyCheckerProvider;
        this.waitStrategyRegistrar = waitStrategyRegistrar;
        this.commandWaitNotifier = commandWaitNotifier;
    }

    private final <C> void validate(C commandBody) {
        if (commandBody instanceof CommandValidator) {
            ((CommandValidator)commandBody).validate();
        }
        ValidatorsKt.validateCommand(this.validator, commandBody);
    }

    private final Mono<Void> idempotencyCheck(CommandMessage<?> command) {
        Mono mono = this.idempotencyCheckerProvider.getChecker(MaterializedNamedAggregateKt.materialize(command.getAggregateId().getNamedAggregate())).check(command.getRequestId()).doOnNext(arg_0 -> DefaultCommandGateway.idempotencyCheck$lambda$1(arg_0 -> DefaultCommandGateway.idempotencyCheck$lambda$0(command, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private final <C> Mono<Void> check(CommandMessage<C> command) {
        return MonosKt.thenRunnable(this.idempotencyCheck(command), (Function0<Unit>)((Function0)() -> DefaultCommandGateway.check$lambda$0(this, command)));
    }

    @Override
    @NotNull
    public Mono<Void> send(@NotNull CommandMessage<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Mono mono = this.check(message).then(this.commandBus.send((Message)message)).doOnSuccess(arg_0 -> DefaultCommandGateway.send$lambda$1(arg_0 -> DefaultCommandGateway.send$lambda$0(message, this, arg_0), arg_0)).doOnError(arg_0 -> DefaultCommandGateway.send$lambda$3(arg_0 -> DefaultCommandGateway.send$lambda$2(message, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Flux<CommandResult> sendAndWaitStream(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        Flux flux = this.send(command, waitStrategy).flatMapMany(arg_0 -> DefaultCommandGateway.sendAndWaitStream$lambda$1(arg_0 -> DefaultCommandGateway.sendAndWaitStream$lambda$0(waitStrategy, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapMany(...)");
        return flux;
    }

    @Override
    @NotNull
    public <C> Mono<CommandResult> sendAndWait(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        Mono mono = this.send(command, waitStrategy).flatMap(arg_0 -> DefaultCommandGateway.sendAndWait$lambda$1(arg_0 -> DefaultCommandGateway.sendAndWait$lambda$0(waitStrategy, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @Override
    @NotNull
    public <C> Mono<? extends ClientCommandExchange<C>> send(@NotNull CommandMessage<C> command, @NotNull WaitStrategy waitStrategy) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)waitStrategy, (String)"waitStrategy");
        if (command.isVoid() && !waitStrategy.getSupportVoidCommand()) {
            boolean bl = false;
            String string = "The wait strategy[" + waitStrategy.getClass().getSimpleName() + "] for the void command must support void command.";
            throw new IllegalArgumentException(string.toString());
        }
        ClientCommandExchange commandExchange = new SimpleClientCommandExchange(command, waitStrategy, null, 4, null);
        Mono mono = MonosKt.thenDefer(this.check(command), () -> DefaultCommandGateway.send$lambda$5(waitStrategy, this, command)).doOnSuccess(arg_0 -> DefaultCommandGateway.send$lambda$7(arg_0 -> DefaultCommandGateway.send$lambda$6(command, waitStrategy, arg_0), arg_0)).doOnError(arg_0 -> DefaultCommandGateway.send$lambda$9(arg_0 -> DefaultCommandGateway.send$lambda$8(command, waitStrategy, arg_0), arg_0)).onErrorMap(arg_0 -> DefaultCommandGateway.send$lambda$11(arg_0 -> DefaultCommandGateway.send$lambda$10(waitStrategy, command, arg_0), arg_0)).thenReturn((Object)commandExchange);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"thenReturn(...)");
        return mono;
    }

    @Override
    @NotNull
    public TopicKind getTopicKind() {
        return this.commandBus.getTopicKind();
    }

    @Override
    public void close() {
        this.commandBus.close();
    }

    @Override
    @NotNull
    public Flux<ServerCommandExchange<?>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        return this.commandBus.receive(namedAggregates);
    }

    private static final Unit idempotencyCheck$lambda$0(CommandMessage $command, Boolean it) {
        if (!it.booleanValue()) {
            throw new DuplicateRequestIdException($command.getAggregateId(), $command.getRequestId(), null, null, 12, null);
        }
        return Unit.INSTANCE;
    }

    private static final void idempotencyCheck$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit check$lambda$0(DefaultCommandGateway this$0, CommandMessage $command) {
        this$0.validate($command.getBody());
        return Unit.INSTANCE;
    }

    private static final Unit send$lambda$0(CommandMessage $message, DefaultCommandGateway this$0, Void it) {
        ExtractedWaitStrategy extractedWaitStrategy = ExtractedWaitStrategyKt.extractWaitStrategy($message.getHeader());
        if (extractedWaitStrategy == null) {
            return Unit.INSTANCE;
        }
        ExtractedWaitStrategy waitStrategy = extractedWaitStrategy;
        WaitSignal waitSignal = CommandGatewayKt.commandSentSignal$default($message, waitStrategy.getWaitCommandId(), null, 2, null);
        CommandWaitNotifierKt.notifyAndForget(this$0.commandWaitNotifier, waitStrategy, waitSignal);
        return Unit.INSTANCE;
    }

    private static final void send$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit send$lambda$2(CommandMessage $message, DefaultCommandGateway this$0, Throwable it) {
        ExtractedWaitStrategy extractedWaitStrategy = ExtractedWaitStrategyKt.extractWaitStrategy($message.getHeader());
        if (extractedWaitStrategy == null) {
            return Unit.INSTANCE;
        }
        ExtractedWaitStrategy waitStrategy = extractedWaitStrategy;
        WaitSignal waitSignal = CommandGatewayKt.commandSentSignal($message, waitStrategy.getWaitCommandId(), it);
        CommandWaitNotifierKt.notifyAndForget(this$0.commandWaitNotifier, waitStrategy, waitSignal);
        return Unit.INSTANCE;
    }

    private static final void send$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Publisher sendAndWaitStream$lambda$0(WaitStrategy $waitStrategy, ClientCommandExchange it) {
        return (Publisher)$waitStrategy.waiting().map(arg_0 -> DefaultCommandGateway.sendAndWaitStream$lambda$0$1(arg_0 -> DefaultCommandGateway.sendAndWaitStream$lambda$0$0(it, arg_0), arg_0));
    }

    private static final CommandResult sendAndWaitStream$lambda$0$0(ClientCommandExchange $it, WaitSignal waitSignal) {
        Intrinsics.checkNotNull((Object)waitSignal);
        return CommandResultKt.toResult(waitSignal, (CommandMessage)$it.getMessage());
    }

    private static final CommandResult sendAndWaitStream$lambda$0$1(Function1 $tmp0, Object p0) {
        return (CommandResult)$tmp0.invoke(p0);
    }

    private static final Publisher sendAndWaitStream$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono sendAndWait$lambda$0(WaitStrategy $waitStrategy, ClientCommandExchange it) {
        return $waitStrategy.waitingLast().map(arg_0 -> DefaultCommandGateway.sendAndWait$lambda$0$1(arg_0 -> DefaultCommandGateway.sendAndWait$lambda$0$0(it, arg_0), arg_0));
    }

    private static final CommandResult sendAndWait$lambda$0$0(ClientCommandExchange $it, WaitSignal waitSignal) {
        CommandResult commandResult;
        Intrinsics.checkNotNull((Object)waitSignal);
        CommandResult $this$sendAndWait_u24lambda_u240_u240_u240 = commandResult = CommandResultKt.toResult(waitSignal, (CommandMessage)$it.getMessage());
        boolean bl = false;
        if (!$this$sendAndWait_u24lambda_u240_u240_u240.getSucceeded()) {
            throw new CommandResultException($this$sendAndWait_u24lambda_u240_u240_u240, null, 2, null);
        }
        return commandResult;
    }

    private static final CommandResult sendAndWait$lambda$0$1(Function1 $tmp0, Object p0) {
        return (CommandResult)$tmp0.invoke(p0);
    }

    private static final Mono sendAndWait$lambda$1(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono send$lambda$5(WaitStrategy $waitStrategy, DefaultCommandGateway this$0, CommandMessage $command) {
        $waitStrategy.propagate(this$0.commandWaitEndpoint.getEndpoint(), $command.getHeader());
        Mono mono = this$0.commandBus.send((Message)$command).doOnSubscribe(arg_0 -> DefaultCommandGateway.send$lambda$5$1(arg_0 -> DefaultCommandGateway.send$lambda$5$0(this$0, $waitStrategy, arg_0), arg_0)).doOnError(arg_0 -> DefaultCommandGateway.send$lambda$5$3(arg_0 -> DefaultCommandGateway.send$lambda$5$2(this$0, $waitStrategy, arg_0), arg_0)).doOnCancel(() -> DefaultCommandGateway.send$lambda$5$4(this$0, $waitStrategy));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnCancel(...)");
        return mono;
    }

    private static final Unit send$lambda$5$0(DefaultCommandGateway this$0, WaitStrategy $waitStrategy, Subscription it) {
        this$0.waitStrategyRegistrar.register($waitStrategy);
        $waitStrategy.onFinally(arg_0 -> DefaultCommandGateway.send$lambda$5$0$0(this$0, $waitStrategy, arg_0));
        return Unit.INSTANCE;
    }

    private static final void send$lambda$5$0$0(DefaultCommandGateway this$0, WaitStrategy $waitStrategy, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.waitStrategyRegistrar.unregister($waitStrategy.getWaitCommandId());
    }

    private static final void send$lambda$5$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit send$lambda$5$2(DefaultCommandGateway this$0, WaitStrategy $waitStrategy, Throwable it) {
        this$0.waitStrategyRegistrar.unregister($waitStrategy.getWaitCommandId());
        return Unit.INSTANCE;
    }

    private static final void send$lambda$5$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void send$lambda$5$4(DefaultCommandGateway this$0, WaitStrategy $waitStrategy) {
        this$0.waitStrategyRegistrar.unregister($waitStrategy.getWaitCommandId());
    }

    private static final Unit send$lambda$6(CommandMessage $command, WaitStrategy $waitStrategy, Void it) {
        WaitSignal waitSignal = CommandGatewayKt.commandSentSignal$default($command, $waitStrategy.getWaitCommandId(), null, 2, null);
        $waitStrategy.next(waitSignal);
        return Unit.INSTANCE;
    }

    private static final void send$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit send$lambda$8(CommandMessage $command, WaitStrategy $waitStrategy, Throwable it) {
        WaitSignal waitSignal = CommandGatewayKt.commandSentSignal($command, $waitStrategy.getWaitCommandId(), it);
        $waitStrategy.next(waitSignal);
        return Unit.INSTANCE;
    }

    private static final void send$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Throwable send$lambda$10(WaitStrategy $waitStrategy, CommandMessage $command, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        return new CommandResultException(CommandResultKt.toResult$default(it, $waitStrategy.getWaitCommandId(), $command, null, null, null, null, 0L, 124, null), it);
    }

    private static final Throwable send$lambda$11(Function1 $tmp0, Object p0) {
        return (Throwable)$tmp0.invoke(p0);
    }
}

