/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.time.Duration;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import org.jetbrains.annotations.NotNull;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0006\b&\u0018\u0000 .2\u00020\u0001:\u0002./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0004J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0004J\u0016\u0010\"\u001a\u00020\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0$H\u0004J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0006H&J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0006H\u0014J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J\u0016\u0010,\u001a\u00020\u001a2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR&\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor;", "Lme/ahoo/wow/command/wait/WaitStrategy;", "<init>", "()V", "waitSignalSink", "Lreactor/core/publisher/Sinks$Many;", "Lme/ahoo/wow/command/wait/WaitSignal;", "getWaitSignalSink", "()Lreactor/core/publisher/Sinks$Many;", "cancelled", "", "getCancelled", "()Z", "terminated", "getTerminated", "supportVoidCommand", "getSupportVoidCommand", "onFinallyHook", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/function/Consumer;", "Lreactor/core/publisher/SignalType;", "getOnFinallyHook", "()Ljava/util/concurrent/atomic/AtomicReference;", "setOnFinallyHook", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "safeDoFinally", "", "signalType", "waiting", "Lreactor/core/publisher/Flux;", "waitingLast", "Lreactor/core/publisher/Mono;", "busyLooping", "Lreactor/core/publisher/Sinks$EmitFailureHandler;", "tryEmit", "emit", "Lkotlin/Function0;", "isPreviousSignal", "signal", "nextSignal", "error", "throwable", "", "complete", "onFinally", "doFinally", "Companion", "EmptyOnFinally", "wow-core"})
@SourceDebugExtension(value={"SMAP\nWaitingFor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitingFor.kt\nme/ahoo/wow/command/wait/WaitingFor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1011#2,2:131\n1869#2,2:133\n*S KotlinDebug\n*F\n+ 1 WaitingFor.kt\nme/ahoo/wow/command/wait/WaitingFor\n*L\n64#1:131,2\n66#1:133,2\n*E\n"})
public abstract class WaitingFor
implements WaitStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sinks.Many<WaitSignal> waitSignalSink;
    private final boolean supportVoidCommand;
    @NotNull
    private AtomicReference<Consumer<SignalType>> onFinallyHook;
    @NotNull
    private static final Duration DEFAULT_BUSY_LOOPING_DURATION;
    @NotNull
    private static final KLogger log;

    public WaitingFor() {
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.waitSignalSink = many;
        this.onFinallyHook = new AtomicReference<EmptyOnFinally>(EmptyOnFinally.INSTANCE);
    }

    @NotNull
    protected final Sinks.Many<WaitSignal> getWaitSignalSink() {
        return this.waitSignalSink;
    }

    @Override
    public boolean getCancelled() {
        Object object = Scannable.from(this.waitSignalSink).scanOrDefault(Scannable.Attr.CANCELLED, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scanOrDefault(...)");
        return (Boolean)object;
    }

    @Override
    public boolean getTerminated() {
        Object object = Scannable.from(this.waitSignalSink).scanOrDefault(Scannable.Attr.TERMINATED, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scanOrDefault(...)");
        return (Boolean)object;
    }

    @Override
    public boolean getSupportVoidCommand() {
        return this.supportVoidCommand;
    }

    @NotNull
    protected final AtomicReference<Consumer<SignalType>> getOnFinallyHook() {
        return this.onFinallyHook;
    }

    protected final void setOnFinallyHook(@NotNull AtomicReference<Consumer<SignalType>> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.onFinallyHook = atomicReference;
    }

    protected final void safeDoFinally(@NotNull SignalType signalType) {
        Intrinsics.checkNotNullParameter((Object)signalType, (String)"signalType");
        Consumer<SignalType> currentHook = this.onFinallyHook.get();
        try {
            currentHook.accept(signalType);
        }
        catch (Throwable error) {
            log.error(error, WaitingFor::safeDoFinally$lambda$0);
        }
    }

    @Override
    @NotNull
    public Flux<WaitSignal> waiting() {
        Flux flux = this.waitSignalSink.asFlux().doFinally(this::safeDoFinally);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doFinally(...)");
        return flux;
    }

    @Override
    @NotNull
    public Mono<WaitSignal> waitingLast() {
        Mono mono = this.waiting().collectList().mapNotNull(arg_0 -> WaitingFor.waitingLast$lambda$1(WaitingFor::waitingLast$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"mapNotNull(...)");
        return mono;
    }

    @NotNull
    protected final Sinks.EmitFailureHandler busyLooping() {
        Sinks.EmitFailureHandler emitFailureHandler = Sinks.EmitFailureHandler.busyLooping((Duration)DEFAULT_BUSY_LOOPING_DURATION);
        Intrinsics.checkNotNullExpressionValue((Object)emitFailureHandler, (String)"busyLooping(...)");
        return emitFailureHandler;
    }

    protected final boolean tryEmit(@NotNull Function0<Unit> emit) {
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.getCompleted()) {
            log.warn(WaitingFor::tryEmit$lambda$0);
            return false;
        }
        emit.invoke();
        return true;
    }

    public abstract boolean isPreviousSignal(@NotNull WaitSignal var1);

    protected void nextSignal(@NotNull WaitSignal signal) {
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        this.tryEmit((Function0<Unit>)((Function0)() -> WaitingFor.nextSignal$lambda$0(this, signal)));
    }

    @Override
    public void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.tryEmit((Function0<Unit>)((Function0)() -> WaitingFor.error$lambda$0(this, throwable)));
    }

    @Override
    public void complete() {
        this.tryEmit((Function0<Unit>)((Function0)() -> WaitingFor.complete$lambda$0(this)));
    }

    @Override
    public void onFinally(@NotNull Consumer<SignalType> doFinally) {
        Intrinsics.checkNotNullParameter(doFinally, (String)"doFinally");
        if (!this.onFinallyHook.compareAndSet(EmptyOnFinally.INSTANCE, doFinally)) {
            boolean bl = false;
            String string = "Finally hook already set [" + this.onFinallyHook.get() + "]";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final Object safeDoFinally$lambda$0() {
        return "Finally hook execution failed";
    }

    private static final WaitSignal waitingLast$lambda$0(List signals) {
        if (signals.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)signals);
        List $this$sortBy$iv = signals;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    WaitSignal it = (WaitSignal)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getSignalTime());
                    it = (WaitSignal)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSignalTime()));
                }
            });
        }
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = signals;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WaitSignal signal = (WaitSignal)element$iv;
            boolean bl = false;
            result.putAll(signal.getResult());
        }
        return ((WaitSignal)CollectionsKt.last((List)signals)).copyResult(result);
    }

    private static final WaitSignal waitingLast$lambda$1(Function1 $tmp0, Object p0) {
        return (WaitSignal)$tmp0.invoke(p0);
    }

    private static final Object tryEmit$lambda$0() {
        return "WaitingFor is terminated or cancelled, ignore emit.";
    }

    private static final Unit nextSignal$lambda$0(WaitingFor this$0, WaitSignal $signal) {
        this$0.waitSignalSink.emitNext((Object)$signal, this$0.busyLooping());
        if (!$signal.getSucceeded() && this$0.isPreviousSignal($signal)) {
            this$0.complete();
        }
        return Unit.INSTANCE;
    }

    private static final Unit error$lambda$0(WaitingFor this$0, Throwable $throwable) {
        this$0.waitSignalSink.emitError($throwable, this$0.busyLooping());
        return Unit.INSTANCE;
    }

    private static final Unit complete$lambda$0(WaitingFor this$0) {
        this$0.waitSignalSink.emitComplete(this$0.busyLooping());
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    static {
        Duration duration = Duration.ofMillis(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        DEFAULT_BUSY_LOOPING_DURATION = duration;
        log = KotlinLogging.INSTANCE.logger(WaitingFor::log$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor$Companion;", "", "<init>", "()V", "DEFAULT_BUSY_LOOPING_DURATION", "Ljava/time/Duration;", "getDEFAULT_BUSY_LOOPING_DURATION", "()Ljava/time/Duration;", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDEFAULT_BUSY_LOOPING_DURATION() {
            return DEFAULT_BUSY_LOOPING_DURATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor$EmptyOnFinally;", "Ljava/util/function/Consumer;", "Lreactor/core/publisher/SignalType;", "<init>", "()V", "accept", "", "t", "wow-core"})
    public static final class EmptyOnFinally
    implements Consumer<SignalType> {
        @NotNull
        public static final EmptyOnFinally INSTANCE = new EmptyOnFinally();

        private EmptyOnFinally() {
        }

        @Override
        public void accept(@NotNull SignalType t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        }
    }
}

