/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.ahoo.wow.domains.order.query

import me.ahoo.wow.domains.order.event.OrderCreated
import me.ahoo.wow.domains.order.event.OrderPaid
import me.ahoo.wow.event.annotation.OnEvent

/**
 * Order Projector .
 * <pre>
 * 订单聚合投影仪职责：
 * 1. 订阅领域事件，构建面向查询高度优化的索引
</pre> *
 *
 * @author ahoo wang
 */
class OrderProjector(private val orderViewRepository: OrderViewRepository) {
    /**
     * 可以通过重置消费偏移量来重新订阅事件，从而满足新当查询索引需要.
     */
    @Suppress("EmptyFunctionBlock")
    private fun resetEventStreamOffset() {}

    @OnEvent
    protected fun onEvent(orderCreated: OrderCreated?) {
        // OrderViewRepository.add(orderCrated);
    }

    @OnEvent
    protected fun onEvent(orderPaid: OrderPaid?) {
        // OrderViewRepository.set(orderPaid);
    } //    @OnEvent
    //    protected void onEvent(PurchaseItemShiped purchaseItemShiped) {
    //        // OrderViewRepository.set(purchaseItemShiped);
    //    }
}
