/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.domains.order.saga

import me.ahoo.wow.domains.order.model.PayOrder
import me.ahoo.wow.domains.payment.event.PaymentPaid
import me.ahoo.wow.event.DomainEvent
import me.ahoo.wow.spring.stereotype.StatelessSaga

@StatelessSaga
class PayOrderSaga {
    /**
     * 1. 订阅支付服务事件 `PaymentPaid`
     * 2. 转换成订单服务命令 `PayOrder`
     * 3. 发送 `PayOrder` 命令
     *
     *  使用 事件ID 作为命令ID：幂等性！！
     */
    fun onEvent(paymentPaid: DomainEvent<PaymentPaid>): PayOrder {
        return PayOrder(
            orderId = paymentPaid.body.bizId,
            paymentId = paymentPaid.body.paymentId,
            amount = paymentPaid.body.amount
        )
    }
}
