/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.domains.order.model;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.domains.order.infra.InventoryService;
import me.ahoo.wow.domains.order.infra.PricingService;
import me.ahoo.wow.domains.order.model.OrderItem;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/domains/order/model/CreateOrderSpecification;", "", "inventoryService", "Lme/ahoo/wow/domains/order/infra/InventoryService;", "pricingService", "Lme/ahoo/wow/domains/order/infra/PricingService;", "(Lme/ahoo/wow/domains/order/infra/InventoryService;Lme/ahoo/wow/domains/order/infra/PricingService;)V", "checkInventory", "Lreactor/core/publisher/Mono;", "", "orderItem", "Lme/ahoo/wow/domains/order/model/OrderItem;", "checkPrice", "Ljava/math/BigDecimal;", "require", "InventoryShortageException", "PriceInconsistencyException", "wow-domains"})
public final class CreateOrderSpecification {
    @NotNull
    private final InventoryService inventoryService;
    @NotNull
    private final PricingService pricingService;

    public CreateOrderSpecification(@NotNull InventoryService inventoryService, @NotNull PricingService pricingService) {
        Intrinsics.checkNotNullParameter((Object)inventoryService, (String)"inventoryService");
        Intrinsics.checkNotNullParameter((Object)pricingService, (String)"pricingService");
        this.inventoryService = inventoryService;
        this.pricingService = pricingService;
    }

    @NotNull
    public final Mono<OrderItem> require(@NotNull OrderItem orderItem) {
        Intrinsics.checkNotNullParameter((Object)orderItem, (String)"orderItem");
        Mono mono = Mono.zip(this.checkPrice(orderItem), this.checkInventory(orderItem)).thenReturn((Object)orderItem);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"zip(checkPrice(orderItem\u2026   .thenReturn(orderItem)");
        return mono;
    }

    private final Mono<Integer> checkInventory(OrderItem orderItem) {
        Mono mono = this.inventoryService.getInventory(orderItem.getProductId()).doOnNext(arg_0 -> CreateOrderSpecification.checkInventory$lambda-0(orderItem, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"inventoryService.getInve\u2026          }\n            }");
        return mono;
    }

    private final Mono<BigDecimal> checkPrice(OrderItem orderItem) {
        Mono mono = this.pricingService.getProductPrice(orderItem.getProductId()).doOnNext(arg_0 -> CreateOrderSpecification.checkPrice$lambda-1(orderItem, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"pricingService.getProduc\u2026          }\n            }");
        return mono;
    }

    private static final void checkInventory$lambda-0(OrderItem $orderItem, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$orderItem, (String)"$orderItem");
        int n = $orderItem.getQuantity();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (n > it) {
            throw new InventoryShortageException($orderItem, it);
        }
    }

    private static final void checkPrice$lambda-1(OrderItem $orderItem, BigDecimal unitPrice) {
        Intrinsics.checkNotNullParameter((Object)$orderItem, (String)"$orderItem");
        if (!Intrinsics.areEqual((Object)$orderItem.getPrice(), (Object)unitPrice)) {
            Intrinsics.checkNotNullExpressionValue((Object)unitPrice, (String)"unitPrice");
            throw new PriceInconsistencyException($orderItem, unitPrice);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/domains/order/model/CreateOrderSpecification$InventoryShortageException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "orderItem", "Lme/ahoo/wow/domains/order/model/OrderItem;", "inventory", "", "(Lme/ahoo/wow/domains/order/model/OrderItem;I)V", "getInventory", "()I", "getOrderItem", "()Lme/ahoo/wow/domains/order/model/OrderItem;", "wow-domains"})
    public static final class InventoryShortageException
    extends RuntimeException {
        @NotNull
        private final OrderItem orderItem;
        private final int inventory;

        public InventoryShortageException(@NotNull OrderItem orderItem, int inventory) {
            Intrinsics.checkNotNullParameter((Object)orderItem, (String)"orderItem");
            super("item[" + orderItem + "] is greater than the inventory quantity[" + inventory + "].");
            this.orderItem = orderItem;
            this.inventory = inventory;
        }

        @NotNull
        public final OrderItem getOrderItem() {
            return this.orderItem;
        }

        public final int getInventory() {
            return this.inventory;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/domains/order/model/CreateOrderSpecification$PriceInconsistencyException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "orderItem", "Lme/ahoo/wow/domains/order/model/OrderItem;", "price", "Ljava/math/BigDecimal;", "(Lme/ahoo/wow/domains/order/model/OrderItem;Ljava/math/BigDecimal;)V", "getOrderItem", "()Lme/ahoo/wow/domains/order/model/OrderItem;", "getPrice", "()Ljava/math/BigDecimal;", "wow-domains"})
    public static final class PriceInconsistencyException
    extends RuntimeException {
        @NotNull
        private final OrderItem orderItem;
        @NotNull
        private final BigDecimal price;

        public PriceInconsistencyException(@NotNull OrderItem orderItem, @NotNull BigDecimal price) {
            Intrinsics.checkNotNullParameter((Object)orderItem, (String)"orderItem");
            Intrinsics.checkNotNullParameter((Object)price, (String)"price");
            super("item[" + orderItem + "]has expired, latest price[" + price + "].");
            this.orderItem = orderItem;
            this.price = price;
        }

        @NotNull
        public final OrderItem getOrderItem() {
            return this.orderItem;
        }

        @NotNull
        public final BigDecimal getPrice() {
            return this.price;
        }
    }
}

