/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.domains.order.model;

import java.math.BigDecimal;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.domains.order.command.ChangeAddress;
import me.ahoo.wow.domains.order.command.CreateOrder;
import me.ahoo.wow.domains.order.command.ReceiptOrder;
import me.ahoo.wow.domains.order.command.ShipOrder;
import me.ahoo.wow.domains.order.event.AddressChanged;
import me.ahoo.wow.domains.order.event.OrderCreated;
import me.ahoo.wow.domains.order.event.OrderOverPaid;
import me.ahoo.wow.domains.order.event.OrderPaid;
import me.ahoo.wow.domains.order.event.OrderPayDuplicated;
import me.ahoo.wow.domains.order.event.OrderReceived;
import me.ahoo.wow.domains.order.event.OrderShipped;
import me.ahoo.wow.domains.order.model.CreateOrderSpecification;
import me.ahoo.wow.domains.order.model.OrderState;
import me.ahoo.wow.domains.order.model.OrderStatus;
import me.ahoo.wow.domains.order.model.PayOrder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0005\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/ahoo/wow/domains/order/model/Order;", "", "state", "Lme/ahoo/wow/domains/order/model/OrderState;", "(Lme/ahoo/wow/domains/order/model/OrderState;)V", "onCommand", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/domains/order/event/OrderCreated;", "command", "Lme/ahoo/wow/command/CommandMessage;", "Lme/ahoo/wow/domains/order/command/CreateOrder;", "specification", "Lme/ahoo/wow/domains/order/model/CreateOrderSpecification;", "Lme/ahoo/wow/domains/order/event/AddressChanged;", "changeAddress", "Lme/ahoo/wow/domains/order/command/ChangeAddress;", "Lme/ahoo/wow/domains/order/event/OrderReceived;", "receiptOrder", "Lme/ahoo/wow/domains/order/command/ReceiptOrder;", "Lme/ahoo/wow/domains/order/event/OrderShipped;", "shipOrder", "Lme/ahoo/wow/domains/order/command/ShipOrder;", "", "payOrder", "Lme/ahoo/wow/domains/order/model/PayOrder;", "Companion", "wow-domains"})
public final class Order {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OrderState state;
    private static final Logger log = LoggerFactory.getLogger(Order.class);

    public Order(@NotNull OrderState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @NotNull
    public final Mono<OrderCreated> onCommand(@NotNull CommandMessage<CreateOrder> command, @NotNull CreateOrderSpecification specification) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        CreateOrder createOrder = (CreateOrder)command.getBody();
        if (!(!((Collection)createOrder.getItems()).isEmpty())) {
            boolean bl = false;
            String string = "items can not be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        Mono mono = Flux.fromIterable((Iterable)createOrder.getItems()).flatMap(specification::require).then(Mono.just((Object)new OrderCreated(command.getAggregateId().getId(), createOrder.getCustomerId(), createOrder.getItems(), createOrder.getAddress())));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromIterable(createOrder\u2026          )\n            )");
        return mono;
    }

    @NotNull
    public final AddressChanged onCommand(@NotNull ChangeAddress changeAddress) {
        Intrinsics.checkNotNullParameter((Object)changeAddress, (String)"changeAddress");
        if (!(OrderStatus.CREATED == this.state.getStatus())) {
            boolean bl = false;
            String string = "The current order[" + this.state.getId() + "] status[" + (Object)((Object)this.state.getStatus()) + "] cannot modify the address";
            throw new IllegalStateException(string.toString());
        }
        return new AddressChanged(changeAddress.getOrderId(), changeAddress.getShippingAddress());
    }

    @NotNull
    public final OrderShipped onCommand(@NotNull ShipOrder shipOrder) {
        Intrinsics.checkNotNullParameter((Object)shipOrder, (String)"shipOrder");
        if (!(OrderStatus.PAID == this.state.getStatus())) {
            boolean bl = false;
            String string = "The current order[" + this.state.getId() + "] status[" + (Object)((Object)this.state.getStatus()) + "] cannot ship order.";
            throw new IllegalStateException(string.toString());
        }
        return new OrderShipped(shipOrder.getOrderId());
    }

    @NotNull
    public final OrderReceived onCommand(@NotNull ReceiptOrder receiptOrder) {
        Intrinsics.checkNotNullParameter((Object)receiptOrder, (String)"receiptOrder");
        if (!(OrderStatus.RECEIVED == this.state.getStatus())) {
            boolean bl = false;
            String string = "The current order[" + this.state.getId() + "] status[" + (Object)((Object)this.state.getStatus()) + "] cannot receipt order.";
            throw new IllegalStateException(string.toString());
        }
        return new OrderReceived(receiptOrder.getOrderId());
    }

    @NotNull
    public final Iterable<?> onCommand(@NotNull PayOrder payOrder) {
        Intrinsics.checkNotNullParameter((Object)payOrder, (String)"payOrder");
        if (OrderStatus.CREATED != this.state.getStatus()) {
            if (log.isWarnEnabled()) {
                log.warn("The current order[{}] status[{}] cannot pay order.", (Object)this.state.getId(), (Object)this.state.getStatus());
            }
            return CollectionsKt.listOf((Object)new OrderPayDuplicated(payOrder.getOrderId(), payOrder.getPaymentId()));
        }
        BigDecimal currentPayable = this.state.getPayable();
        if (currentPayable.compareTo(payOrder.getAmount()) >= 0) {
            return CollectionsKt.listOf((Object)new OrderPaid(payOrder.getOrderId(), payOrder.getAmount(), Intrinsics.areEqual((Object)currentPayable, (Object)payOrder.getAmount())));
        }
        BigDecimal bigDecimal = payOrder.getAmount().subtract(currentPayable);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.subtract(other)");
        BigDecimal overPay = bigDecimal;
        OrderPaid orderPaid = new OrderPaid(payOrder.getOrderId(), currentPayable, true);
        OrderOverPaid overPaid = new OrderOverPaid(payOrder.getOrderId(), payOrder.getPaymentId(), overPay);
        Object[] objectArray = new Object[]{orderPaid, overPaid};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/domains/order/model/Order$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-domains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

