/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.domains.order.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.domains.order.event.AddressChanged;
import me.ahoo.wow.domains.order.event.OrderCreated;
import me.ahoo.wow.domains.order.event.OrderPaid;
import me.ahoo.wow.domains.order.event.OrderReceived;
import me.ahoo.wow.domains.order.event.OrderShipped;
import me.ahoo.wow.domains.order.model.OrderItem;
import me.ahoo.wow.domains.order.model.OrderStatus;
import me.ahoo.wow.domains.order.model.ShippingAddress;
import me.ahoo.wow.event.DomainEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(J\u0014\u0010\u001f\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006,"}, d2={"Lme/ahoo/wow/domains/order/model/OrderState;", "", "id", "", "(Ljava/lang/String;)V", "<set-?>", "Lme/ahoo/wow/domains/order/model/ShippingAddress;", "address", "getAddress", "()Lme/ahoo/wow/domains/order/model/ShippingAddress;", "customerId", "getCustomerId", "()Ljava/lang/String;", "getId", "", "Lme/ahoo/wow/domains/order/model/OrderItem;", "items", "getItems", "()Ljava/util/List;", "Ljava/math/BigDecimal;", "paidAmount", "getPaidAmount", "()Ljava/math/BigDecimal;", "payable", "getPayable", "Lme/ahoo/wow/domains/order/model/OrderStatus;", "status", "getStatus", "()Lme/ahoo/wow/domains/order/model/OrderStatus;", "totalAmount", "getTotalAmount", "onSourcing", "", "addressChanged", "Lme/ahoo/wow/domains/order/event/AddressChanged;", "orderPaid", "Lme/ahoo/wow/domains/order/event/OrderPaid;", "orderReceived", "Lme/ahoo/wow/domains/order/event/OrderReceived;", "orderShipped", "Lme/ahoo/wow/domains/order/event/OrderShipped;", "orderCreated", "Lme/ahoo/wow/event/DomainEvent;", "Lme/ahoo/wow/domains/order/event/OrderCreated;", "wow-domains"})
public final class OrderState {
    @NotNull
    private final String id;
    private String customerId;
    private List<OrderItem> items;
    private ShippingAddress address;
    @NotNull
    private BigDecimal totalAmount;
    @NotNull
    private BigDecimal paidAmount;
    @NotNull
    private OrderStatus status;

    public OrderState(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        this.totalAmount = bigDecimal;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ZERO");
        this.paidAmount = bigDecimal2;
        this.status = OrderStatus.CREATED;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getCustomerId() {
        String string = this.customerId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"customerId");
        return null;
    }

    @NotNull
    public final List<OrderItem> getItems() {
        List<OrderItem> list = this.items;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"items");
        return null;
    }

    @NotNull
    public final ShippingAddress getAddress() {
        ShippingAddress shippingAddress = this.address;
        if (shippingAddress != null) {
            return shippingAddress;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"address");
        return null;
    }

    @NotNull
    public final BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    @NotNull
    public final BigDecimal getPaidAmount() {
        return this.paidAmount;
    }

    @NotNull
    public final OrderStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final BigDecimal getPayable() {
        BigDecimal bigDecimal = this.totalAmount.subtract(this.paidAmount);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.subtract(other)");
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    public final void onSourcing(@NotNull DomainEvent<OrderCreated> orderCreated) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(orderCreated, (String)"orderCreated");
        OrderCreated eventBody = (OrderCreated)orderCreated.getBody();
        this.customerId = eventBody.getCustomerId();
        this.address = eventBody.getAddress();
        this.items = eventBody.getItems();
        Iterable iterable = eventBody.getItems();
        OrderState orderState = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OrderItem orderItem = (OrderItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$totalPrice$iv = it;
            boolean $i$f$getTotalPrice = false;
            BigDecimal bigDecimal = $this$totalPrice$iv.getPrice();
            BigDecimal bigDecimal2 = BigDecimal.valueOf($this$totalPrice$iv.getQuantity());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"price.multiply(quantity.toBigDecimal())");
            collection.add(bigDecimal3);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void moneyToAdd;
            BigDecimal $i$f$mapTo2 = (BigDecimal)iterator$iv.next();
            BigDecimal totalPrice = (BigDecimal)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)totalPrice.add((BigDecimal)moneyToAdd), (String)"this.add(other)");
        }
        orderState.totalAmount = (BigDecimal)accumulator$iv;
        this.status = OrderStatus.CREATED;
    }

    public final void onSourcing(@NotNull AddressChanged addressChanged) {
        Intrinsics.checkNotNullParameter((Object)addressChanged, (String)"addressChanged");
        this.address = addressChanged.getShippingAddress();
    }

    private final void onSourcing(OrderPaid orderPaid) {
        BigDecimal bigDecimal = this.paidAmount.add(orderPaid.getAmount());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.add(other)");
        this.paidAmount = bigDecimal;
        if (orderPaid.getPaid()) {
            this.status = OrderStatus.PAID;
        }
    }

    public final void onSourcing(@NotNull OrderShipped orderShipped) {
        Intrinsics.checkNotNullParameter((Object)orderShipped, (String)"orderShipped");
        this.status = OrderStatus.SHIPPED;
    }

    public final void onSourcing(@NotNull OrderReceived orderReceived) {
        Intrinsics.checkNotNullParameter((Object)orderReceived, (String)"orderReceived");
        this.status = OrderStatus.RECEIVED;
    }
}

