/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.domains.order.saga;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.wow.domains.order.command.ShipOrder;
import me.ahoo.wow.domains.order.event.OrderCancelled;
import me.ahoo.wow.domains.order.event.OrderCreated;
import me.ahoo.wow.domains.order.event.OrderPaid;
import me.ahoo.wow.domains.order.event.OrderShipped;
import me.ahoo.wow.domains.order.model.PayOrder;
import me.ahoo.wow.domains.payment.command.PreparePayment;
import me.ahoo.wow.domains.payment.command.Refund;
import me.ahoo.wow.domains.payment.event.PaymentPaid;
import me.ahoo.wow.domains.warehouse.command.PrepareShip;
import me.ahoo.wow.domains.warehouse.command.Ship;
import me.ahoo.wow.domains.warehouse.event.Shipped;
import me.ahoo.wow.saga.annotation.Saga;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Saga
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0007\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0007\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/ahoo/wow/domains/order/saga/OrderProcessManager;", "", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "(Lme/ahoo/cosid/IdGenerator;)V", "processState", "Lme/ahoo/wow/domains/order/saga/OrderProcessManager$ProcessState;", "onEvent", "", "orderCancelled", "Lme/ahoo/wow/domains/order/event/OrderCancelled;", "orderCreated", "Lme/ahoo/wow/domains/order/event/OrderCreated;", "Lme/ahoo/wow/domains/warehouse/command/Ship;", "orderPaid", "Lme/ahoo/wow/domains/order/event/OrderPaid;", "", "orderShipped", "Lme/ahoo/wow/domains/order/event/OrderShipped;", "Lme/ahoo/wow/domains/order/model/PayOrder;", "paymentPaid", "Lme/ahoo/wow/domains/payment/event/PaymentPaid;", "Lme/ahoo/wow/domains/order/command/ShipOrder;", "shipped", "Lme/ahoo/wow/domains/warehouse/event/Shipped;", "ProcessState", "wow-domains"})
public final class OrderProcessManager {
    @NotNull
    private final IdGenerator idGenerator;
    @Nullable
    private ProcessState processState;

    public OrderProcessManager(@NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        this.idGenerator = idGenerator;
    }

    @NotNull
    public final Iterable<?> onEvent(@NotNull OrderCreated orderCreated) {
        Intrinsics.checkNotNullParameter((Object)orderCreated, (String)"orderCreated");
        this.processState = ProcessState.CREATED;
        String string = this.idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idGenerator.generateAsString()");
        PreparePayment preparePayment = new PreparePayment(string, orderCreated.getOrderId());
        String string2 = this.idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idGenerator.generateAsString()");
        PrepareShip prepareShip = new PrepareShip(string2, orderCreated.getOrderId());
        Object[] objectArray = new Object[]{preparePayment, prepareShip};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final PayOrder onEvent(@NotNull PaymentPaid paymentPaid) {
        Intrinsics.checkNotNullParameter((Object)paymentPaid, (String)"paymentPaid");
        this.processState = ProcessState.PAYMENT_PAID;
        return new PayOrder(paymentPaid.getBizId(), paymentPaid.getPaymentId(), paymentPaid.getAmount());
    }

    @NotNull
    public final Ship onEvent(@NotNull OrderPaid orderPaid) {
        Intrinsics.checkNotNullParameter((Object)orderPaid, (String)"orderPaid");
        this.processState = ProcessState.ORDER_PAID;
        return new Ship(orderPaid.getOrderId());
    }

    @NotNull
    public final ShipOrder onEvent(@NotNull Shipped shipped) {
        Intrinsics.checkNotNullParameter((Object)shipped, (String)"shipped");
        this.processState = ProcessState.SHIPPED;
        return new ShipOrder(shipped.getBizId());
    }

    @NotNull
    public final Iterable<?> onEvent(@Nullable OrderCancelled orderCancelled) {
        Iterable iterable;
        ProcessState preState = this.processState;
        ProcessState processState = this.processState = ProcessState.ORDER_CANCELLED;
        switch (processState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[processState.ordinal()]) {
            case 1: {
                iterable = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                iterable = CollectionsKt.listOf((Object)new Refund());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.processState));
            }
        }
        return iterable;
    }

    public final void onEvent(@Nullable OrderShipped orderShipped) {
        this.processState = ProcessState.ORDER_SHIPPED;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/domains/order/saga/OrderProcessManager$ProcessState;", "", "(Ljava/lang/String;I)V", "CREATED", "PAYMENT_PAID", "ORDER_PAID", "INVENTORY_LOCKED", "SHIPPED", "ORDER_SHIPPED", "ORDER_CANCELLED", "wow-domains"})
    public static final class ProcessState
    extends Enum<ProcessState> {
        public static final /* enum */ ProcessState CREATED = new ProcessState();
        public static final /* enum */ ProcessState PAYMENT_PAID = new ProcessState();
        public static final /* enum */ ProcessState ORDER_PAID = new ProcessState();
        public static final /* enum */ ProcessState INVENTORY_LOCKED = new ProcessState();
        public static final /* enum */ ProcessState SHIPPED = new ProcessState();
        public static final /* enum */ ProcessState ORDER_SHIPPED = new ProcessState();
        public static final /* enum */ ProcessState ORDER_CANCELLED = new ProcessState();
        private static final /* synthetic */ ProcessState[] $VALUES;

        public static ProcessState[] values() {
            return (ProcessState[])$VALUES.clone();
        }

        public static ProcessState valueOf(String value) {
            return Enum.valueOf(ProcessState.class, value);
        }

        static {
            $VALUES = processStateArray = new ProcessState[]{ProcessState.CREATED, ProcessState.PAYMENT_PAID, ProcessState.ORDER_PAID, ProcessState.INVENTORY_LOCKED, ProcessState.SHIPPED, ProcessState.ORDER_SHIPPED, ProcessState.ORDER_CANCELLED};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProcessState.values().length];
            nArray[ProcessState.CREATED.ordinal()] = 1;
            nArray[ProcessState.PAYMENT_PAID.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

