/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.elasticsearch;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.elasticsearch.DefaultSnapshotIndexNameConverter;
import me.ahoo.wow.elasticsearch.ElasticsearchSnapshotRepository;
import me.ahoo.wow.elasticsearch.SnapshotIndexNameConverter;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.xcontent.XContentType;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\n\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\u000bH\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/elasticsearch/ElasticsearchSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/reactive/ReactiveElasticsearchClient;", "snapshotIndexNameConverter", "Lme/ahoo/wow/elasticsearch/SnapshotIndexNameConverter;", "refreshPolicy", "Lorg/elasticsearch/action/support/WriteRequest$RefreshPolicy;", "(Lorg/springframework/data/elasticsearch/client/reactive/ReactiveElasticsearchClient;Lme/ahoo/wow/elasticsearch/SnapshotIndexNameConverter;Lorg/elasticsearch/action/support/WriteRequest$RefreshPolicy;)V", "load", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "save", "Ljava/lang/Void;", "snapshot", "asIndexName", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "wow-elasticsearch"})
public final class ElasticsearchSnapshotRepository
implements SnapshotRepository {
    @NotNull
    private final ReactiveElasticsearchClient elasticsearchClient;
    @NotNull
    private final SnapshotIndexNameConverter snapshotIndexNameConverter;
    @NotNull
    private final WriteRequest.RefreshPolicy refreshPolicy;

    public ElasticsearchSnapshotRepository(@NotNull ReactiveElasticsearchClient elasticsearchClient, @NotNull SnapshotIndexNameConverter snapshotIndexNameConverter, @NotNull WriteRequest.RefreshPolicy refreshPolicy) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        Intrinsics.checkNotNullParameter((Object)snapshotIndexNameConverter, (String)"snapshotIndexNameConverter");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        this.elasticsearchClient = elasticsearchClient;
        this.snapshotIndexNameConverter = snapshotIndexNameConverter;
        this.refreshPolicy = refreshPolicy;
    }

    public /* synthetic */ ElasticsearchSnapshotRepository(ReactiveElasticsearchClient reactiveElasticsearchClient, SnapshotIndexNameConverter snapshotIndexNameConverter, WriteRequest.RefreshPolicy refreshPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            snapshotIndexNameConverter = DefaultSnapshotIndexNameConverter.INSTANCE;
        }
        if ((n & 4) != 0) {
            refreshPolicy = WriteRequest.RefreshPolicy.WAIT_UNTIL;
        }
        this(reactiveElasticsearchClient, snapshotIndexNameConverter, refreshPolicy);
    }

    private final String asIndexName(NamedAggregate $this$asIndexName) {
        return this.snapshotIndexNameConverter.convert($this$asIndexName);
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        GetRequest getRequest = new GetRequest(this.asIndexName((NamedAggregate)aggregateId), aggregateId.getId());
        Mono mono = this.elasticsearchClient.get(getRequest).map(arg_0 -> ElasticsearchSnapshotRepository.load$lambda$0(load.1.INSTANCE, arg_0)).onErrorResume(arg_0 -> ElasticsearchSnapshotRepository.load$lambda$1(load.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"elasticsearchClient.get(\u2026o.error(it)\n            }");
        return mono;
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        IndexRequest indexRequest = (IndexRequest)new IndexRequest(this.asIndexName((NamedAggregate)snapshot.getAggregateId())).id(snapshot.getAggregateId().getId()).source(JsonSerializerKt.asJsonString(snapshot), XContentType.JSON).setRefreshPolicy(this.refreshPolicy);
        Mono mono = this.elasticsearchClient.index(indexRequest).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"elasticsearchClient.inde\u2026uest)\n            .then()");
        return mono;
    }

    private static final Snapshot load$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Snapshot)$tmp0.invoke(p0);
    }

    private static final Mono load$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }
}

