/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.elasticsearch.query.event;

import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.DynamicDocument;
import me.ahoo.wow.api.query.IListQuery;
import me.ahoo.wow.api.query.SimpleDynamicDocument;
import me.ahoo.wow.elasticsearch.IndexNameConverter;
import me.ahoo.wow.elasticsearch.query.ElasticsearchConditionConverter;
import me.ahoo.wow.elasticsearch.query.ElasticsearchProjectionConverter;
import me.ahoo.wow.elasticsearch.query.ElasticsearchSortConverter;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.query.event.EventStreamQueryService;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Flux;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/elasticsearch/query/event/ElasticsearchEventStreamQueryService;", "Lme/ahoo/wow/query/event/EventStreamQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "<init>", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "eventStreamIndexName", "", "list", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/event/DomainEventStream;", "listQuery", "Lme/ahoo/wow/api/query/IListQuery;", "dynamicList", "Lme/ahoo/wow/api/query/DynamicDocument;", "wow-elasticsearch"})
@SourceDebugExtension(value={"SMAP\nElasticsearchEventStreamQueryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElasticsearchEventStreamQueryService.kt\nme/ahoo/wow/elasticsearch/query/event/ElasticsearchEventStreamQueryService\n+ 2 JsonSerializer.kt\nme/ahoo/wow/serialization/JsonSerializerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n69#2:70\n1557#3:71\n1628#3,3:72\n*S KotlinDebug\n*F\n+ 1 ElasticsearchEventStreamQueryService.kt\nme/ahoo/wow/elasticsearch/query/event/ElasticsearchEventStreamQueryService\n*L\n39#1:70\n61#1:71\n61#1:72,3\n*E\n"})
public final class ElasticsearchEventStreamQueryService
implements EventStreamQueryService {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final ReactiveElasticsearchClient elasticsearchClient;
    @NotNull
    private final String eventStreamIndexName;

    public ElasticsearchEventStreamQueryService(@NotNull NamedAggregate namedAggregate, @NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        this.namedAggregate = namedAggregate;
        this.elasticsearchClient = elasticsearchClient;
        this.eventStreamIndexName = IndexNameConverter.INSTANCE.toEventStreamIndexName(this.getNamedAggregate());
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public Flux<DomainEventStream> list(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        Flux flux = this.dynamicList(listQuery).map(arg_0 -> ElasticsearchEventStreamQueryService.list$lambda$1(ElasticsearchEventStreamQueryService::list$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flux<DynamicDocument> dynamicList(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        SearchRequest searchRequest = SearchRequest.of(arg_0 -> ElasticsearchEventStreamQueryService.dynamicList$lambda$3(this, listQuery, arg_0));
        Flux flux = this.elasticsearchClient.search(searchRequest, Map.class).flatMapIterable(arg_0 -> ElasticsearchEventStreamQueryService.dynamicList$lambda$7(ElasticsearchEventStreamQueryService::dynamicList$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapIterable(...)");
        return flux;
    }

    private static final DomainEventStream list$lambda$0(DynamicDocument it) {
        Intrinsics.checkNotNull((Object)it);
        String $this$toObject$iv = JsonSerializerKt.toJsonString((Object)it);
        boolean $i$f$toObject = false;
        return (DomainEventStream)JsonSerializerKt.toObject((String)$this$toObject$iv, DomainEventStream.class);
    }

    private static final DomainEventStream list$lambda$1(Function1 $tmp0, Object p0) {
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    private static final ObjectBuilder dynamicList$lambda$3$lambda$2(IListQuery $listQuery, SourceConfig.Builder it) {
        return it.filter(ElasticsearchProjectionConverter.INSTANCE.toSourceFilter($listQuery.getProjection()));
    }

    private static final ObjectBuilder dynamicList$lambda$3(ElasticsearchEventStreamQueryService this$0, IListQuery $listQuery, SearchRequest.Builder it) {
        it.index(this$0.eventStreamIndexName, new String[0]).query(ElasticsearchConditionConverter.INSTANCE.toQuery($listQuery.getCondition())).size(Integer.valueOf($listQuery.getLimit()));
        if (!((Collection)$listQuery.getSort()).isEmpty()) {
            it.sort(ElasticsearchSortConverter.INSTANCE.toSortOptions($listQuery.getSort()));
        }
        if (!$listQuery.getProjection().isEmpty()) {
            it.source(arg_0 -> ElasticsearchEventStreamQueryService.dynamicList$lambda$3$lambda$2($listQuery, arg_0));
        }
        return (ObjectBuilder)it;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable dynamicList$lambda$6(ResponseBody result) {
        List list;
        Object object = result.hits();
        if (object != null && (object = object.hits()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SimpleDynamicDocument simpleDynamicDocument;
                void hit;
                Hit hit2 = (Hit)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if ((Map)hit.source() != null) {
                    Map it;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    simpleDynamicDocument = SimpleDynamicDocument.Companion.toDynamicDocument(it);
                } else {
                    simpleDynamicDocument = null;
                }
                collection.add(simpleDynamicDocument);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList();
    }

    private static final Iterable dynamicList$lambda$7(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }
}

