/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.elasticsearch.query.snapshot;

import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.DynamicDocument;
import me.ahoo.wow.api.query.IListQuery;
import me.ahoo.wow.api.query.IPagedQuery;
import me.ahoo.wow.api.query.ISingleQuery;
import me.ahoo.wow.api.query.ListQuery;
import me.ahoo.wow.api.query.MaterializedSnapshot;
import me.ahoo.wow.api.query.PagedList;
import me.ahoo.wow.api.query.PagedQuery;
import me.ahoo.wow.api.query.Pagination;
import me.ahoo.wow.api.query.Projection;
import me.ahoo.wow.api.query.SimpleDynamicDocument;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.elasticsearch.IndexNameConverter;
import me.ahoo.wow.elasticsearch.query.ElasticsearchConditionConverter;
import me.ahoo.wow.elasticsearch.query.ElasticsearchProjectionConverter;
import me.ahoo.wow.elasticsearch.query.ElasticsearchSortConverter;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.query.snapshot.SnapshotQueryService;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u001f0\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001f0\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00132\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006'"}, d2={"Lme/ahoo/wow/elasticsearch/query/snapshot/ElasticsearchSnapshotQueryService;", "S", "", "Lme/ahoo/wow/query/snapshot/SnapshotQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "<init>", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "snapshotIndexName", "", "snapshotType", "Lcom/fasterxml/jackson/databind/JavaType;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/JavaType;", "single", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/api/query/MaterializedSnapshot;", "singleQuery", "Lme/ahoo/wow/api/query/ISingleQuery;", "dynamicSingle", "Lme/ahoo/wow/api/query/DynamicDocument;", "list", "Lreactor/core/publisher/Flux;", "listQuery", "Lme/ahoo/wow/api/query/IListQuery;", "dynamicList", "paged", "Lme/ahoo/wow/api/query/PagedList;", "pagedQuery", "Lme/ahoo/wow/api/query/IPagedQuery;", "dynamicPaged", "count", "", "condition", "Lme/ahoo/wow/api/query/Condition;", "wow-elasticsearch"})
@SourceDebugExtension(value={"SMAP\nElasticsearchSnapshotQueryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElasticsearchSnapshotQueryService.kt\nme/ahoo/wow/elasticsearch/query/snapshot/ElasticsearchSnapshotQueryService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1557#2:129\n1628#2,3:130\n1557#2:133\n1628#2,3:134\n*S KotlinDebug\n*F\n+ 1 ElasticsearchSnapshotQueryService.kt\nme/ahoo/wow/elasticsearch/query/snapshot/ElasticsearchSnapshotQueryService\n*L\n87#1:129\n87#1:130,3\n114#1:133\n114#1:134,3\n*E\n"})
public final class ElasticsearchSnapshotQueryService<S>
implements SnapshotQueryService<S> {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final ReactiveElasticsearchClient elasticsearchClient;
    @NotNull
    private final String snapshotIndexName;
    private final JavaType snapshotType;

    public ElasticsearchSnapshotQueryService(@NotNull NamedAggregate namedAggregate, @NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        this.namedAggregate = namedAggregate;
        this.elasticsearchClient = elasticsearchClient;
        this.snapshotIndexName = IndexNameConverter.INSTANCE.toSnapshotIndexName(this.getNamedAggregate());
        Class[] classArray = new Class[]{AggregateMetadataParserKt.aggregateMetadata((Class)MetadataSearcherKt.requiredAggregateType((NamedAggregate)this.getNamedAggregate())).getState().getAggregateType()};
        this.snapshotType = TypeFactory.defaultInstance().constructParametricType(MaterializedSnapshot.class, classArray);
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public Mono<MaterializedSnapshot<S>> single(@NotNull ISingleQuery singleQuery) {
        Intrinsics.checkNotNullParameter((Object)singleQuery, (String)"singleQuery");
        Mono mono = this.dynamicSingle(singleQuery).map(arg_0 -> ElasticsearchSnapshotQueryService.single$lambda$1(arg_0 -> ElasticsearchSnapshotQueryService.single$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<DynamicDocument> dynamicSingle(@NotNull ISingleQuery singleQuery) {
        Intrinsics.checkNotNullParameter((Object)singleQuery, (String)"singleQuery");
        Condition condition = singleQuery.getCondition();
        Projection projection = singleQuery.getProjection();
        List list = singleQuery.getSort();
        ListQuery listQuery = new ListQuery(condition, projection, list, 1);
        Mono mono = this.dynamicList((IListQuery)listQuery).single();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"single(...)");
        return mono;
    }

    @NotNull
    public Flux<MaterializedSnapshot<S>> list(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        Flux flux = this.dynamicList(listQuery).map(arg_0 -> ElasticsearchSnapshotQueryService.list$lambda$3(arg_0 -> ElasticsearchSnapshotQueryService.list$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flux<DynamicDocument> dynamicList(@NotNull IListQuery listQuery) {
        Intrinsics.checkNotNullParameter((Object)listQuery, (String)"listQuery");
        PagedQuery pagedQuery = new PagedQuery(listQuery.getCondition(), listQuery.getProjection(), listQuery.getSort(), new Pagination(1, listQuery.getLimit()));
        Flux flux = this.dynamicPaged((IPagedQuery)pagedQuery).flatMapIterable(arg_0 -> ElasticsearchSnapshotQueryService.dynamicList$lambda$5(ElasticsearchSnapshotQueryService::dynamicList$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapIterable(...)");
        return flux;
    }

    @NotNull
    public Mono<PagedList<MaterializedSnapshot<S>>> paged(@NotNull IPagedQuery pagedQuery) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery, (String)"pagedQuery");
        Mono mono = this.dynamicPaged(pagedQuery).map(arg_0 -> ElasticsearchSnapshotQueryService.paged$lambda$8(arg_0 -> ElasticsearchSnapshotQueryService.paged$lambda$7(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<PagedList<DynamicDocument>> dynamicPaged(@NotNull IPagedQuery pagedQuery) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery, (String)"pagedQuery");
        SearchRequest searchRequest = SearchRequest.of(arg_0 -> ElasticsearchSnapshotQueryService.dynamicPaged$lambda$10(this, pagedQuery, arg_0));
        Mono mono = this.elasticsearchClient.search(searchRequest, Map.class).mapNotNull(arg_0 -> ElasticsearchSnapshotQueryService.dynamicPaged$lambda$14(ElasticsearchSnapshotQueryService::dynamicPaged$lambda$13, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"mapNotNull(...)");
        return mono;
    }

    @NotNull
    public Mono<Long> count(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        PagedQuery pagedQuery = new PagedQuery(condition, null, null, new Pagination(1, 0), 6, null);
        Mono mono = this.dynamicPaged((IPagedQuery)pagedQuery).map(arg_0 -> ElasticsearchSnapshotQueryService.count$lambda$16(ElasticsearchSnapshotQueryService::count$lambda$15, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final MaterializedSnapshot single$lambda$0(ElasticsearchSnapshotQueryService this$0, DynamicDocument doc) {
        Intrinsics.checkNotNull((Object)doc);
        String string = JsonSerializerKt.toJsonString((Object)doc);
        JavaType javaType = this$0.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        return (MaterializedSnapshot)JsonSerializerKt.toObject((String)string, (JavaType)javaType);
    }

    private static final MaterializedSnapshot single$lambda$1(Function1 $tmp0, Object p0) {
        return (MaterializedSnapshot)$tmp0.invoke(p0);
    }

    private static final MaterializedSnapshot list$lambda$2(ElasticsearchSnapshotQueryService this$0, DynamicDocument doc) {
        Intrinsics.checkNotNull((Object)doc);
        String string = JsonSerializerKt.toJsonString((Object)doc);
        JavaType javaType = this$0.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        return (MaterializedSnapshot)JsonSerializerKt.toObject((String)string, (JavaType)javaType);
    }

    private static final MaterializedSnapshot list$lambda$3(Function1 $tmp0, Object p0) {
        return (MaterializedSnapshot)$tmp0.invoke(p0);
    }

    private static final Iterable dynamicList$lambda$4(PagedList it) {
        return it.getList();
    }

    private static final Iterable dynamicList$lambda$5(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final PagedList paged$lambda$7(ElasticsearchSnapshotQueryService this$0, PagedList it) {
        Collection<MaterializedSnapshot> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = it.getList();
        long l = it.getTotal();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void doc;
            DynamicDocument dynamicDocument = (DynamicDocument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = JsonSerializerKt.toJsonString((Object)doc);
            JavaType javaType = this$0.snapshotType;
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
            collection.add((MaterializedSnapshot)JsonSerializerKt.toObject((String)string, (JavaType)javaType));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        long l2 = l;
        return new PagedList(l2, list);
    }

    private static final PagedList paged$lambda$8(Function1 $tmp0, Object p0) {
        return (PagedList)$tmp0.invoke(p0);
    }

    private static final ObjectBuilder dynamicPaged$lambda$10$lambda$9(IPagedQuery $pagedQuery, SourceConfig.Builder it) {
        return it.filter(ElasticsearchProjectionConverter.INSTANCE.toSourceFilter($pagedQuery.getProjection()));
    }

    private static final ObjectBuilder dynamicPaged$lambda$10(ElasticsearchSnapshotQueryService this$0, IPagedQuery $pagedQuery, SearchRequest.Builder it) {
        it.index(this$0.snapshotIndexName, new String[0]).query(ElasticsearchConditionConverter.INSTANCE.toQuery($pagedQuery.getCondition())).from(Integer.valueOf($pagedQuery.getPagination().offset())).size(Integer.valueOf($pagedQuery.getPagination().getSize()));
        if (!((Collection)$pagedQuery.getSort()).isEmpty()) {
            it.sort(ElasticsearchSortConverter.INSTANCE.toSortOptions($pagedQuery.getSort()));
        }
        if (!$pagedQuery.getProjection().isEmpty()) {
            it.source(arg_0 -> ElasticsearchSnapshotQueryService.dynamicPaged$lambda$10$lambda$9($pagedQuery, arg_0));
        }
        return (ObjectBuilder)it;
    }

    /*
     * WARNING - void declaration
     */
    private static final PagedList dynamicPaged$lambda$13(ResponseBody result) {
        List list;
        List list2;
        Object object = result.hits();
        if (object != null && (object = object.hits()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SimpleDynamicDocument simpleDynamicDocument;
                void hit;
                Hit hit2 = (Hit)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if ((Map)hit.source() != null) {
                    Map it;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    simpleDynamicDocument = SimpleDynamicDocument.Companion.toDynamicDocument(it);
                } else {
                    simpleDynamicDocument = null;
                }
                collection.add(simpleDynamicDocument);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List list3 = list;
        HitsMetadata hitsMetadata = result.hits();
        return new PagedList(hitsMetadata != null && (hitsMetadata = hitsMetadata.total()) != null ? hitsMetadata.value() : 0L, list3);
    }

    private static final PagedList dynamicPaged$lambda$14(Function1 $tmp0, Object p0) {
        return (PagedList)$tmp0.invoke(p0);
    }

    private static final Long count$lambda$15(PagedList it) {
        return it.getTotal();
    }

    private static final Long count$lambda$16(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }
}

