/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.io.Resources;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import me.ahoo.wow.messaging.dispatcher.SafeSubscriber;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/elasticsearch/IndexTemplateInitializer;", "", "elasticsearchOperations", "Lorg/springframework/data/elasticsearch/core/ReactiveElasticsearchOperations;", "<init>", "(Lorg/springframework/data/elasticsearch/core/ReactiveElasticsearchOperations;)V", "eventStreamTemplate", "Lcom/fasterxml/jackson/databind/JsonNode;", "snapshotTemplate", "initEventStreamTemplate", "Lreactor/core/publisher/Mono;", "", "initSnapshotTemplate", "initTemplate", "name", "", "template", "initAll", "", "Companion", "InitSubscriber", "wow-elasticsearch"})
@SourceDebugExtension(value={"SMAP\nIndexTemplateInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexTemplateInitializer.kt\nme/ahoo/wow/elasticsearch/IndexTemplateInitializer\n+ 2 JsonSerializer.kt\nme/ahoo/wow/serialization/JsonSerializerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,82:1\n67#2:83\n67#2:84\n1563#3:85\n1634#3,3:86\n37#4:89\n36#4,3:90\n*S KotlinDebug\n*F\n+ 1 IndexTemplateInitializer.kt\nme/ahoo/wow/elasticsearch/IndexTemplateInitializer\n*L\n41#1:83\n45#1:84\n60#1:85\n60#1:86,3\n62#1:89\n62#1:90,3\n*E\n"})
public final class IndexTemplateInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveElasticsearchOperations elasticsearchOperations;
    @NotNull
    private final JsonNode eventStreamTemplate;
    @NotNull
    private final JsonNode snapshotTemplate;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(IndexTemplateInitializer::log$lambda$5);
    @NotNull
    private static final String EVENT_STREAM_TEMPLATE_NAME = "wow-event-stream-template";
    @NotNull
    private static final String SNAPSHOT_TEMPLATE_NAME = "wow-snapshot-template";
    @NotNull
    private static final String INDEX_PATTERNS_KEY = "index_patterns";
    @NotNull
    private static final String TEMPLATE_KEY = "template";
    @NotNull
    private static final String MAPPINGS_KEY = "mappings";

    public IndexTemplateInitializer(@NotNull ReactiveElasticsearchOperations elasticsearchOperations) {
        ClassPathResource it;
        Intrinsics.checkNotNullParameter((Object)elasticsearchOperations, (String)"elasticsearchOperations");
        this.elasticsearchOperations = elasticsearchOperations;
        ClassPathResource classPathResource = new ClassPathResource("templates/wow-event-stream-template.json");
        IndexTemplateInitializer indexTemplateInitializer = this;
        boolean bl = false;
        String string = Resources.toString((URL)it.getURL(), (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String $this$toObject$iv = string;
        boolean $i$f$toObject = false;
        indexTemplateInitializer.eventStreamTemplate = (JsonNode)JsonSerializerKt.toObject((String)$this$toObject$iv, JsonNode.class);
        it = new ClassPathResource("templates/wow-snapshot-template.json");
        indexTemplateInitializer = this;
        boolean bl2 = false;
        String string2 = Resources.toString((URL)it.getURL(), (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        $this$toObject$iv = string2;
        $i$f$toObject = false;
        indexTemplateInitializer.snapshotTemplate = (JsonNode)JsonSerializerKt.toObject((String)$this$toObject$iv, JsonNode.class);
    }

    @NotNull
    public final Mono<Boolean> initEventStreamTemplate() {
        return this.initTemplate(EVENT_STREAM_TEMPLATE_NAME, this.eventStreamTemplate);
    }

    @NotNull
    public final Mono<Boolean> initSnapshotTemplate() {
        return this.initTemplate(SNAPSHOT_TEMPLATE_NAME, this.snapshotTemplate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mono<Boolean> initTemplate(@NotNull String name, @NotNull JsonNode template) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)template, (String)TEMPLATE_KEY);
        log.info(() -> IndexTemplateInitializer.initTemplate$lambda$2(name));
        JsonNode jsonNode = template.get(INDEX_PATTERNS_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"get(...)");
        Iterable $this$map$iv = (Iterable)jsonNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asText());
        }
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] indexPatterns = thisCollection$iv.toArray(new String[0]);
        JsonNode jsonNode3 = template.get(TEMPLATE_KEY).get(MAPPINGS_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"get(...)");
        String it = JsonSerializerKt.toJsonString((Object)jsonNode3);
        boolean bl = false;
        Document document = Document.parse((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"let(...)");
        Document mappings = document;
        PutIndexTemplateRequest putIndexTemplateRequest = PutIndexTemplateRequest.builder().withName(name).withIndexPatterns(Arrays.copyOf(indexPatterns, indexPatterns.length)).withMapping(mappings).build();
        Intrinsics.checkNotNullExpressionValue((Object)putIndexTemplateRequest, (String)"build(...)");
        PutIndexTemplateRequest putIndexTemplateRequest2 = putIndexTemplateRequest;
        String[] stringArray = new String[]{name};
        Mono mono = this.elasticsearchOperations.indexOps(IndexCoordinates.of((String[])stringArray)).putIndexTemplate(putIndexTemplateRequest2);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"putIndexTemplate(...)");
        return mono;
    }

    public final void initAll() {
        this.initEventStreamTemplate().subscribe((CoreSubscriber)new InitSubscriber("InitEventStreamTemplate"));
        this.initSnapshotTemplate().subscribe((CoreSubscriber)new InitSubscriber("InitEventStreamTemplate"));
    }

    private static final Object initTemplate$lambda$2(String $name) {
        return "initTemplate - name:" + $name + " .";
    }

    private static final Unit log$lambda$5() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/elasticsearch/IndexTemplateInitializer$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "EVENT_STREAM_TEMPLATE_NAME", "", "SNAPSHOT_TEMPLATE_NAME", "INDEX_PATTERNS_KEY", "TEMPLATE_KEY", "MAPPINGS_KEY", "wow-elasticsearch"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/elasticsearch/IndexTemplateInitializer$InitSubscriber;", "Lme/ahoo/wow/messaging/dispatcher/SafeSubscriber;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "wow-elasticsearch"})
    public static final class InitSubscriber
    extends SafeSubscriber<Boolean> {
        @NotNull
        private final String name;

        public InitSubscriber(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

