/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.elasticsearch.eventsourcing;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermRangeQuery;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.core.search.SourceFilter;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.elasticsearch.IndexNameConverter;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.elasticsearch.RestStatusException;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\nH\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/ahoo/wow/elasticsearch/eventsourcing/ElasticsearchSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "refreshPolicy", "Lco/elastic/clients/elasticsearch/_types/Refresh;", "<init>", "(Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;Lco/elastic/clients/elasticsearch/_types/Refresh;)V", "load", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "save", "Ljava/lang/Void;", "snapshot", "scanAggregateId", "Lreactor/core/publisher/Flux;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "afterId", "", "limit", "", "Companion", "wow-elasticsearch"})
@SourceDebugExtension(value={"SMAP\nElasticsearchSnapshotRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElasticsearchSnapshotRepository.kt\nme/ahoo/wow/elasticsearch/eventsourcing/ElasticsearchSnapshotRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1563#2:104\n1634#2,3:105\n*S KotlinDebug\n*F\n+ 1 ElasticsearchSnapshotRepository.kt\nme/ahoo/wow/elasticsearch/eventsourcing/ElasticsearchSnapshotRepository\n*L\n94#1:104\n94#1:105,3\n*E\n"})
public final class ElasticsearchSnapshotRepository
implements SnapshotRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveElasticsearchClient elasticsearchClient;
    @NotNull
    private final Refresh refreshPolicy;
    private static final int NOT_FOUND_CODE = 404;

    public ElasticsearchSnapshotRepository(@NotNull ReactiveElasticsearchClient elasticsearchClient, @NotNull Refresh refreshPolicy) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        this.elasticsearchClient = elasticsearchClient;
        this.refreshPolicy = refreshPolicy;
    }

    public /* synthetic */ ElasticsearchSnapshotRepository(ReactiveElasticsearchClient reactiveElasticsearchClient, Refresh refresh, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            refresh = Refresh.True;
        }
        this(reactiveElasticsearchClient, refresh);
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Mono mono = this.elasticsearchClient.get(arg_0 -> ElasticsearchSnapshotRepository.load$lambda$0(aggregateId, arg_0), Snapshot.class).mapNotNull(arg_0 -> ElasticsearchSnapshotRepository.load$lambda$2(ElasticsearchSnapshotRepository::load$lambda$1, arg_0)).onErrorResume(arg_0 -> ElasticsearchSnapshotRepository.load$lambda$4(ElasticsearchSnapshotRepository::load$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorResume(...)");
        return mono;
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Mono mono = this.elasticsearchClient.index(arg_0 -> ElasticsearchSnapshotRepository.save$lambda$5(snapshot, this, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    public Flux<AggregateId> scanAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String afterId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)afterId, (String)"afterId");
        Flux flux = this.elasticsearchClient.search(arg_0 -> ElasticsearchSnapshotRepository.scanAggregateId$lambda$13(namedAggregate, limit, afterId, arg_0), Map.class).flatMapIterable(arg_0 -> ElasticsearchSnapshotRepository.scanAggregateId$lambda$16(arg_0 -> ElasticsearchSnapshotRepository.scanAggregateId$lambda$15(namedAggregate, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapIterable(...)");
        return flux;
    }

    private static final ObjectBuilder load$lambda$0(AggregateId $aggregateId, GetRequest.Builder it) {
        return (ObjectBuilder)it.index(IndexNameConverter.INSTANCE.toSnapshotIndexName((NamedAggregate)$aggregateId)).id($aggregateId.getId());
    }

    private static final Snapshot load$lambda$1(GetResponse it) {
        return (Snapshot)it.source();
    }

    private static final Snapshot load$lambda$2(Function1 $tmp0, Object p0) {
        return (Snapshot)$tmp0.invoke(p0);
    }

    private static final Mono load$lambda$3(Throwable it) {
        if (it instanceof RestStatusException && ((RestStatusException)it).getStatus() == 404) {
            return Mono.empty();
        }
        if (it instanceof ElasticsearchException && ((ElasticsearchException)it).response().status() == 404) {
            return Mono.empty();
        }
        return Mono.error((Throwable)it);
    }

    private static final Mono load$lambda$4(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final ObjectBuilder save$lambda$5(Snapshot $snapshot, ElasticsearchSnapshotRepository this$0, IndexRequest.Builder it) {
        return (ObjectBuilder)it.index(IndexNameConverter.INSTANCE.toSnapshotIndexName((NamedAggregate)$snapshot.getAggregateId())).id($snapshot.getAggregateId().getId()).document((Object)$snapshot).refresh(this$0.refreshPolicy);
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$8$lambda$7$lambda$6(String $afterId, TermRangeQuery.Builder it) {
        return (ObjectBuilder)it.field("aggregateId").gt((Object)$afterId);
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$8$lambda$7(String $afterId, RangeQuery.Builder it) {
        return it.term(arg_0 -> ElasticsearchSnapshotRepository.scanAggregateId$lambda$13$lambda$8$lambda$7$lambda$6($afterId, arg_0));
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$8(String $afterId, Query.Builder it) {
        return it.range(arg_0 -> ElasticsearchSnapshotRepository.scanAggregateId$lambda$13$lambda$8$lambda$7($afterId, arg_0));
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$10$lambda$9(SourceFilter.Builder it) {
        String[] stringArray = new String[]{"tenantId"};
        return (ObjectBuilder)it.includes("aggregateId", stringArray);
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$10(SourceConfig.Builder it) {
        return it.filter(ElasticsearchSnapshotRepository::scanAggregateId$lambda$13$lambda$10$lambda$9);
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$12$lambda$11(FieldSort.Builder it) {
        return (ObjectBuilder)it.field("aggregateId").order(SortOrder.Asc);
    }

    private static final ObjectBuilder scanAggregateId$lambda$13$lambda$12(SortOptions.Builder it) {
        return it.field(ElasticsearchSnapshotRepository::scanAggregateId$lambda$13$lambda$12$lambda$11);
    }

    private static final ObjectBuilder scanAggregateId$lambda$13(NamedAggregate $namedAggregate, int $limit, String $afterId, SearchRequest.Builder it) {
        return (ObjectBuilder)it.index(IndexNameConverter.INSTANCE.toSnapshotIndexName($namedAggregate), new String[0]).query(arg_0 -> ElasticsearchSnapshotRepository.scanAggregateId$lambda$13$lambda$8($afterId, arg_0)).source(ElasticsearchSnapshotRepository::scanAggregateId$lambda$13$lambda$10).size(Integer.valueOf($limit)).sort(ElasticsearchSnapshotRepository::scanAggregateId$lambda$13$lambda$12);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable scanAggregateId$lambda$15(NamedAggregate $namedAggregate, ResponseBody it) {
        void $this$mapTo$iv$iv;
        List list = it.hits().hits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"hits(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String tenantId;
            String aggregateId;
            void hit;
            Hit hit2 = (Hit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = hit.source();
            if (object == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Map source = (Map)object;
            Object v = source.get("aggregateId");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            if ((String)v == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Object v2 = source.get("tenantId");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
            if ((String)v2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(DefaultAggregateIdKt.aggregateId((NamedAggregate)$namedAggregate, (String)aggregateId, (String)tenantId));
        }
        return (List)destination$iv$iv;
    }

    private static final Iterable scanAggregateId$lambda$16(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/elasticsearch/eventsourcing/ElasticsearchSnapshotRepository$Companion;", "", "<init>", "()V", "NOT_FOUND_CODE", "", "wow-elasticsearch"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

