/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.elasticsearch.query.snapshot;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.DynamicDocument;
import me.ahoo.wow.api.query.MaterializedSnapshot;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.elasticsearch.IndexNameConverter;
import me.ahoo.wow.elasticsearch.query.AbstractElasticsearchQueryService;
import me.ahoo.wow.elasticsearch.query.snapshot.SnapshotConditionConverter;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.query.converter.ConditionConverter;
import me.ahoo.wow.query.snapshot.SnapshotQueryService;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0005B'\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/ahoo/wow/elasticsearch/query/snapshot/ElasticsearchSnapshotQueryService;", "S", "", "Lme/ahoo/wow/elasticsearch/query/AbstractElasticsearchQueryService;", "Lme/ahoo/wow/api/query/MaterializedSnapshot;", "Lme/ahoo/wow/query/snapshot/SnapshotQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "conditionConverter", "Lme/ahoo/wow/query/converter/ConditionConverter;", "Lco/elastic/clients/elasticsearch/_types/query_dsl/Query;", "<init>", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;Lme/ahoo/wow/query/converter/ConditionConverter;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "getElasticsearchClient", "()Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "getConditionConverter", "()Lme/ahoo/wow/query/converter/ConditionConverter;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "snapshotType", "Lcom/fasterxml/jackson/databind/JavaType;", "kotlin.jvm.PlatformType", "toTypedResult", "document", "Lme/ahoo/wow/api/query/DynamicDocument;", "wow-elasticsearch"})
public final class ElasticsearchSnapshotQueryService<S>
extends AbstractElasticsearchQueryService<MaterializedSnapshot<S>>
implements SnapshotQueryService<S> {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final ReactiveElasticsearchClient elasticsearchClient;
    @NotNull
    private final ConditionConverter<Query> conditionConverter;
    @NotNull
    private final String indexName;
    private final JavaType snapshotType;

    public ElasticsearchSnapshotQueryService(@NotNull NamedAggregate namedAggregate, @NotNull ReactiveElasticsearchClient elasticsearchClient, @NotNull ConditionConverter<Query> conditionConverter) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        Intrinsics.checkNotNullParameter(conditionConverter, (String)"conditionConverter");
        this.namedAggregate = namedAggregate;
        this.elasticsearchClient = elasticsearchClient;
        this.conditionConverter = conditionConverter;
        this.indexName = IndexNameConverter.INSTANCE.toSnapshotIndexName(this.getNamedAggregate());
        Class[] classArray = new Class[]{AggregateMetadataParserKt.aggregateMetadata((Class)MetadataSearcherKt.requiredAggregateType((NamedAggregate)this.getNamedAggregate())).getState().getAggregateType()};
        this.snapshotType = TypeFactory.defaultInstance().constructParametricType(MaterializedSnapshot.class, classArray);
    }

    public /* synthetic */ ElasticsearchSnapshotQueryService(NamedAggregate namedAggregate, ReactiveElasticsearchClient reactiveElasticsearchClient, ConditionConverter conditionConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            conditionConverter = (ConditionConverter)SnapshotConditionConverter.INSTANCE;
        }
        this(namedAggregate, reactiveElasticsearchClient, (ConditionConverter<Query>)conditionConverter);
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @Override
    @NotNull
    public ReactiveElasticsearchClient getElasticsearchClient() {
        return this.elasticsearchClient;
    }

    @Override
    @NotNull
    public ConditionConverter<Query> getConditionConverter() {
        return this.conditionConverter;
    }

    @Override
    @NotNull
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    @NotNull
    public MaterializedSnapshot<S> toTypedResult(@NotNull DynamicDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = JsonSerializerKt.toJsonString((Object)document);
        JavaType javaType = this.snapshotType;
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"snapshotType");
        return (MaterializedSnapshot)JsonSerializerKt.toObject((String)string, (JavaType)javaType);
    }
}

