/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.AggregateIdCapable;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.kafka.AbstractKafkaBus;
import me.ahoo.wow.kafka.KafkaCommandBusKt;
import me.ahoo.wow.kafka.NoOpReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizerKt;
import me.ahoo.wow.messaging.DistributedMessageBus;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.kafka.receiver.KafkaReceiver;
import reactor.kafka.receiver.ReceiverOffset;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverRecord;
import reactor.kafka.sender.KafkaSender;
import reactor.kafka.sender.SenderOptions;
import reactor.kafka.sender.SenderRecord;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;
import reactor.util.retry.Retry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 0*\u0014\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u00020\u0003*\u00020\u0004*\u0012\b\u0001\u0010\u0005*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00010\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00050\u0007:\u00010B7\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J#\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001cH\u0004\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f2\u0006\u0010\"\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0004J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020!0)2\u0006\u0010\"\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00028\u0001*\u00028\u00002\u0006\u0010,\u001a\u00020-H&\u00a2\u0006\u0002\u0010.J\f\u0010/\u001a\u00020\n*\u00020\u0004H&R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lme/ahoo/wow/kafka/AbstractKafkaBus;", "M", "Lme/ahoo/wow/api/messaging/Message;", "Lme/ahoo/wow/api/modeling/AggregateIdCapable;", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "E", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "Lme/ahoo/wow/messaging/DistributedMessageBus;", "senderOptions", "Lreactor/kafka/sender/SenderOptions;", "", "receiverOptions", "Lreactor/kafka/receiver/ReceiverOptions;", "receiverOptionsCustomizer", "Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;", "(Lreactor/kafka/sender/SenderOptions;Lreactor/kafka/receiver/ReceiverOptions;Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "sender", "Lreactor/kafka/sender/KafkaSender;", "getSender", "()Lreactor/kafka/sender/KafkaSender;", "close", "", "decode", "receiverRecord", "Lreactor/kafka/receiver/ReceiverRecord;", "(Lreactor/kafka/receiver/ReceiverRecord;)Lme/ahoo/wow/api/messaging/Message;", "encode", "Lreactor/kafka/sender/SenderRecord;", "Lreactor/core/publisher/Sinks$Empty;", "Ljava/lang/Void;", "message", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/kafka/sender/SenderRecord;", "receiveMessage", "Lreactor/core/publisher/Flux;", "namedAggregates", "", "sendMessage", "Lreactor/core/publisher/Mono;", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/core/publisher/Mono;", "asExchange", "receiverOffset", "Lreactor/kafka/receiver/ReceiverOffset;", "(Lme/ahoo/wow/api/messaging/Message;Lreactor/kafka/receiver/ReceiverOffset;)Lme/ahoo/wow/messaging/handler/MessageExchange;", "asTopic", "Companion", "wow-kafka"})
@SourceDebugExtension(value={"SMAP\nAbstractKafkaBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKafkaBus.kt\nme/ahoo/wow/kafka/AbstractKafkaBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n*S KotlinDebug\n*F\n+ 1 AbstractKafkaBus.kt\nme/ahoo/wow/kafka/AbstractKafkaBus\n*L\n82#1:131\n82#1:132,3\n*E\n"})
public abstract class AbstractKafkaBus<M extends Message<?> & AggregateIdCapable, E extends MessageExchange<?, ? extends M>>
implements DistributedMessageBus<M, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SenderOptions<String, String> senderOptions;
    @NotNull
    private final ReceiverOptions<String, String> receiverOptions;
    @NotNull
    private final ReceiverOptionsCustomizer receiverOptionsCustomizer;
    @NotNull
    private final KafkaSender<String, String> sender;
    private static final Logger log = LoggerFactory.getLogger(AbstractKafkaBus.class);

    public AbstractKafkaBus(@NotNull SenderOptions<String, String> senderOptions, @NotNull ReceiverOptions<String, String> receiverOptions, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter(senderOptions, (String)"senderOptions");
        Intrinsics.checkNotNullParameter(receiverOptions, (String)"receiverOptions");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        this.senderOptions = senderOptions;
        this.receiverOptions = receiverOptions;
        this.receiverOptionsCustomizer = receiverOptionsCustomizer;
        KafkaSender kafkaSender = KafkaSender.create(this.senderOptions);
        Intrinsics.checkNotNullExpressionValue((Object)kafkaSender, (String)"create(senderOptions)");
        this.sender = kafkaSender;
    }

    public /* synthetic */ AbstractKafkaBus(SenderOptions senderOptions, ReceiverOptions receiverOptions, ReceiverOptionsCustomizer receiverOptionsCustomizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            receiverOptionsCustomizer = NoOpReceiverOptionsCustomizer.INSTANCE;
        }
        this((SenderOptions<String, String>)senderOptions, (ReceiverOptions<String, String>)receiverOptions, receiverOptionsCustomizer);
    }

    @NotNull
    protected final KafkaSender<String, String> getSender() {
        return this.sender;
    }

    @NotNull
    public abstract Class<M> getMessageType();

    @NotNull
    protected final Mono<Void> sendMessage(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (log.isDebugEnabled()) {
            log.debug("Send {}.", message);
        }
        SenderRecord<String, String, Sinks.Empty<Void>> senderRecord = this.encode(message);
        Mono mono = this.sender.send((Publisher)Mono.just(senderRecord)).doOnNext(arg_0 -> AbstractKafkaBus.sendMessage$lambda$0(sendMessage.1.INSTANCE, arg_0)).flatMap(arg_0 -> AbstractKafkaBus.sendMessage$lambda$1(sendMessage.2.INSTANCE, arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sender.send(Mono.just(se\u2026    }\n            .next()");
        return mono;
    }

    @NotNull
    public abstract String asTopic(@NotNull NamedAggregate var1);

    @NotNull
    public abstract E asExchange(@NotNull M var1, @NotNull ReceiverOffset var2);

    @NotNull
    protected final Flux<E> receiveMessage(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        Flux flux = Flux.deferContextual(arg_0 -> AbstractKafkaBus.receiveMessage$lambda$4(this, namedAggregates, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"deferContextual { contex\u2026              }\n        }");
        return flux;
    }

    @NotNull
    protected final SenderRecord<String, String, Sinks.Empty<Void>> encode(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        ProducerRecord producerRecord = new ProducerRecord(this.asTopic((NamedAggregate)message), null, Long.valueOf(message.getCreateTime()), (Object)((AggregateIdCapable)message).getAggregateId().getId(), (Object)JsonSerializerKt.asJsonString(message));
        SenderRecord senderRecord = SenderRecord.create((ProducerRecord)producerRecord, (Object)Sinks.empty());
        Intrinsics.checkNotNullExpressionValue((Object)senderRecord, (String)"create(producerRecord, Sinks.empty())");
        return senderRecord;
    }

    @Nullable
    protected final M decode(@NotNull ReceiverRecord<String, String> receiverRecord) {
        Message message;
        Intrinsics.checkNotNullParameter(receiverRecord, (String)"receiverRecord");
        try {
            Object object = receiverRecord.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"receiverRecord.value()");
            message = (Message)JsonSerializerKt.asObject((String)((String)object), this.getMessageType());
        }
        catch (Throwable e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to decode ReceiverRecord[" + receiverRecord + "].", e);
            }
            message = null;
        }
        return (M)message;
    }

    public void close() {
        if (log.isInfoEnabled()) {
            log.info('[' + this.getClass().getSimpleName() + "] Close KafkaSender.");
        }
        this.sender.close();
    }

    private static final void sendMessage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher sendMessage$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final MessageExchange receiveMessage$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MessageExchange)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher receiveMessage$lambda$4(AbstractKafkaBus this$0, Set $namedAggregates, ContextView contextView) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$namedAggregates, (String)"$namedAggregates");
        ReceiverOptions<String, String> receiverOptions = this$0.receiverOptionsCustomizer.customize(this$0.receiverOptions);
        Intrinsics.checkNotNullExpressionValue((Object)contextView, (String)"contextView");
        Iterable iterable = $namedAggregates;
        ReceiverOptions receiverOptions2 = receiverOptions.consumerProperty("group.id", (Object)MessageBusKt.getReceiverGroup((ContextView)contextView));
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NamedAggregate namedAggregate = (NamedAggregate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.asTopic((NamedAggregate)it));
        }
        ReceiverOptions receiverOptions3 = receiverOptions2.subscription((Collection)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)receiverOptions3, (String)"receiverOptionsCustomize\u2026{ it.asTopic() }.toSet())");
        ReceiverOptions options = receiverOptions3;
        ReceiverOptions<String, String> receiverOptions4 = ReceiverOptionsCustomizerKt.getReceiverOptionsCustomizer(contextView);
        if (receiverOptions4 == null || (receiverOptions4 = receiverOptions4.customize((ReceiverOptions<String, String>)options)) == null) {
            receiverOptions4 = options;
        }
        ReceiverOptions<String, String> customizedOptions = receiverOptions4;
        return (Publisher)KafkaReceiver.create(customizedOptions).receive(Integer.valueOf(Queues.SMALL_BUFFER_SIZE)).retryWhen((Retry)KafkaCommandBusKt.getDEFAULT_RECEIVE_RETRY_SPEC()).mapNotNull(arg_0 -> AbstractKafkaBus.receiveMessage$lambda$4$lambda$3((Function1)new Function1<ReceiverRecord<String, String>, E>(this$0){
            final /* synthetic */ AbstractKafkaBus<M, E> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final E invoke(ReceiverRecord<String, String> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                M m = this.this$0.decode(it);
                if (m == null) {
                    return null;
                }
                M message = m;
                ReceiverOffset receiverOffset = it.receiverOffset();
                Intrinsics.checkNotNullExpressionValue((Object)receiverOffset, (String)"it.receiverOffset()");
                return this.this$0.asExchange(message, receiverOffset);
            }
        }, arg_0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/kafka/AbstractKafkaBus$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-kafka"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

