/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.kafka.KafkaCommandBusKt;
import me.ahoo.wow.kafka.KafkaServerCommandExchange;
import me.ahoo.wow.kafka.KafkaTopicKt;
import me.ahoo.wow.kafka.NoOpReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizerKt;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kafka.receiver.KafkaReceiver;
import reactor.kafka.receiver.ReceiverOffset;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverRecord;
import reactor.kafka.sender.KafkaSender;
import reactor.kafka.sender.SenderRecord;
import reactor.util.context.ContextView;
import reactor.util.retry.Retry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\"\b\b\u0000\u0010\u001c*\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/ahoo/wow/kafka/KafkaCommandBus;", "Lme/ahoo/wow/command/CommandBus;", "sender", "Lreactor/kafka/sender/KafkaSender;", "", "receiverOptions", "Lreactor/kafka/receiver/ReceiverOptions;", "topicPrefix", "receiverOptionsCustomizer", "Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;", "(Lreactor/kafka/sender/KafkaSender;Lreactor/kafka/receiver/ReceiverOptions;Ljava/lang/String;Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;)V", "decode", "Lme/ahoo/wow/api/command/CommandMessage;", "", "receiverRecord", "Lreactor/kafka/receiver/ReceiverRecord;", "encode", "Lreactor/kafka/sender/SenderRecord;", "commandMessage", "receive", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/ServerCommandExchange;", "namedAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "C", "command", "Companion", "wow-kafka"})
@SourceDebugExtension(value={"SMAP\nKafkaCommandBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaCommandBus.kt\nme/ahoo/wow/kafka/KafkaCommandBus\n+ 2 JsonSerializer.kt\nme/ahoo/wow/serialization/JsonSerializerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n59#2:109\n1549#3:110\n1620#3,3:111\n*S KotlinDebug\n*F\n+ 1 KafkaCommandBus.kt\nme/ahoo/wow/kafka/KafkaCommandBus\n*L\n99#1:109\n73#1:110\n73#1:111,3\n*E\n"})
public final class KafkaCommandBus
implements CommandBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaSender<String, String> sender;
    @NotNull
    private final ReceiverOptions<String, String> receiverOptions;
    @NotNull
    private final String topicPrefix;
    @NotNull
    private final ReceiverOptionsCustomizer receiverOptionsCustomizer;
    @NotNull
    public static final String DEFAULT_RECEIVER_GROUP = "Wow-AggregateProcessor";
    private static final Logger log = LoggerFactory.getLogger(KafkaCommandBus.class);

    public KafkaCommandBus(@NotNull KafkaSender<String, String> sender, @NotNull ReceiverOptions<String, String> receiverOptions, @NotNull String topicPrefix, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Intrinsics.checkNotNullParameter(receiverOptions, (String)"receiverOptions");
        Intrinsics.checkNotNullParameter((Object)topicPrefix, (String)"topicPrefix");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        this.sender = sender;
        this.receiverOptions = receiverOptions;
        this.topicPrefix = topicPrefix;
        this.receiverOptionsCustomizer = receiverOptionsCustomizer;
    }

    public /* synthetic */ KafkaCommandBus(KafkaSender kafkaSender, ReceiverOptions receiverOptions, String string, ReceiverOptionsCustomizer receiverOptionsCustomizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "wow.";
        }
        if ((n & 8) != 0) {
            receiverOptionsCustomizer = NoOpReceiverOptionsCustomizer.INSTANCE;
        }
        this((KafkaSender<String, String>)kafkaSender, (ReceiverOptions<String, String>)receiverOptions, string, receiverOptionsCustomizer);
    }

    @NotNull
    public <C> Mono<Void> send(@NotNull CommandMessage<C> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Mono mono = Mono.defer(() -> KafkaCommandBus.send$lambda$1(this, command));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n            val \u2026        .then()\n        }");
        return mono;
    }

    @NotNull
    public Flux<ServerCommandExchange<Object>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        Flux flux = Flux.deferContextual(arg_0 -> KafkaCommandBus.receive$lambda$4(this, namedAggregates, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"deferContextual { contex\u2026              }\n        }");
        return flux;
    }

    private final SenderRecord<String, String, String> encode(CommandMessage<?> commandMessage) {
        ProducerRecord producerRecord = new ProducerRecord(KafkaTopicKt.asCommandTopic((NamedAggregate)commandMessage, this.topicPrefix), null, Long.valueOf(commandMessage.getCreateTime()), (Object)commandMessage.getAggregateId().getId(), (Object)JsonSerializerKt.asJsonString(commandMessage));
        SenderRecord senderRecord = SenderRecord.create((ProducerRecord)producerRecord, (Object)commandMessage.getId());
        Intrinsics.checkNotNullExpressionValue((Object)senderRecord, (String)"create(producerRecord, commandMessage.id)");
        return senderRecord;
    }

    private final CommandMessage<Object> decode(ReceiverRecord<String, String> receiverRecord) {
        CommandMessage commandMessage;
        try {
            Object object = receiverRecord.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"receiverRecord.value()");
            String $this$asObject$iv = (String)object;
            boolean $i$f$asObject = false;
            commandMessage = (CommandMessage)JsonSerializerKt.asObject((String)$this$asObject$iv, CommandMessage.class);
        }
        catch (Throwable e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to decode ReceiverRecord[" + receiverRecord + "].", e);
            }
            commandMessage = null;
        }
        return commandMessage;
    }

    private static final void send$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono send$lambda$1(KafkaCommandBus this$0, CommandMessage $command) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        SenderRecord<String, String, String> senderRecord = this$0.encode($command);
        return this$0.sender.send((Publisher)Mono.just(senderRecord)).doOnError(arg_0 -> KafkaCommandBus.send$lambda$1$lambda$0((Function1)new Function1<Throwable, Unit>($command){
            final /* synthetic */ CommandMessage<C> $command;
            {
                this.$command = $command;
                super(1);
            }

            public final void invoke(Throwable it) {
                if (KafkaCommandBus.access$getLog$cp().isErrorEnabled()) {
                    KafkaCommandBus.access$getLog$cp().error("Send command[" + this.$command.getId() + "] failed!", it);
                }
            }
        }, arg_0)).then();
    }

    private static final ServerCommandExchange receive$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ServerCommandExchange)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher receive$lambda$4(KafkaCommandBus this$0, Set $namedAggregates, ContextView contextView) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$namedAggregates, (String)"$namedAggregates");
        ReceiverOptions<String, String> receiverOptions = this$0.receiverOptionsCustomizer.customize(this$0.receiverOptions);
        Intrinsics.checkNotNullExpressionValue((Object)contextView, (String)"contextView");
        Iterable iterable = $namedAggregates;
        ReceiverOptions receiverOptions2 = receiverOptions.consumerProperty("group.id", (Object)MessageBusKt.getReceiverGroupOrDefault((ContextView)contextView, (String)DEFAULT_RECEIVER_GROUP));
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NamedAggregate namedAggregate = (NamedAggregate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KafkaTopicKt.asCommandTopic((NamedAggregate)it, this$0.topicPrefix));
        }
        ReceiverOptions receiverOptions3 = receiverOptions2.subscription((Collection)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)receiverOptions3, (String)"receiverOptionsCustomize\u2026c(topicPrefix) }.toSet())");
        ReceiverOptions options = receiverOptions3;
        ReceiverOptions<String, String> receiverOptions4 = ReceiverOptionsCustomizerKt.getReceiverOptionsCustomizer(contextView);
        if (receiverOptions4 == null || (receiverOptions4 = receiverOptions4.customize((ReceiverOptions<String, String>)options)) == null) {
            receiverOptions4 = options;
        }
        ReceiverOptions<String, String> customizedOptions = receiverOptions4;
        return (Publisher)KafkaReceiver.create(customizedOptions).receive().retryWhen((Retry)KafkaCommandBusKt.getDEFAULT_RECEIVE_RETRY_SPEC()).mapNotNull(arg_0 -> KafkaCommandBus.receive$lambda$4$lambda$3((Function1)new Function1<ReceiverRecord<String, String>, ServerCommandExchange<Object>>(this$0){
            final /* synthetic */ KafkaCommandBus this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ServerCommandExchange<Object> invoke(ReceiverRecord<String, String> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                CommandMessage commandMessage = KafkaCommandBus.access$decode(this.this$0, it);
                if (commandMessage == null) {
                    return null;
                }
                CommandMessage commandMessage2 = commandMessage;
                ReceiverOffset receiverOffset = it.receiverOffset();
                Intrinsics.checkNotNullExpressionValue((Object)receiverOffset, (String)"it.receiverOffset()");
                return new KafkaServerCommandExchange<C>(commandMessage2, receiverOffset, null, null, null, null, 60, null);
            }
        }, arg_0));
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ CommandMessage access$decode(KafkaCommandBus $this, ReceiverRecord receiverRecord) {
        return $this.decode((ReceiverRecord<String, String>)receiverRecord);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/kafka/KafkaCommandBus$Companion;", "", "()V", "DEFAULT_RECEIVER_GROUP", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-kafka"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

