/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.AggregateIdCapable;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.kafka.AbstractKafkaBus;
import me.ahoo.wow.kafka.KafkaCommandBusKt;
import me.ahoo.wow.kafka.NoOpReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizerKt;
import me.ahoo.wow.messaging.MessageBus;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.kafka.receiver.KafkaReceiver;
import reactor.kafka.receiver.ReceiverOffset;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverRecord;
import reactor.kafka.sender.KafkaSender;
import reactor.kafka.sender.SenderRecord;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;
import reactor.util.retry.Retry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 )*\u0014\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u00020\u0003*\u00020\u0004*\u0004\b\u0001\u0010\u00052\u00020\u0006:\u0001)B7\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0004J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\u0006\u0010\u001b\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u00028\u0001*\u00028\u00002\u0006\u0010%\u001a\u00020&H&\u00a2\u0006\u0002\u0010'J\f\u0010(\u001a\u00020\t*\u00020\u0004H&R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lme/ahoo/wow/kafka/AbstractKafkaBus;", "M", "Lme/ahoo/wow/api/messaging/Message;", "Lme/ahoo/wow/api/modeling/AggregateIdCapable;", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "E", "Lme/ahoo/wow/messaging/MessageBus;", "sender", "Lreactor/kafka/sender/KafkaSender;", "", "receiverOptions", "Lreactor/kafka/receiver/ReceiverOptions;", "receiverOptionsCustomizer", "Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;", "(Lreactor/kafka/sender/KafkaSender;Lreactor/kafka/receiver/ReceiverOptions;Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "decode", "receiverRecord", "Lreactor/kafka/receiver/ReceiverRecord;", "(Lreactor/kafka/receiver/ReceiverRecord;)Lme/ahoo/wow/api/messaging/Message;", "encode", "Lreactor/kafka/sender/SenderRecord;", "Lreactor/core/publisher/Sinks$Empty;", "Ljava/lang/Void;", "message", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/kafka/sender/SenderRecord;", "receiveMessage", "Lreactor/core/publisher/Flux;", "namedAggregates", "", "sendMessage", "Lreactor/core/publisher/Mono;", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/core/publisher/Mono;", "asExchange", "receiverOffset", "Lreactor/kafka/receiver/ReceiverOffset;", "(Lme/ahoo/wow/api/messaging/Message;Lreactor/kafka/receiver/ReceiverOffset;)Ljava/lang/Object;", "asTopic", "Companion", "wow-kafka"})
@SourceDebugExtension(value={"SMAP\nAbstractKafkaBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKafkaBus.kt\nme/ahoo/wow/kafka/AbstractKafkaBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1549#2:111\n1620#2,3:112\n*S KotlinDebug\n*F\n+ 1 AbstractKafkaBus.kt\nme/ahoo/wow/kafka/AbstractKafkaBus\n*L\n74#1:111\n74#1:112,3\n*E\n"})
public abstract class AbstractKafkaBus<M extends Message<?> & AggregateIdCapable, E>
implements MessageBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaSender<String, String> sender;
    @NotNull
    private final ReceiverOptions<String, String> receiverOptions;
    @NotNull
    private final ReceiverOptionsCustomizer receiverOptionsCustomizer;
    private static final Logger log = LoggerFactory.getLogger(AbstractKafkaBus.class);

    public AbstractKafkaBus(@NotNull KafkaSender<String, String> sender, @NotNull ReceiverOptions<String, String> receiverOptions, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Intrinsics.checkNotNullParameter(receiverOptions, (String)"receiverOptions");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        this.sender = sender;
        this.receiverOptions = receiverOptions;
        this.receiverOptionsCustomizer = receiverOptionsCustomizer;
    }

    public /* synthetic */ AbstractKafkaBus(KafkaSender kafkaSender, ReceiverOptions receiverOptions, ReceiverOptionsCustomizer receiverOptionsCustomizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            receiverOptionsCustomizer = NoOpReceiverOptionsCustomizer.INSTANCE;
        }
        this((KafkaSender<String, String>)kafkaSender, (ReceiverOptions<String, String>)receiverOptions, receiverOptionsCustomizer);
    }

    @NotNull
    public abstract Class<M> getMessageType();

    @NotNull
    protected final Mono<Void> sendMessage(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        SenderRecord<String, String, Sinks.Empty<Void>> senderRecord = this.encode(message);
        Mono mono = this.sender.send((Publisher)Mono.just(senderRecord)).doOnNext(arg_0 -> AbstractKafkaBus.sendMessage$lambda$0(sendMessage.1.INSTANCE, arg_0)).flatMap(arg_0 -> AbstractKafkaBus.sendMessage$lambda$1(sendMessage.2.INSTANCE, arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sender.send(Mono.just(se\u2026    }\n            .next()");
        return mono;
    }

    @NotNull
    public abstract String asTopic(@NotNull NamedAggregate var1);

    public abstract E asExchange(@NotNull M var1, @NotNull ReceiverOffset var2);

    @NotNull
    protected final Flux<E> receiveMessage(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        Flux flux = Flux.deferContextual(arg_0 -> AbstractKafkaBus.receiveMessage$lambda$4(this, namedAggregates, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"deferContextual { contex\u2026              }\n        }");
        return flux;
    }

    @NotNull
    protected final SenderRecord<String, String, Sinks.Empty<Void>> encode(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        ProducerRecord producerRecord = new ProducerRecord(this.asTopic((NamedAggregate)message), null, Long.valueOf(message.getCreateTime()), (Object)((AggregateIdCapable)message).getAggregateId().getId(), (Object)JsonSerializerKt.asJsonString(message));
        SenderRecord senderRecord = SenderRecord.create((ProducerRecord)producerRecord, (Object)Sinks.empty());
        Intrinsics.checkNotNullExpressionValue((Object)senderRecord, (String)"create(producerRecord, Sinks.empty())");
        return senderRecord;
    }

    @Nullable
    protected final M decode(@NotNull ReceiverRecord<String, String> receiverRecord) {
        Message message;
        Intrinsics.checkNotNullParameter(receiverRecord, (String)"receiverRecord");
        try {
            Object object = receiverRecord.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"receiverRecord.value()");
            message = (Message)JsonSerializerKt.asObject((String)((String)object), this.getMessageType());
        }
        catch (Throwable e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to decode ReceiverRecord[" + receiverRecord + "].", e);
            }
            message = null;
        }
        return (M)message;
    }

    private static final void sendMessage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher sendMessage$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Object receiveMessage$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher receiveMessage$lambda$4(AbstractKafkaBus this$0, Set $namedAggregates, ContextView contextView) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$namedAggregates, (String)"$namedAggregates");
        ReceiverOptions<String, String> receiverOptions = this$0.receiverOptionsCustomizer.customize(this$0.receiverOptions);
        Intrinsics.checkNotNullExpressionValue((Object)contextView, (String)"contextView");
        Iterable iterable = $namedAggregates;
        ReceiverOptions receiverOptions2 = receiverOptions.consumerProperty("group.id", (Object)MessageBusKt.getReceiverGroup((ContextView)contextView));
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NamedAggregate namedAggregate = (NamedAggregate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.asTopic((NamedAggregate)it));
        }
        ReceiverOptions receiverOptions3 = receiverOptions2.subscription((Collection)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)receiverOptions3, (String)"receiverOptionsCustomize\u2026{ it.asTopic() }.toSet())");
        ReceiverOptions options = receiverOptions3;
        ReceiverOptions<String, String> receiverOptions4 = ReceiverOptionsCustomizerKt.getReceiverOptionsCustomizer(contextView);
        if (receiverOptions4 == null || (receiverOptions4 = receiverOptions4.customize((ReceiverOptions<String, String>)options)) == null) {
            receiverOptions4 = options;
        }
        ReceiverOptions<String, String> customizedOptions = receiverOptions4;
        return (Publisher)KafkaReceiver.create(customizedOptions).receive(Integer.valueOf(Queues.SMALL_BUFFER_SIZE)).retryWhen((Retry)KafkaCommandBusKt.getDEFAULT_RECEIVE_RETRY_SPEC()).mapNotNull(arg_0 -> AbstractKafkaBus.receiveMessage$lambda$4$lambda$3((Function1)new Function1<ReceiverRecord<String, String>, E>(this$0){
            final /* synthetic */ AbstractKafkaBus<M, E> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final E invoke(ReceiverRecord<String, String> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                M m = this.this$0.decode(it);
                if (m == null) {
                    return null;
                }
                M message = m;
                ReceiverOffset receiverOffset = it.receiverOffset();
                Intrinsics.checkNotNullExpressionValue((Object)receiverOffset, (String)"it.receiverOffset()");
                return this.this$0.asExchange(message, receiverOffset);
            }
        }, arg_0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/kafka/AbstractKafkaBus$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-kafka"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

