/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.AggregateIdCapable;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.kafka.AggregateTopicConverter;
import me.ahoo.wow.kafka.KafkaCommandBusKt;
import me.ahoo.wow.kafka.NoOpReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizerKt;
import me.ahoo.wow.messaging.DistributedMessageBus;
import me.ahoo.wow.messaging.ReceiverGroupKt;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.kafka.receiver.KafkaReceiver;
import reactor.kafka.receiver.ReceiverOffset;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverRecord;
import reactor.kafka.sender.KafkaSender;
import reactor.kafka.sender.SenderOptions;
import reactor.kafka.sender.SenderRecord;
import reactor.kafka.sender.SenderResult;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;
import reactor.util.retry.Retry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 2*\u0018\b\u0000\u0010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002*\u00020\u0003*\u00020\u0004*\u0012\b\u0001\u0010\u0005*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00010\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00050\u0007:\u00012BA\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u00028\u0001*\u00028\u00002\u0006\u0010!\u001a\u00020\"H&\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0016J-\u0010(\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0*0)2\u0006\u0010\u001e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010+J#\u0010,\u001a\u0004\u0018\u00018\u00002\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0.H\u0004\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00063"}, d2={"Lme/ahoo/wow/kafka/AbstractKafkaBus;", "M", "Lme/ahoo/wow/api/messaging/Message;", "Lme/ahoo/wow/api/modeling/AggregateIdCapable;", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "E", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "Lme/ahoo/wow/messaging/DistributedMessageBus;", "topicConverter", "Lme/ahoo/wow/kafka/AggregateTopicConverter;", "senderOptions", "Lreactor/kafka/sender/SenderOptions;", "", "receiverOptions", "Lreactor/kafka/receiver/ReceiverOptions;", "receiverOptionsCustomizer", "Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;", "<init>", "(Lme/ahoo/wow/kafka/AggregateTopicConverter;Lreactor/kafka/sender/SenderOptions;Lreactor/kafka/receiver/ReceiverOptions;Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;)V", "sender", "Lreactor/kafka/sender/KafkaSender;", "getSender", "()Lreactor/kafka/sender/KafkaSender;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/core/publisher/Mono;", "toExchange", "receiverOffset", "Lreactor/kafka/receiver/ReceiverOffset;", "(Lme/ahoo/wow/api/messaging/Message;Lreactor/kafka/receiver/ReceiverOffset;)Lme/ahoo/wow/messaging/handler/MessageExchange;", "receive", "Lreactor/core/publisher/Flux;", "namedAggregates", "", "encode", "Lreactor/kafka/sender/SenderRecord;", "Lreactor/core/publisher/Sinks$Empty;", "(Lme/ahoo/wow/api/messaging/Message;)Lreactor/kafka/sender/SenderRecord;", "decode", "receiverRecord", "Lreactor/kafka/receiver/ReceiverRecord;", "(Lreactor/kafka/receiver/ReceiverRecord;)Lme/ahoo/wow/api/messaging/Message;", "close", "", "Companion", "wow-kafka"})
@SourceDebugExtension(value={"SMAP\nAbstractKafkaBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKafkaBus.kt\nme/ahoo/wow/kafka/AbstractKafkaBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1557#2:133\n1628#2,3:134\n*S KotlinDebug\n*F\n+ 1 AbstractKafkaBus.kt\nme/ahoo/wow/kafka/AbstractKafkaBus\n*L\n85#1:133\n85#1:134,3\n*E\n"})
public abstract class AbstractKafkaBus<M extends Message<?, ?> & AggregateIdCapable, E extends MessageExchange<?, ? extends M>>
implements DistributedMessageBus<M, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateTopicConverter topicConverter;
    @NotNull
    private final SenderOptions<String, String> senderOptions;
    @NotNull
    private final ReceiverOptions<String, String> receiverOptions;
    @NotNull
    private final ReceiverOptionsCustomizer receiverOptionsCustomizer;
    @NotNull
    private final KafkaSender<String, String> sender;
    private static final Logger log = LoggerFactory.getLogger(AbstractKafkaBus.class);

    public AbstractKafkaBus(@NotNull AggregateTopicConverter topicConverter, @NotNull SenderOptions<String, String> senderOptions, @NotNull ReceiverOptions<String, String> receiverOptions, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter((Object)topicConverter, (String)"topicConverter");
        Intrinsics.checkNotNullParameter(senderOptions, (String)"senderOptions");
        Intrinsics.checkNotNullParameter(receiverOptions, (String)"receiverOptions");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        this.topicConverter = topicConverter;
        this.senderOptions = senderOptions;
        this.receiverOptions = receiverOptions;
        this.receiverOptionsCustomizer = receiverOptionsCustomizer;
        KafkaSender kafkaSender = KafkaSender.create(this.senderOptions);
        Intrinsics.checkNotNullExpressionValue((Object)kafkaSender, (String)"create(...)");
        this.sender = kafkaSender;
    }

    public /* synthetic */ AbstractKafkaBus(AggregateTopicConverter aggregateTopicConverter, SenderOptions senderOptions, ReceiverOptions receiverOptions, ReceiverOptionsCustomizer receiverOptionsCustomizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            receiverOptionsCustomizer = NoOpReceiverOptionsCustomizer.INSTANCE;
        }
        this(aggregateTopicConverter, (SenderOptions<String, String>)senderOptions, (ReceiverOptions<String, String>)receiverOptions, receiverOptionsCustomizer);
    }

    @NotNull
    protected final KafkaSender<String, String> getSender() {
        return this.sender;
    }

    @NotNull
    public abstract Class<M> getMessageType();

    @NotNull
    public Mono<Void> send(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Mono mono = Mono.defer(() -> AbstractKafkaBus.send$lambda$4(message, this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    @NotNull
    public abstract E toExchange(@NotNull M var1, @NotNull ReceiverOffset var2);

    @NotNull
    public Flux<E> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        Flux flux = Flux.deferContextual(arg_0 -> AbstractKafkaBus.receive$lambda$8(this, namedAggregates, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"deferContextual(...)");
        return flux;
    }

    @NotNull
    protected final SenderRecord<String, String, Sinks.Empty<Void>> encode(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        ProducerRecord producerRecord = new ProducerRecord(this.topicConverter.convert((NamedAggregate)message), null, Long.valueOf(message.getCreateTime()), (Object)((AggregateIdCapable)message).getAggregateId().getId(), (Object)JsonSerializerKt.toJsonString(message));
        SenderRecord senderRecord = SenderRecord.create((ProducerRecord)producerRecord, (Object)Sinks.empty());
        Intrinsics.checkNotNullExpressionValue((Object)senderRecord, (String)"create(...)");
        return senderRecord;
    }

    @Nullable
    protected final M decode(@NotNull ReceiverRecord<String, String> receiverRecord) {
        Message message;
        Intrinsics.checkNotNullParameter(receiverRecord, (String)"receiverRecord");
        try {
            Object object = receiverRecord.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
            message = (Message)JsonSerializerKt.toObject((String)((String)object), this.getMessageType());
        }
        catch (Throwable e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to decode ReceiverRecord[" + receiverRecord + "].", e);
            }
            message = null;
        }
        return (M)message;
    }

    public void close() {
        if (log.isInfoEnabled()) {
            log.info("[" + this.getClass().getSimpleName() + "] Close KafkaSender.");
        }
        this.sender.close();
    }

    private static final Unit send$lambda$4$lambda$0(SenderResult it) {
        Exception error = it.exception();
        Sinks.EmitResult emitResult = error != null ? ((Sinks.Empty)it.correlationMetadata()).tryEmitError((Throwable)error) : ((Sinks.Empty)it.correlationMetadata()).tryEmitEmpty();
        return Unit.INSTANCE;
    }

    private static final void send$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Publisher send$lambda$4$lambda$2(SenderResult it) {
        return (Publisher)((Sinks.Empty)it.correlationMetadata()).asMono();
    }

    private static final Publisher send$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono send$lambda$4(Message $message, AbstractKafkaBus this$0) {
        if (log.isDebugEnabled()) {
            log.debug("Send {}.", (Object)$message);
        }
        $message.withReadOnly();
        SenderRecord<String, String, Sinks.Empty<Void>> senderRecord = this$0.encode($message);
        return this$0.sender.send((Publisher)Mono.just(senderRecord)).doOnNext(arg_0 -> AbstractKafkaBus.send$lambda$4$lambda$1(AbstractKafkaBus::send$lambda$4$lambda$0, arg_0)).flatMap(arg_0 -> AbstractKafkaBus.send$lambda$4$lambda$3(AbstractKafkaBus::send$lambda$4$lambda$2, arg_0)).next();
    }

    private static final MessageExchange receive$lambda$8$lambda$6(AbstractKafkaBus this$0, ReceiverRecord it) {
        Intrinsics.checkNotNull((Object)it);
        Object m = this$0.decode((ReceiverRecord<String, String>)it);
        if (m == null) {
            return null;
        }
        Object message = m;
        ReceiverOffset receiverOffset = it.receiverOffset();
        Intrinsics.checkNotNullExpressionValue((Object)receiverOffset, (String)"receiverOffset(...)");
        return this$0.toExchange(message, receiverOffset);
    }

    private static final MessageExchange receive$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (MessageExchange)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher receive$lambda$8(AbstractKafkaBus this$0, Set $namedAggregates, ContextView contextView) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ReceiverOptions<String, String> receiverOptions = this$0.receiverOptionsCustomizer.customize(this$0.receiverOptions);
        Intrinsics.checkNotNull((Object)contextView);
        Iterable iterable = $namedAggregates;
        ReceiverOptions receiverOptions2 = receiverOptions.consumerProperty("group.id", (Object)ReceiverGroupKt.getReceiverGroup((ContextView)contextView));
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NamedAggregate namedAggregate = (NamedAggregate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.topicConverter.convert((NamedAggregate)it));
        }
        ReceiverOptions receiverOptions3 = receiverOptions2.subscription((Collection)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)receiverOptions3, (String)"subscription(...)");
        ReceiverOptions options = receiverOptions3;
        ReceiverOptions<String, String> receiverOptions4 = ReceiverOptionsCustomizerKt.getReceiverOptionsCustomizer(contextView);
        if (receiverOptions4 == null || (receiverOptions4 = receiverOptions4.customize((ReceiverOptions<String, String>)options)) == null) {
            receiverOptions4 = options;
        }
        ReceiverOptions<String, String> customizedOptions = receiverOptions4;
        return (Publisher)KafkaReceiver.create(customizedOptions).receive(Integer.valueOf(Queues.SMALL_BUFFER_SIZE)).retryWhen((Retry)KafkaCommandBusKt.getDEFAULT_RECEIVE_RETRY_SPEC()).mapNotNull(arg_0 -> AbstractKafkaBus.receive$lambda$8$lambda$7(arg_0 -> AbstractKafkaBus.receive$lambda$8$lambda$6(this$0, arg_0), arg_0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/kafka/AbstractKafkaBus$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "wow-kafka"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

