/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.prepare;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.infra.prepare.PreparedValue;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\tJ$\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\t\"\u0004\b\u0000\u0010\b*\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/mongo/prepare/PrepareRecords;", "", "()V", "TTL_AT_FIELD", "", "VALUE_FIELD", "asDocument", "Lorg/bson/Document;", "V", "Lme/ahoo/wow/infra/prepare/PreparedValue;", "asPreparedValue", "valueType", "Ljava/lang/Class;", "wow-mongo"})
public final class PrepareRecords {
    @NotNull
    public static final PrepareRecords INSTANCE = new PrepareRecords();
    @NotNull
    public static final String VALUE_FIELD = "value";
    @NotNull
    public static final String TTL_AT_FIELD = "ttlAt";

    private PrepareRecords() {
    }

    @NotNull
    public final <V> Document asDocument(@NotNull PreparedValue<V> $this$asDocument) {
        Intrinsics.checkNotNullParameter($this$asDocument, (String)"<this>");
        String jsonString = JsonSerializerKt.asJsonString($this$asDocument);
        Document document = Document.parse((String)jsonString);
        document.replace((Object)TTL_AT_FIELD, (Object)new Date($this$asDocument.getTtlAt()));
        document.remove((Object)"forever");
        document.remove((Object)"expired");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        return document;
    }

    @NotNull
    public final <V> PreparedValue<V> asPreparedValue(@NotNull Document $this$asPreparedValue, @NotNull Class<V> valueType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asPreparedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        Object object2 = $this$asPreparedValue.get((Object)VALUE_FIELD);
        if (object2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"checkNotNull(this[VALUE_FIELD])");
        Object rawValue = object2;
        if (valueType.isInstance(rawValue)) {
            object = valueType.cast(rawValue);
        } else if (rawValue instanceof Document) {
            String rawValueString = ((Document)rawValue).toJson();
            Intrinsics.checkNotNullExpressionValue((Object)rawValueString, (String)"rawValueString");
            object = JsonSerializerKt.asObject((String)rawValueString, valueType);
        } else {
            throw new IllegalArgumentException("valueType: " + valueType + " is not assignable from rawValue: " + rawValue);
        }
        V value = object;
        Date date = $this$asPreparedValue.getDate((Object)TTL_AT_FIELD);
        long ttlAt = date != null ? date.getTime() : 148204944000000L;
        return PreparedValue.Companion.asTtlAt(value, ttlAt);
    }
}

