/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.MongoSnapshotRepository;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00100\u000f\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/ahoo/wow/mongo/MongoSnapshotRepository;", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "findAggregateId", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/api/modeling/AggregateId;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "cursorId", "", "limit", "", "load", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "aggregateId", "mapSnapshot", "document", "Lorg/bson/Document;", "save", "Ljava/lang/Void;", "snapshot", "Companion", "wow-mongo"})
public final class MongoSnapshotRepository
implements SnapshotRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private static final ReplaceOptions DEFAULT_REPLACE_OPTIONS;

    public MongoSnapshotRepository(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    public <S> Mono<Snapshot<S>> load(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.asSnapshotCollectionName((NamedAggregate)aggregateId);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).find(Filters.eq((String)"_id", (Object)aggregateId.getId())).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"database.getCollection(s\u2026id))\n            .first()");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).map(arg_0 -> MongoSnapshotRepository.load$lambda$0((Function1)new Function1<Document, Snapshot<S>>(this, aggregateId){
            final /* synthetic */ MongoSnapshotRepository this$0;
            final /* synthetic */ AggregateId $aggregateId;
            {
                this.this$0 = $receiver;
                this.$aggregateId = $aggregateId;
                super(1);
            }

            public final Snapshot<S> invoke(Document it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return MongoSnapshotRepository.access$mapSnapshot(this.this$0, this.$aggregateId, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun <S : Any> l\u2026, it)\n            }\n    }");
        return mono;
    }

    @NotNull
    public Flux<AggregateId> findAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String cursorId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)cursorId, (String)"cursorId");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.asSnapshotCollectionName(namedAggregate);
        String[] stringArray = new String[]{"_id", "tenantId"};
        FindPublisher findPublisher = this.database.getCollection(snapshotCollectionName).find(Filters.gt((String)"_id", (Object)cursorId)).projection(Projections.include((String[])stringArray));
        stringArray = new String[]{"_id"};
        FindPublisher findPublisher2 = findPublisher.sort(Sorts.ascending((String[])stringArray)).limit(limit);
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher2, (String)"database.getCollection(s\u2026            .limit(limit)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher2)).map(arg_0 -> MongoSnapshotRepository.findAggregateId$lambda$1((Function1)new Function1<Document, AggregateId>(namedAggregate){
            final /* synthetic */ NamedAggregate $namedAggregate;
            {
                this.$namedAggregate = $namedAggregate;
                super(1);
            }

            public final AggregateId invoke(Document it) {
                String string = it.getString((Object)"_id");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getString(Documents.ID_FIELD)");
                String string2 = it.getString((Object)"tenantId");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.getString(MessageRecords.TENANT_ID)");
                return (AggregateId)DefaultAggregateIdKt.asAggregateId((NamedAggregate)this.$namedAggregate, (String)string, (String)string2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"namedAggregate: NamedAgg\u2026          )\n            }");
        return flux;
    }

    private final <S> Snapshot<S> mapSnapshot(AggregateId aggregateId, Document document) {
        Snapshot snapshot = DocumentsKt.asSnapshot(document);
        if (!Intrinsics.areEqual((Object)aggregateId.getId(), (Object)snapshot.getAggregateId().getId())) {
            boolean $i$a$-require-MongoSnapshotRepository$mapSnapshot$32 = false;
            String $i$a$-require-MongoSnapshotRepository$mapSnapshot$32 = "aggregateId is not equal! expected: " + aggregateId.getId() + ", actual: " + snapshot.getAggregateId().getId();
            throw new IllegalArgumentException($i$a$-require-MongoSnapshotRepository$mapSnapshot$32.toString());
        }
        if (!Intrinsics.areEqual((Object)snapshot.getAggregateId().getTenantId(), (Object)aggregateId.getTenantId())) {
            boolean bl = false;
            String string = "The aggregated tenantId[" + aggregateId.getTenantId() + "] does not match the tenantId:[" + snapshot.getAggregateId().getTenantId() + "] stored in the eventStore";
            throw new IllegalArgumentException(string.toString());
        }
        return snapshot;
    }

    @NotNull
    public <S> Mono<Void> save(@NotNull Snapshot<S> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        String snapshotCollectionName = AggregateSchemaInitializer.INSTANCE.asSnapshotCollectionName((NamedAggregate)snapshot.getAggregateId());
        String snapshotJsonString = JsonSerializerKt.asJsonString(snapshot);
        Document document = Document.parse((String)snapshotJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(snapshotJsonString)");
        Document document2 = Documents.INSTANCE.replaceAggregateIdAsPrimaryKey(document);
        Publisher publisher = this.database.getCollection(snapshotCollectionName).replaceOne(Filters.eq((String)"_id", (Object)snapshot.getAggregateId().getId()), (Object)document2, DEFAULT_REPLACE_OPTIONS);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"database.getCollection(s\u2026CE_OPTIONS,\n            )");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).doOnNext(arg_0 -> MongoSnapshotRepository.save$lambda$4(save.1.INSTANCE, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"database.getCollection(s\u2026d())\n            }.then()");
        return mono;
    }

    private static final Snapshot load$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Snapshot)$tmp0.invoke(p0);
    }

    private static final AggregateId findAggregateId$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateId)$tmp0.invoke(p0);
    }

    private static final void save$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Snapshot access$mapSnapshot(MongoSnapshotRepository $this, AggregateId aggregateId, Document document) {
        return $this.mapSnapshot(aggregateId, document);
    }

    static {
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"ReplaceOptions().upsert(true)");
        DEFAULT_REPLACE_OPTIONS = replaceOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/ahoo/wow/mongo/MongoSnapshotRepository$Companion;", "", "()V", "DEFAULT_REPLACE_OPTIONS", "Lcom/mongodb/client/model/ReplaceOptions;", "getDEFAULT_REPLACE_OPTIONS", "()Lcom/mongodb/client/model/ReplaceOptions;", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReplaceOptions getDEFAULT_REPLACE_OPTIONS() {
            return DEFAULT_REPLACE_OPTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

