/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.infra.accessor.method.reactive.BlockingMonoMethodAccessorKt;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\r\u001a\u00020\u0004*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\u0004*\u00020\u000eJ\u0010\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0014\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0015\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0016\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0017\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/ahoo/wow/mongo/AggregateSchemaInitializer;", "", "()V", "AGGREGATE_ID_AND_VERSION_UNIQUE_INDEX_NAME", "", "EVENT_STREAM_COLLECTION_SUFFIX", "REQUEST_ID_UNIQUE_INDEX_NAME", "SNAPSHOT_COLLECTION_SUFFIX", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "uniqueIndexOptions", "Lcom/mongodb/client/model/IndexOptions;", "asEventStreamCollectionName", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "asSnapshotCollectionName", "createAggregateIdAndRequestIdUniqueIndex", "", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "createAggregateIdAndVersionUniqueIndex", "createAggregateIdIndex", "createRequestIdUniqueIndex", "createTenantIdIndex", "ensureCollection", "", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "collectionName", "wow-mongo"})
public final class AggregateSchemaInitializer {
    @NotNull
    public static final AggregateSchemaInitializer INSTANCE = new AggregateSchemaInitializer();
    private static final Logger log = LoggerFactory.getLogger(AggregateSchemaInitializer.class);
    @NotNull
    public static final String AGGREGATE_ID_AND_VERSION_UNIQUE_INDEX_NAME = "aggregateId_1_version_1";
    @NotNull
    public static final String REQUEST_ID_UNIQUE_INDEX_NAME = "requestId_1";
    @NotNull
    private static final IndexOptions uniqueIndexOptions;
    @NotNull
    private static final String EVENT_STREAM_COLLECTION_SUFFIX = "_event_stream";
    @NotNull
    private static final String SNAPSHOT_COLLECTION_SUFFIX = "_snapshot";

    private AggregateSchemaInitializer() {
    }

    @NotNull
    public final String asEventStreamCollectionName(@NotNull NamedAggregate $this$asEventStreamCollectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$asEventStreamCollectionName, (String)"<this>");
        return $this$asEventStreamCollectionName.getAggregateName() + EVENT_STREAM_COLLECTION_SUFFIX;
    }

    @NotNull
    public final String asSnapshotCollectionName(@NotNull NamedAggregate $this$asSnapshotCollectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$asSnapshotCollectionName, (String)"<this>");
        return $this$asSnapshotCollectionName.getAggregateName() + SNAPSHOT_COLLECTION_SUFFIX;
    }

    public final boolean ensureCollection(@NotNull MongoDatabase $this$ensureCollection, @NotNull String collectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureCollection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Publisher publisher = $this$ensureCollection.listCollectionNames();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"listCollectionNames()");
        Mono mono = FluxExtensionsKt.toFlux((Publisher)publisher).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"listCollectionNames().toFlux().collectList()");
        Object object = BlockingMonoMethodAccessorKt.asBlockable$default((Mono)mono, null, (int)1, null).block();
        Intrinsics.checkNotNull((Object)object);
        List it = (List)object;
        boolean bl = false;
        if (it.contains(collectionName)) {
            if (log.isInfoEnabled()) {
                log.info("Ensure Collection {} already exists,ignore create.", (Object)collectionName);
            }
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info("Ensure Collection {} Creating.", (Object)collectionName);
        }
        Publisher publisher2 = $this$ensureCollection.createCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)publisher2, (String)"this.createCollection(collectionName)");
        MonoExtensionsKt.toMono((Publisher)publisher2).block();
        if (log.isInfoEnabled()) {
            log.info("Ensure Collection {} Created.", (Object)collectionName);
        }
        return true;
    }

    public final void createAggregateIdIndex(@NotNull MongoCollection<Document> $this$createAggregateIdIndex) {
        Intrinsics.checkNotNullParameter($this$createAggregateIdIndex, (String)"<this>");
        Publisher publisher = $this$createAggregateIdIndex.createIndex(Indexes.hashed((String)"aggregateId"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(Indexes.hash\u2026ageRecords.AGGREGATE_ID))");
        BlockingMonoMethodAccessorKt.asBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createAggregateIdAndVersionUniqueIndex(@NotNull MongoCollection<Document> $this$createAggregateIdAndVersionUniqueIndex) {
        Intrinsics.checkNotNullParameter($this$createAggregateIdAndVersionUniqueIndex, (String)"<this>");
        String[] stringArray = new String[]{"aggregateId", "version"};
        Publisher publisher = $this$createAggregateIdAndVersionUniqueIndex.createIndex(Indexes.ascending((String[])stringArray), uniqueIndexOptions);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(Indexes.asce\u2026ION), uniqueIndexOptions)");
        BlockingMonoMethodAccessorKt.asBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createRequestIdUniqueIndex(@NotNull MongoCollection<Document> $this$createRequestIdUniqueIndex) {
        Intrinsics.checkNotNullParameter($this$createRequestIdUniqueIndex, (String)"<this>");
        String[] stringArray = new String[]{"requestId"};
        Publisher publisher = $this$createRequestIdUniqueIndex.createIndex(Indexes.ascending((String[])stringArray), uniqueIndexOptions);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(Indexes.asce\u2026_ID), uniqueIndexOptions)");
        BlockingMonoMethodAccessorKt.asBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createAggregateIdAndRequestIdUniqueIndex(@NotNull MongoCollection<Document> $this$createAggregateIdAndRequestIdUniqueIndex) {
        Intrinsics.checkNotNullParameter($this$createAggregateIdAndRequestIdUniqueIndex, (String)"<this>");
        String[] stringArray = new String[]{"aggregateId", "requestId"};
        Publisher publisher = $this$createAggregateIdAndRequestIdUniqueIndex.createIndex(Indexes.ascending((String[])stringArray), uniqueIndexOptions);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(Indexes.asce\u2026_ID), uniqueIndexOptions)");
        BlockingMonoMethodAccessorKt.asBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    public final void createTenantIdIndex(@NotNull MongoCollection<Document> $this$createTenantIdIndex) {
        Intrinsics.checkNotNullParameter($this$createTenantIdIndex, (String)"<this>");
        Publisher publisher = $this$createTenantIdIndex.createIndex(Indexes.hashed((String)"tenantId"));
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"createIndex(Indexes.hash\u2026essageRecords.TENANT_ID))");
        BlockingMonoMethodAccessorKt.asBlockable$default((Mono)MonoExtensionsKt.toMono((Publisher)publisher), null, (int)1, null).block();
    }

    static {
        IndexOptions indexOptions = new IndexOptions().unique(true);
        Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"IndexOptions().unique(true)");
        uniqueIndexOptions = indexOptions;
    }
}

