/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/mongo/SnapshotSchemaInitializer;", "", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "initAll", "", "initSchema", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "Companion", "wow-mongo"})
public final class SnapshotSchemaInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    private static final Logger log = LoggerFactory.getLogger(SnapshotSchemaInitializer.class);

    public SnapshotSchemaInitializer(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    public final void initAll() {
        MetadataSearcher.INSTANCE.getNamedAggregateType().forEach((arg_0, arg_1) -> SnapshotSchemaInitializer.initAll$lambda$0((Function2)new Function2<MaterializedNamedAggregate, Class<?>, Unit>(this){
            final /* synthetic */ SnapshotSchemaInitializer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MaterializedNamedAggregate namedAggregate, @NotNull Class<?> clazz) {
                Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
                Intrinsics.checkNotNullParameter(clazz, (String)"<anonymous parameter 1>");
                this.this$0.initSchema((NamedAggregate)namedAggregate);
            }
        }, arg_0, arg_1));
    }

    public final void initSchema(@NotNull NamedAggregate namedAggregate) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        String collectionName = AggregateSchemaInitializer.INSTANCE.asSnapshotCollectionName(namedAggregate);
        if (log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{namedAggregate, this.database.getName(), collectionName};
            log.info("Init NamedAggregate Schema [{}] to Database:[{}] CollectionName [{}]", objectArray);
        }
        if (!AggregateSchemaInitializer.INSTANCE.ensureCollection(this.database, collectionName)) {
            return;
        }
        MongoCollection snapshotCollection = this.database.getCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)snapshotCollection, (String)"snapshotCollection");
        AggregateSchemaInitializer.INSTANCE.createTenantIdIndex((MongoCollection<Document>)snapshotCollection);
    }

    private static final void initAll$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/mongo/SnapshotSchemaInitializer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

