/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.AbstractEventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.mongo.AggregateSchemaInitializer;
import me.ahoo.wow.mongo.Documents;
import me.ahoo.wow.mongo.MongoEventStore;
import me.ahoo.wow.serialization.JsonSerializerKt;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/ahoo/wow/mongo/MongoEventStore;", "Lme/ahoo/wow/eventsourcing/AbstractEventStore;", "database", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "(Lcom/mongodb/reactivestreams/client/MongoDatabase;)V", "appendStream", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "loadStream", "Lreactor/core/publisher/Flux;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "headVersion", "", "tailVersion", "scanAggregateId", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "cursorId", "", "limit", "Companion", "wow-mongo"})
public final class MongoEventStore
extends AbstractEventStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private static final String SIZE_FIELD = "size";

    public MongoEventStore(@NotNull MongoDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    protected Mono<Void> appendStream(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName((NamedAggregate)eventStream);
        String eventStreamJson = JsonSerializerKt.toJsonString((Object)eventStream);
        Document document = Document.parse((String)eventStreamJson);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = Documents.INSTANCE.replaceIdToPrimaryKey(document).append(SIZE_FIELD, (Object)eventStream.getSize());
        Publisher publisher = this.database.getCollection(eventStreamCollectionName).insertOne((Object)document2);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"insertOne(...)");
        Mono mono = MonoExtensionsKt.toMono((Publisher)publisher).doOnNext(arg_0 -> MongoEventStore.appendStream$lambda$0(appendStream.1.INSTANCE, arg_0)).onErrorMap(MongoWriteException.class, arg_0 -> MongoEventStore.appendStream$lambda$1((Function1)new Function1<MongoWriteException, Throwable>(eventStream){
            final /* synthetic */ DomainEventStream $eventStream;
            {
                this.$eventStream = $eventStream;
                super(1);
            }

            public final Throwable invoke(MongoWriteException it) {
                if (ErrorCategory.fromErrorCode((int)it.getCode()) != ErrorCategory.DUPLICATE_KEY) {
                    return (Throwable)it;
                }
                String string = it.getMessage();
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"aggregateId_1_version_1", (boolean)false, (int)2, null)) {
                    return (Throwable)new EventVersionConflictException(this.$eventStream, (Throwable)it);
                }
                String string2 = it.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"requestId_1", (boolean)false, (int)2, null)) {
                    return (Throwable)new DuplicateRequestIdException(this.$eventStream.getAggregateId(), this.$eventStream.getRequestId(), (Throwable)it);
                }
                return (Throwable)it;
            }
        }, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    protected Flux<DomainEventStream> loadStream(@NotNull AggregateId aggregateId, int headVersion, int tailVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName((NamedAggregate)aggregateId);
        int limit = tailVersion - headVersion + 1;
        Bson[] bsonArray = new Bson[]{Filters.eq((String)"aggregateId", (Object)aggregateId.getId()), Filters.gte((String)"version", (Object)headVersion), Filters.lte((String)"version", (Object)tailVersion)};
        FindPublisher findPublisher = this.database.getCollection(eventStreamCollectionName).find(Filters.and((Bson[])bsonArray)).limit(limit).batchSize(limit);
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"batchSize(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)).map(arg_0 -> MongoEventStore.loadStream$lambda$2((Function1)new Function1<Document, DomainEventStream>(aggregateId){
            final /* synthetic */ AggregateId $aggregateId;
            {
                this.$aggregateId = $aggregateId;
                super(1);
            }

            public final DomainEventStream invoke(Document it) {
                Intrinsics.checkNotNull((Object)it);
                String string = Documents.INSTANCE.replacePrimaryKeyToId(it).toJson();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                String $this$toObject$iv = string;
                boolean $i$f$toObject = false;
                DomainEventStream domainEventStream = (DomainEventStream)JsonSerializerKt.toObject((String)$this$toObject$iv, DomainEventStream.class);
                boolean bl = Intrinsics.areEqual((Object)domainEventStream.getAggregateId(), (Object)this.$aggregateId);
                AggregateId aggregateId = this.$aggregateId;
                if (!bl) {
                    boolean bl2 = false;
                    String string2 = "aggregateId is not match! aggregateId: " + aggregateId + ", domainEventStream: " + domainEventStream.getAggregateId();
                    throw new IllegalArgumentException(string2.toString());
                }
                return domainEventStream;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flux<AggregateId> scanAggregateId(@NotNull NamedAggregate namedAggregate, @NotNull String cursorId, int limit) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter((Object)cursorId, (String)"cursorId");
        String eventStreamCollectionName = AggregateSchemaInitializer.INSTANCE.toEventStreamCollectionName(namedAggregate);
        Object[] objectArray = new Bson[4];
        objectArray[0] = Aggregates.match((Bson)Filters.gt((String)"aggregateId", (Object)cursorId));
        Object[] objectArray2 = new BsonField[]{new BsonField("tenantId", (Bson)new Document("$first", (Object)"$tenantId"))};
        objectArray[1] = Aggregates.group((Object)"$aggregateId", (BsonField[])objectArray2);
        objectArray2 = new String[]{"_id"};
        objectArray[2] = Aggregates.sort((Bson)Sorts.ascending((String[])objectArray2));
        objectArray[3] = Aggregates.limit((int)limit);
        AggregatePublisher aggregatePublisher = this.database.getCollection(eventStreamCollectionName).aggregate(CollectionsKt.listOf((Object[])objectArray)).batchSize(limit);
        Intrinsics.checkNotNullExpressionValue((Object)aggregatePublisher, (String)"batchSize(...)");
        Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)aggregatePublisher)).map(arg_0 -> MongoEventStore.scanAggregateId$lambda$3((Function1)new Function1<Document, AggregateId>(namedAggregate){
            final /* synthetic */ NamedAggregate $namedAggregate;
            {
                this.$namedAggregate = $namedAggregate;
                super(1);
            }

            public final AggregateId invoke(Document it) {
                String string = it.getString((Object)"_id");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                String string2 = it.getString((Object)"tenantId");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                return (AggregateId)DefaultAggregateIdKt.aggregateId((NamedAggregate)this.$namedAggregate, (String)string, (String)string2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    private static final void appendStream$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Throwable appendStream$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final DomainEventStream loadStream$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DomainEventStream)$tmp0.invoke(p0);
    }

    private static final AggregateId scanAggregateId$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateId)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/mongo/MongoEventStore$Companion;", "", "()V", "SIZE_FIELD", "", "wow-mongo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

