/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.mongodb.client.model.Filters;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.IPagedQuery;
import me.ahoo.wow.api.query.IQuery;
import me.ahoo.wow.api.query.PagedList;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.query.MongoFilterConverter;
import me.ahoo.wow.mongo.query.MongoSnapshotQueryService;
import me.ahoo.wow.query.SnapshotQueryService;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u000e0\u0007\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0012H\u0016J.\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u0014\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J.\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u0007\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/mongo/query/MongoSnapshotQueryService;", "Lme/ahoo/wow/query/SnapshotQueryService;", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "(Lcom/mongodb/reactivestreams/client/MongoCollection;)V", "count", "Lreactor/core/publisher/Mono;", "", "tenantId", "", "condition", "Lme/ahoo/wow/api/query/Condition;", "pagedQuery", "Lme/ahoo/wow/api/query/PagedList;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "S", "", "Lme/ahoo/wow/api/query/IPagedQuery;", "query", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/api/query/IQuery;", "single", "withTenantId", "Lorg/bson/conversions/Bson;", "wow-mongo"})
public final class MongoSnapshotQueryService
implements SnapshotQueryService {
    @NotNull
    private final MongoCollection<Document> collection;

    public MongoSnapshotQueryService(@NotNull MongoCollection<Document> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.collection = collection;
    }

    private final Bson withTenantId(Bson $this$withTenantId, String tenantId) {
        Bson bson = Filters.eq((String)"tenantId", (Object)tenantId);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        Bson tenantIdFilter = bson;
        Bson[] bsonArray = new Bson[]{tenantIdFilter, $this$withTenantId};
        Bson bson2 = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"and(...)");
        return bson2;
    }

    @NotNull
    public <S> Mono<Snapshot<S>> single(@NotNull String tenantId, @NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(condition), tenantId);
        Publisher publisher = this.collection.find(filter).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        return DocumentsKt.toSnapshot((Mono<Document>)MonoExtensionsKt.toMono((Publisher)publisher));
    }

    @NotNull
    public <S> Flux<Snapshot<S>> query(@NotNull String tenantId, @NotNull IQuery query) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(query.getCondition()), tenantId);
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(query.getSort());
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).limit(query.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        return DocumentsKt.toSnapshot((Flux<Document>)FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)));
    }

    @NotNull
    public <S> Mono<PagedList<Snapshot<S>>> pagedQuery(@NotNull String tenantId, @NotNull IPagedQuery pagedQuery2) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)pagedQuery2, (String)"pagedQuery");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(pagedQuery2.getCondition()), tenantId);
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(pagedQuery2.getSort());
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        Mono totalPublisher = MonoExtensionsKt.toMono((Publisher)publisher);
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).skip(pagedQuery2.getPagination().offset()).limit(pagedQuery2.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Mono mono = DocumentsKt.toSnapshot((Flux<Document>)FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher))).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        Mono listPublisher = mono;
        Mono mono2 = Mono.zip((Mono)totalPublisher, (Mono)listPublisher).map(arg_0 -> MongoSnapshotQueryService.pagedQuery$lambda$0(pagedQuery.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"map(...)");
        return mono2;
    }

    @NotNull
    public Mono<Long> count(@NotNull String tenantId, @NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(condition), tenantId);
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    private static final PagedList pagedQuery$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PagedList)$tmp0.invoke(p0);
    }
}

