/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.IPagedQuery;
import me.ahoo.wow.api.query.IQuery;
import me.ahoo.wow.api.query.PagedList;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.query.MongoConditionConverter;
import me.ahoo.wow.mongo.query.MongoFilterConverter;
import me.ahoo.wow.mongo.query.MongoSnapshotQueryService;
import me.ahoo.wow.query.ConditionConverter;
import me.ahoo.wow.query.SnapshotQueryService;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u00150\u00102\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u00192\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lme/ahoo/wow/mongo/query/MongoSnapshotQueryService;", "S", "", "Lme/ahoo/wow/query/SnapshotQueryService;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "converter", "Lme/ahoo/wow/query/ConditionConverter;", "Lorg/bson/conversions/Bson;", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lcom/mongodb/reactivestreams/client/MongoCollection;Lme/ahoo/wow/query/ConditionConverter;)V", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "count", "Lreactor/core/publisher/Mono;", "", "condition", "Lme/ahoo/wow/api/query/Condition;", "pagedQuery", "Lme/ahoo/wow/api/query/PagedList;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "Lme/ahoo/wow/api/query/IPagedQuery;", "query", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/api/query/IQuery;", "single", "wow-mongo"})
public final class MongoSnapshotQueryService<S>
implements SnapshotQueryService<S> {
    @NotNull
    private final NamedAggregate namedAggregate;
    @NotNull
    private final MongoCollection<Document> collection;
    @NotNull
    private final ConditionConverter<Bson> converter;

    public MongoSnapshotQueryService(@NotNull NamedAggregate namedAggregate, @NotNull MongoCollection<Document> collection, @NotNull ConditionConverter<Bson> converter) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.namedAggregate = namedAggregate;
        this.collection = collection;
        this.converter = converter;
    }

    public /* synthetic */ MongoSnapshotQueryService(NamedAggregate namedAggregate, MongoCollection mongoCollection, ConditionConverter conditionConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            conditionConverter = MongoConditionConverter.INSTANCE;
        }
        this(namedAggregate, (MongoCollection<Document>)mongoCollection, (ConditionConverter<Bson>)conditionConverter);
    }

    @NotNull
    public NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public Mono<Snapshot<S>> single(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson filter = (Bson)this.converter.convert(condition);
        Publisher publisher = this.collection.find(filter).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        return DocumentsKt.toSnapshot((Mono<Document>)MonoExtensionsKt.toMono((Publisher)publisher));
    }

    @NotNull
    public Flux<Snapshot<S>> query(@NotNull IQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Bson filter = (Bson)this.converter.convert(query.getCondition());
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(query.getSort());
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).limit(query.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        return DocumentsKt.toSnapshot((Flux<Document>)FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)));
    }

    @NotNull
    public Mono<PagedList<Snapshot<S>>> pagedQuery(@NotNull IPagedQuery pagedQuery2) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery2, (String)"pagedQuery");
        Bson filter = (Bson)this.converter.convert(pagedQuery2.getCondition());
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(pagedQuery2.getSort());
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        Mono totalPublisher = MonoExtensionsKt.toMono((Publisher)publisher);
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).skip(pagedQuery2.getPagination().offset()).limit(pagedQuery2.getPagination().getSize());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Mono mono = DocumentsKt.toSnapshot((Flux<Document>)FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher))).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        Mono listPublisher = mono;
        Mono mono2 = Mono.zip((Mono)totalPublisher, (Mono)listPublisher).map(arg_0 -> MongoSnapshotQueryService.pagedQuery$lambda$0(pagedQuery.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"map(...)");
        return mono2;
    }

    @NotNull
    public Mono<Long> count(@NotNull Condition condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Bson filter = (Bson)this.converter.convert(condition);
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    private static final PagedList pagedQuery$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PagedList)$tmp0.invoke(p0);
    }
}

