/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.mongo.query;

import com.mongodb.client.model.Filters;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.query.Condition;
import me.ahoo.wow.api.query.IPagedQuery;
import me.ahoo.wow.api.query.IQuery;
import me.ahoo.wow.api.query.PagedList;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.mongo.DocumentsKt;
import me.ahoo.wow.mongo.query.MongoFilterConverter;
import me.ahoo.wow.mongo.query.MongoSnapshotQueryService;
import me.ahoo.wow.query.SnapshotQueryService;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\t2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00142\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/mongo/query/MongoSnapshotQueryService;", "S", "", "Lme/ahoo/wow/query/SnapshotQueryService;", "collection", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "(Lcom/mongodb/reactivestreams/client/MongoCollection;)V", "count", "Lreactor/core/publisher/Mono;", "", "condition", "Lme/ahoo/wow/api/query/Condition;", "tenantId", "", "pagedQuery", "Lme/ahoo/wow/api/query/PagedList;", "Lme/ahoo/wow/eventsourcing/snapshot/Snapshot;", "Lme/ahoo/wow/api/query/IPagedQuery;", "query", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/api/query/IQuery;", "single", "withTenantId", "Lorg/bson/conversions/Bson;", "wow-mongo"})
public final class MongoSnapshotQueryService<S>
implements SnapshotQueryService<S> {
    @NotNull
    private final MongoCollection<Document> collection;

    public MongoSnapshotQueryService(@NotNull MongoCollection<Document> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.collection = collection;
    }

    private final Bson withTenantId(Bson $this$withTenantId, String tenantId) {
        Bson bson = Filters.eq((String)"tenantId", (Object)tenantId);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        Bson tenantIdFilter = bson;
        Bson[] bsonArray = new Bson[]{tenantIdFilter, $this$withTenantId};
        Bson bson2 = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"and(...)");
        return bson2;
    }

    @NotNull
    public Mono<Snapshot<S>> single(@NotNull Condition condition, @NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(condition), tenantId);
        Publisher publisher = this.collection.find(filter).limit(1).first();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"first(...)");
        return DocumentsKt.toSnapshot((Mono<Document>)MonoExtensionsKt.toMono((Publisher)publisher));
    }

    @NotNull
    public Flux<Snapshot<S>> query(@NotNull IQuery query, @NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(query.getCondition()), tenantId);
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(query.getSort());
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).limit(query.getLimit());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        return DocumentsKt.toSnapshot((Flux<Document>)FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher)));
    }

    @NotNull
    public Mono<PagedList<Snapshot<S>>> pagedQuery(@NotNull IPagedQuery pagedQuery2, @NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)pagedQuery2, (String)"pagedQuery");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(pagedQuery2.getCondition()), tenantId);
        Bson sort = MongoFilterConverter.INSTANCE.toMongoSort(pagedQuery2.getSort());
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        Mono totalPublisher = MonoExtensionsKt.toMono((Publisher)publisher);
        FindPublisher findPublisher = this.collection.find(filter).sort(sort).skip(pagedQuery2.getPagination().offset()).limit(pagedQuery2.getPagination().getSize());
        Intrinsics.checkNotNullExpressionValue((Object)findPublisher, (String)"limit(...)");
        Mono mono = DocumentsKt.toSnapshot((Flux<Document>)FluxExtensionsKt.toFlux((Publisher)((Publisher)findPublisher))).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        Mono listPublisher = mono;
        Mono mono2 = Mono.zip((Mono)totalPublisher, (Mono)listPublisher).map(arg_0 -> MongoSnapshotQueryService.pagedQuery$lambda$0(pagedQuery.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"map(...)");
        return mono2;
    }

    @NotNull
    public Mono<Long> count(@NotNull Condition condition, @NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Bson filter = this.withTenantId(MongoFilterConverter.INSTANCE.toMongoFilter(condition), tenantId);
        Publisher publisher = this.collection.countDocuments(filter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"countDocuments(...)");
        return MonoExtensionsKt.toMono((Publisher)publisher);
    }

    private static final PagedList pagedQuery$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PagedList)$tmp0.invoke(p0);
    }
}

